/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.MyRegexEngine;
import com.tonicsystems.jarjar.regex.Matcher;
import com.tonicsystems.jarjar.regex.Pattern;
import com.tonicsystems.jarjar.regex.RegexEngine;
import java.util.ArrayList;
import java.util.Arrays;

class Wildcard {
    private static RegexEngine REGEX = MyRegexEngine.getInstance();
    public static final int STYLE_DESC = 0;
    public static final int STYLE_IDENTIFIER = 1;
    private static Pattern dots = REGEX.compile("\\.");
    private static Pattern tilde = REGEX.compile("~");
    private static Pattern dstar = REGEX.compile("\\*\\*");
    private static Pattern star = REGEX.compile("\\*");
    private Pattern descPattern;
    private Pattern identifierPattern;
    private int count;
    private ArrayList parts = new ArrayList(16);
    private String[] strings;
    private int[] refs;

    public Wildcard(String pattern, String result) {
        this.compilePattern(pattern);
        this.compileResult(result);
    }

    public boolean matches(String value, int style) {
        return this.getPattern(style).matches(value);
    }

    public String replace(String value, int style) {
        Matcher matcher = this.getPattern(style).getMatcher(value);
        return matcher.matches() ? this.replace(value, style, matcher) : null;
    }

    private Pattern getPattern(int style) {
        switch (style) {
            case 0: {
                return this.descPattern;
            }
            case 1: {
                return this.identifierPattern;
            }
        }
        throw new IllegalArgumentException("Unknown style " + style);
    }

    private String replace(String value, int style, Matcher match) {
        StringBuffer sb = new StringBuffer();
        sb.append(value.substring(0, match.start()));
        sb.append(match.group(1));
        for (int i = 0; i < this.strings.length; ++i) {
            int ref = this.refs[i];
            if (ref == 0) {
                String s = match.group(0);
                s = s.substring(match.group(1).length(), s.length() - match.group(this.count).length());
                sb.append(this.postProcess(s, style));
                continue;
            }
            if (ref > 0) {
                sb.append(this.postProcess(match.group(ref + 1), style));
                continue;
            }
            sb.append(this.postProcess(this.strings[i], style));
        }
        sb.append(match.group(this.count));
        sb.append(value.substring(match.end()));
        return sb.toString();
    }

    private String postProcess(String value, int style) {
        value = style == 1 ? value.replace('/', '.') : value.replace('.', '/');
        return value;
    }

    private void compilePattern(String expr) {
        if (expr.equals("**")) {
            throw new IllegalArgumentException("'**' is not a valid pattern");
        }
        int len = expr.length();
        block3: for (int i = 0; i < len; ++i) {
            char ch = expr.charAt(i);
            switch (ch) {
                case '*': 
                case '.': {
                    continue block3;
                }
                default: {
                    if (Character.isJavaIdentifierPart(ch)) continue block3;
                    throw new IllegalArgumentException("Not a valid package pattern: " + expr);
                }
            }
        }
        if (expr.indexOf("***") >= 0) {
            throw new IllegalArgumentException("The sequence '***' is invalid in a package pattern");
        }
        String p1 = expr;
        p1 = dots.replaceAll(p1, "~");
        p1 = dstar.replaceAll(p1, "(.+?)");
        String p2 = p1 = star.replaceAll(p1, "([^/]+?)");
        p2 = tilde.replaceAll(p2, "\\.");
        p1 = tilde.replaceAll(p1, "/");
        p1 = "(\\[*L)" + p1 + "(;)";
        p1 = "\\A" + p1 + "\\Z";
        p2 = "\\A()" + p2 + "()\\b\\Z";
        this.descPattern = REGEX.compile(p1);
        this.identifierPattern = REGEX.compile(p2);
        this.count = this.descPattern.groupCount();
    }

    private void compileResult(String value) {
        char[] chars = value.toCharArray();
        int max = 0;
        int mark = 0;
        boolean state = false;
        int len = chars.length;
        block3: for (int i = 0; i < len + 1; ++i) {
            int ch;
            int n = ch = i == len ? 64 : chars[i];
            if (!state) {
                if (ch != 64) continue;
                this.parts.add(new String(chars, mark, i - mark));
                mark = i + 1;
                state = true;
                continue;
            }
            switch (ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
                default: {
                    if (i == mark) {
                        throw new IllegalArgumentException("Backslash not followed by a digit");
                    }
                    int n2 = Integer.parseInt(new String(chars, mark, i - mark));
                    if (n2 > max) {
                        max = n2;
                    }
                    this.parts.add(new Integer(n2));
                    --i;
                    state = false;
                }
            }
        }
        int size = this.parts.size();
        this.strings = new String[size];
        this.refs = new int[size];
        Arrays.fill(this.refs, -1);
        for (int i = 0; i < size; ++i) {
            Object v = this.parts.get(i);
            if (v instanceof String) {
                this.strings[i] = (String)v;
                continue;
            }
            this.refs[i] = (Integer)v;
        }
        if (this.count < max) {
            throw new IllegalArgumentException("Result includes impossible placeholder \"@" + max + "\": " + value);
        }
    }

    public String toString() {
        return "Wildcard{descPattern=" + this.descPattern + ",identifierPattern=" + this.identifierPattern + ",parts=" + this.parts + "}";
    }
}

