/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Native;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_ast_kind;

public class AST
extends Z3Object
implements Comparable<AST> {
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AST)) {
            return false;
        }
        AST casted = (AST)o;
        return this.getContext().nCtx() == casted.getContext().nCtx() && Native.isEqAst(this.getContext().nCtx(), this.getNativeObject(), casted.getNativeObject());
    }

    @Override
    public int compareTo(AST other) {
        if (other == null) {
            return 1;
        }
        return Integer.compare(this.getId(), other.getId());
    }

    public int hashCode() {
        return Native.getAstHash(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getId() {
        return Native.getAstId(this.getContext().nCtx(), this.getNativeObject());
    }

    public AST translate(Context ctx) {
        if (this.getContext() == ctx) {
            return this;
        }
        return AST.create(ctx, Native.translate(this.getContext().nCtx(), this.getNativeObject(), ctx.nCtx()));
    }

    public Z3_ast_kind getASTKind() {
        return Z3_ast_kind.fromInt(Native.getAstKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isExpr() {
        switch (this.getASTKind()) {
            case Z3_APP_AST: 
            case Z3_NUMERAL_AST: 
            case Z3_QUANTIFIER_AST: 
            case Z3_VAR_AST: {
                return true;
            }
        }
        return false;
    }

    public boolean isApp() {
        return this.getASTKind() == Z3_ast_kind.Z3_APP_AST;
    }

    public boolean isVar() {
        return this.getASTKind() == Z3_ast_kind.Z3_VAR_AST;
    }

    public boolean isQuantifier() {
        return this.getASTKind() == Z3_ast_kind.Z3_QUANTIFIER_AST;
    }

    public boolean isSort() {
        return this.getASTKind() == Z3_ast_kind.Z3_SORT_AST;
    }

    public boolean isFuncDecl() {
        return this.getASTKind() == Z3_ast_kind.Z3_FUNC_DECL_AST;
    }

    public String toString() {
        return Native.astToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public String getSExpr() {
        return Native.astToString(this.getContext().nCtx(), this.getNativeObject());
    }

    AST(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
        Native.incRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getASTDRQ().storeReference(this.getContext(), this);
    }

    static AST create(Context ctx, long obj) {
        switch (Z3_ast_kind.fromInt(Native.getAstKind(ctx.nCtx(), obj))) {
            case Z3_FUNC_DECL_AST: {
                return new FuncDecl(ctx, obj);
            }
            case Z3_QUANTIFIER_AST: {
                return new Quantifier(ctx, obj);
            }
            case Z3_SORT_AST: {
                return Sort.create(ctx, obj);
            }
            case Z3_APP_AST: 
            case Z3_NUMERAL_AST: 
            case Z3_VAR_AST: {
                return Expr.create(ctx, obj);
            }
        }
        throw new Z3Exception("Unknown AST kind");
    }
}

