/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_parameter_kind;

public class FuncDecl<R extends Sort>
extends AST {
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuncDecl)) {
            return false;
        }
        FuncDecl other = (FuncDecl)o;
        return this.getContext().nCtx() == other.getContext().nCtx() && Native.isEqFuncDecl(this.getContext().nCtx(), this.getNativeObject(), other.getNativeObject());
    }

    @Override
    public String toString() {
        return Native.funcDeclToString(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    public int getId() {
        return Native.getFuncDeclId(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    public FuncDecl<R> translate(Context ctx) {
        return (FuncDecl)super.translate(ctx);
    }

    public int getArity() {
        return Native.getArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getDomainSize() {
        return Native.getDomainSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort[] getDomain() {
        int n = this.getDomainSize();
        Sort[] res = new Sort[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Sort.create(this.getContext(), Native.getDomain(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public R getRange() {
        return (R)Sort.create(this.getContext(), Native.getRange(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Z3_decl_kind getDeclKind() {
        return Z3_decl_kind.fromInt(Native.getDeclKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Symbol getName() {
        return Symbol.create(this.getContext(), Native.getDeclName(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumParameters() {
        return Native.getDeclNumParameters(this.getContext().nCtx(), this.getNativeObject());
    }

    public Parameter[] getParameters() {
        int num = this.getNumParameters();
        Parameter[] res = new Parameter[num];
        block9: for (int i = 0; i < num; ++i) {
            Z3_parameter_kind k = Z3_parameter_kind.fromInt(Native.getDeclParameterKind(this.getContext().nCtx(), this.getNativeObject(), i));
            switch (k) {
                case Z3_PARAMETER_INT: {
                    res[i] = new Parameter(k, Native.getDeclIntParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_DOUBLE: {
                    res[i] = new Parameter(k, Native.getDeclDoubleParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_SYMBOL: {
                    res[i] = new Parameter(k, Symbol.create(this.getContext(), Native.getDeclSymbolParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_SORT: {
                    res[i] = new Parameter(k, Sort.create(this.getContext(), Native.getDeclSortParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_AST: {
                    res[i] = new Parameter(k, new AST(this.getContext(), Native.getDeclAstParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_FUNC_DECL: {
                    res[i] = new Parameter(k, new FuncDecl<R>(this.getContext(), Native.getDeclFuncDeclParameter(this.getContext().nCtx(), this.getNativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_RATIONAL: {
                    res[i] = new Parameter(k, Native.getDeclRationalParameter(this.getContext().nCtx(), this.getNativeObject(), i));
                    continue block9;
                }
                default: {
                    throw new Z3Exception("Unknown function declaration parameter kind encountered");
                }
            }
        }
        return res;
    }

    FuncDecl(Context ctx, long obj) {
        super(ctx, obj);
    }

    FuncDecl(Context ctx, Symbol name, Sort[] domain, R range) {
        super(ctx, Native.mkFuncDecl(ctx.nCtx(), name.getNativeObject(), AST.arrayLength(domain), AST.arrayToNative(domain), ((Z3Object)range).getNativeObject()));
    }

    FuncDecl(Context ctx, Symbol name, Sort[] domain, R range, boolean is_rec) {
        super(ctx, Native.mkRecFuncDecl(ctx.nCtx(), name.getNativeObject(), AST.arrayLength(domain), AST.arrayToNative(domain), ((Z3Object)range).getNativeObject()));
    }

    FuncDecl(Context ctx, String prefix, Sort[] domain, R range) {
        super(ctx, Native.mkFreshFuncDecl(ctx.nCtx(), prefix, AST.arrayLength(domain), AST.arrayToNative(domain), ((Z3Object)range).getNativeObject()));
    }

    @Override
    void checkNativeObject(long obj) {
        if (Native.getAstKind(this.getContext().nCtx(), obj) != Z3_ast_kind.Z3_FUNC_DECL_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a function declaration");
        }
        super.checkNativeObject(obj);
    }

    public Expr<R> apply(Expr<?> ... args) {
        this.getContext().checkContextMatch(args);
        return Expr.create(this.getContext(), this, args);
    }

    public static class Parameter {
        private Z3_parameter_kind kind;
        private int i;
        private double d;
        private Symbol sym;
        private Sort srt;
        private AST ast;
        private FuncDecl<?> fd;
        private String r;

        public int getInt() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_INT) {
                throw new Z3Exception("parameter is not an int");
            }
            return this.i;
        }

        public double getDouble() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_DOUBLE) {
                throw new Z3Exception("parameter is not a double ");
            }
            return this.d;
        }

        public Symbol getSymbol() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SYMBOL) {
                throw new Z3Exception("parameter is not a Symbol");
            }
            return this.sym;
        }

        public Sort getSort() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SORT) {
                throw new Z3Exception("parameter is not a Sort");
            }
            return this.srt;
        }

        public AST getAST() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_AST) {
                throw new Z3Exception("parameter is not an AST");
            }
            return this.ast;
        }

        public FuncDecl<?> getFuncDecl() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_FUNC_DECL) {
                throw new Z3Exception("parameter is not a function declaration");
            }
            return this.fd;
        }

        public String getRational() {
            if (this.getParameterKind() != Z3_parameter_kind.Z3_PARAMETER_RATIONAL) {
                throw new Z3Exception("parameter is not a rational String");
            }
            return this.r;
        }

        public Z3_parameter_kind getParameterKind() {
            return this.kind;
        }

        Parameter(Z3_parameter_kind k, int i) {
            this.kind = k;
            this.i = i;
        }

        Parameter(Z3_parameter_kind k, double d) {
            this.kind = k;
            this.d = d;
        }

        Parameter(Z3_parameter_kind k, Symbol s) {
            this.kind = k;
            this.sym = s;
        }

        Parameter(Z3_parameter_kind k, Sort s) {
            this.kind = k;
            this.srt = s;
        }

        Parameter(Z3_parameter_kind k, AST a) {
            this.kind = k;
            this.ast = a;
        }

        Parameter(Z3_parameter_kind k, FuncDecl<?> fd) {
            this.kind = k;
            this.fd = fd;
        }

        Parameter(Z3_parameter_kind k, String r) {
            this.kind = k;
            this.r = r;
        }
    }
}

