/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_lbool;

public class Optimize
extends Z3Object {
    public String getHelp() {
        return Native.optimizeGetHelp(this.getContext().nCtx(), this.getNativeObject());
    }

    public void setParameters(Params value) {
        Native.optimizeSetParams(this.getContext().nCtx(), this.getNativeObject(), value.getNativeObject());
    }

    public ParamDescrs getParameterDescriptions() {
        return new ParamDescrs(this.getContext(), Native.optimizeGetParamDescrs(this.getContext().nCtx(), this.getNativeObject()));
    }

    public void Assert(Expr<BoolSort> ... constraints) {
        this.getContext().checkContextMatch(constraints);
        for (Expr<BoolSort> a : constraints) {
            Native.optimizeAssert(this.getContext().nCtx(), this.getNativeObject(), a.getNativeObject());
        }
    }

    public void Add(Expr<BoolSort> ... constraints) {
        this.Assert(constraints);
    }

    public void AssertAndTrack(Expr<BoolSort> constraint, Expr<BoolSort> p) {
        this.getContext().checkContextMatch(constraint);
        this.getContext().checkContextMatch(p);
        Native.optimizeAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), constraint.getNativeObject(), p.getNativeObject());
    }

    public Handle<?> AssertSoft(Expr<BoolSort> constraint, int weight, String group) {
        return this.AssertSoft(constraint, Integer.toString(weight), group);
    }

    public Handle<?> AssertSoft(Expr<BoolSort> constraint, String weight, String group) {
        this.getContext().checkContextMatch(constraint);
        StringSymbol s = this.getContext().mkSymbol(group);
        return new Handle(this, Native.optimizeAssertSoft(this.getContext().nCtx(), this.getNativeObject(), constraint.getNativeObject(), weight, s.getNativeObject()));
    }

    public Status Check(Expr<BoolSort> ... assumptions) {
        Z3_lbool r = assumptions == null ? Z3_lbool.fromInt(Native.optimizeCheck(this.getContext().nCtx(), this.getNativeObject(), 0, null)) : Z3_lbool.fromInt(Native.optimizeCheck(this.getContext().nCtx(), this.getNativeObject(), assumptions.length, AST.arrayToNative(assumptions)));
        switch (r) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    public void Push() {
        Native.optimizePush(this.getContext().nCtx(), this.getNativeObject());
    }

    public void Pop() {
        Native.optimizePop(this.getContext().nCtx(), this.getNativeObject());
    }

    public Model getModel() {
        long x = Native.optimizeGetModel(this.getContext().nCtx(), this.getNativeObject());
        if (x == 0L) {
            return null;
        }
        return new Model(this.getContext(), x);
    }

    public BoolExpr[] getUnsatCore() {
        ASTVector core = new ASTVector(this.getContext(), Native.optimizeGetUnsatCore(this.getContext().nCtx(), this.getNativeObject()));
        return core.ToBoolExprArray();
    }

    public <R extends Sort> Handle<R> MkMaximize(Expr<R> e) {
        return new Handle(this, Native.optimizeMaximize(this.getContext().nCtx(), this.getNativeObject(), e.getNativeObject()));
    }

    public <R extends Sort> Handle<R> MkMinimize(Expr<R> e) {
        return new Handle(this, Native.optimizeMinimize(this.getContext().nCtx(), this.getNativeObject(), e.getNativeObject()));
    }

    private <R extends Sort> Expr<R> GetLower(int index) {
        return Expr.create(this.getContext(), Native.optimizeGetLower(this.getContext().nCtx(), this.getNativeObject(), index));
    }

    private <R extends Sort> Expr<R> GetUpper(int index) {
        return Expr.create(this.getContext(), Native.optimizeGetUpper(this.getContext().nCtx(), this.getNativeObject(), index));
    }

    private Expr<?>[] GetUpperAsVector(int index) {
        return this.unpackObjectiveValueVector(Native.optimizeGetUpperAsVector(this.getContext().nCtx(), this.getNativeObject(), index));
    }

    private Expr<?>[] GetLowerAsVector(int index) {
        return this.unpackObjectiveValueVector(Native.optimizeGetLowerAsVector(this.getContext().nCtx(), this.getNativeObject(), index));
    }

    private Expr<?>[] unpackObjectiveValueVector(long nativeVec) {
        ASTVector vec = new ASTVector(this.getContext(), nativeVec);
        return new Expr[]{(Expr)vec.get(0), (Expr)vec.get(1), (Expr)vec.get(2)};
    }

    public String getReasonUnknown() {
        return Native.optimizeGetReasonUnknown(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        return Native.optimizeToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public void fromFile(String file) {
        Native.optimizeFromFile(this.getContext().nCtx(), this.getNativeObject(), file);
    }

    public void fromString(String s) {
        Native.optimizeFromString(this.getContext().nCtx(), this.getNativeObject(), s);
    }

    public BoolExpr[] getAssertions() {
        ASTVector assertions = new ASTVector(this.getContext(), Native.optimizeGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return assertions.ToBoolExprArray();
    }

    public Expr<?>[] getObjectives() {
        ASTVector objectives = new ASTVector(this.getContext(), Native.optimizeGetObjectives(this.getContext().nCtx(), this.getNativeObject()));
        return objectives.ToExprArray();
    }

    public Statistics getStatistics() {
        return new Statistics(this.getContext(), Native.optimizeGetStatistics(this.getContext().nCtx(), this.getNativeObject()));
    }

    Optimize(Context ctx, long obj) throws Z3Exception {
        super(ctx, obj);
    }

    Optimize(Context ctx) throws Z3Exception {
        super(ctx, Native.mkOptimize(ctx.nCtx()));
    }

    @Override
    void incRef() {
        Native.optimizeIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getOptimizeDRQ().storeReference(this.getContext(), this);
    }

    public static class Handle<R extends Sort> {
        private final Optimize opt;
        private final int handle;

        Handle(Optimize opt, int h) {
            this.opt = opt;
            this.handle = h;
        }

        public Expr<R> getLower() {
            return this.opt.GetLower(this.handle);
        }

        public Expr<R> getUpper() {
            return this.opt.GetUpper(this.handle);
        }

        public Expr<?>[] getUpperAsVector() {
            return this.opt.GetUpperAsVector(this.handle);
        }

        public Expr<?>[] getLowerAsVector() {
            return this.opt.GetLowerAsVector(this.handle);
        }

        public Expr<R> getValue() {
            return this.getLower();
        }

        public String toString() {
            return this.getValue().toString();
        }
    }
}

