/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class Statistics
extends Z3Object {
    public String toString() {
        return Native.statsToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public int size() {
        return Native.statsSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry[] getEntries() {
        int n = this.size();
        Entry[] res = new Entry[n];
        for (int i = 0; i < n; ++i) {
            Entry e;
            String k = Native.statsGetKey(this.getContext().nCtx(), this.getNativeObject(), i);
            if (Native.statsIsUint(this.getContext().nCtx(), this.getNativeObject(), i)) {
                e = new Entry(k, Native.statsGetUintValue(this.getContext().nCtx(), this.getNativeObject(), i));
            } else if (Native.statsIsDouble(this.getContext().nCtx(), this.getNativeObject(), i)) {
                e = new Entry(k, Native.statsGetDoubleValue(this.getContext().nCtx(), this.getNativeObject(), i));
            } else {
                throw new Z3Exception("Unknown data entry value");
            }
            res[i] = e;
        }
        return res;
    }

    public String[] getKeys() {
        int n = this.size();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Native.statsGetKey(this.getContext().nCtx(), this.getNativeObject(), i);
        }
        return res;
    }

    public Entry get(String key) {
        int n = this.size();
        Entry[] es = this.getEntries();
        for (int i = 0; i < n; ++i) {
            if (!es[i].Key.equals(key)) continue;
            return es[i];
        }
        return null;
    }

    Statistics(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
        this.getContext().getStatisticsDRQ().storeReference(this.getContext(), this);
    }

    @Override
    void addToReferenceQueue() {
        Native.statsIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    public class Entry {
        public String Key;
        private boolean m_is_int = false;
        private boolean m_is_double = false;
        private int m_int = 0;
        private double m_double = 0.0;

        public int getUIntValue() {
            return this.m_int;
        }

        public double getDoubleValue() {
            return this.m_double;
        }

        public boolean isUInt() {
            return this.m_is_int;
        }

        public boolean isDouble() {
            return this.m_is_double;
        }

        public String getValueString() {
            if (this.isUInt()) {
                return Integer.toString(this.m_int);
            }
            if (this.isDouble()) {
                return Double.toString(this.m_double);
            }
            throw new Z3Exception("Unknown statistical entry type");
        }

        public String toString() {
            return this.Key + ": " + this.getValueString();
        }

        Entry(String k, int v) {
            this.Key = k;
            this.m_is_int = true;
            this.m_int = v;
        }

        Entry(String k, double v) {
            this.Key = k;
            this.m_is_double = true;
            this.m_double = v;
        }
    }
}

