/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;

public abstract class Z3Object {
    private final Context m_ctx;
    private final long m_n_obj;

    Z3Object(Context ctx, long obj) {
        this.m_ctx = ctx;
        this.checkNativeObject(obj);
        this.m_n_obj = obj;
        this.incRef();
        this.addToReferenceQueue();
    }

    abstract void addToReferenceQueue();

    abstract void incRef();

    void checkNativeObject(long obj) {
    }

    long getNativeObject() {
        return this.m_n_obj;
    }

    static long getNativeObject(Z3Object s) {
        if (s == null) {
            return 0L;
        }
        return s.getNativeObject();
    }

    Context getContext() {
        return this.m_ctx;
    }

    public static long[] arrayToNative(Z3Object[] a) {
        if (a == null) {
            return null;
        }
        long[] an = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            an[i] = a[i] == null ? 0L : a[i].getNativeObject();
        }
        return an;
    }

    public static int arrayLength(Z3Object[] a) {
        return a == null ? 0 : a.length;
    }
}

