/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.ArithSort;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.CharSort;
import com.microsoft.z3.Constructor;
import com.microsoft.z3.ConstructorList;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FPExpr;
import com.microsoft.z3.FPNum;
import com.microsoft.z3.FPRMExpr;
import com.microsoft.z3.FPRMNum;
import com.microsoft.z3.FPRMSort;
import com.microsoft.z3.FPSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.Fixedpoint;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Goal;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Lambda;
import com.microsoft.z3.ListSort;
import com.microsoft.z3.Native;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Probe;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.ReExpr;
import com.microsoft.z3.ReSort;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.SeqExpr;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.SetSort;
import com.microsoft.z3.Simplifier;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.TupleSort;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.util.Map;

public class Context
implements AutoCloseable {
    private long m_ctx;
    static final Object creation_lock = new Object();
    private BoolSort m_boolSort = null;
    private IntSort m_intSort = null;
    private RealSort m_realSort = null;
    private SeqSort<CharSort> m_stringSort = null;
    private Z3ReferenceQueue m_RefQueue = new Z3ReferenceQueue(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context() {
        Object object = creation_lock;
        synchronized (object) {
            this.m_ctx = Native.mkContextRc(0L);
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Context(long m_ctx) {
        Object object = creation_lock;
        synchronized (object) {
            this.m_ctx = m_ctx;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context(Map<String, String> settings) {
        Object object = creation_lock;
        synchronized (object) {
            long cfg = Native.mkConfig();
            for (Map.Entry<String, String> kv : settings.entrySet()) {
                Native.setParamValue(cfg, kv.getKey(), kv.getValue());
            }
            this.m_ctx = Native.mkContextRc(cfg);
            Native.delConfig(cfg);
            this.init();
        }
    }

    private void init() {
        this.setPrintMode(Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT);
        Native.setInternalErrorHandler(this.m_ctx);
    }

    public IntSymbol mkSymbol(int i) {
        return new IntSymbol(this, i);
    }

    public StringSymbol mkSymbol(String name) {
        return new StringSymbol(this, name);
    }

    Symbol[] mkSymbols(String[] names) {
        if (names == null) {
            return new Symbol[0];
        }
        Symbol[] result = new Symbol[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.mkSymbol(names[i]);
        }
        return result;
    }

    public BoolSort getBoolSort() {
        if (this.m_boolSort == null) {
            this.m_boolSort = new BoolSort(this);
        }
        return this.m_boolSort;
    }

    public IntSort getIntSort() {
        if (this.m_intSort == null) {
            this.m_intSort = new IntSort(this);
        }
        return this.m_intSort;
    }

    public RealSort getRealSort() {
        if (this.m_realSort == null) {
            this.m_realSort = new RealSort(this);
        }
        return this.m_realSort;
    }

    public BoolSort mkBoolSort() {
        return new BoolSort(this);
    }

    public CharSort mkCharSort() {
        return new CharSort(this);
    }

    public SeqSort<CharSort> getStringSort() {
        if (this.m_stringSort == null) {
            this.m_stringSort = this.mkStringSort();
        }
        return this.m_stringSort;
    }

    public UninterpretedSort mkUninterpretedSort(Symbol s) {
        this.checkContextMatch(s);
        return new UninterpretedSort(this, s);
    }

    public UninterpretedSort mkUninterpretedSort(String str) {
        return this.mkUninterpretedSort(this.mkSymbol(str));
    }

    public IntSort mkIntSort() {
        return new IntSort(this);
    }

    public RealSort mkRealSort() {
        return new RealSort(this);
    }

    public BitVecSort mkBitVecSort(int size) {
        return new BitVecSort(this, Native.mkBvSort(this.nCtx(), size));
    }

    public final <D extends Sort, R extends Sort> ArraySort<D, R> mkArraySort(D domain, R range) {
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        return new ArraySort<D, R>(this, domain, range);
    }

    public final <R extends Sort> ArraySort<Sort, R> mkArraySort(Sort[] domains, R range) {
        this.checkContextMatch(domains);
        this.checkContextMatch(range);
        return new ArraySort(this, domains, range);
    }

    public SeqSort<CharSort> mkStringSort() {
        return new SeqSort<CharSort>(this, Native.mkStringSort(this.nCtx()));
    }

    public final <R extends Sort> SeqSort<R> mkSeqSort(R s) {
        return new SeqSort(this, Native.mkSeqSort(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> ReSort<R> mkReSort(R s) {
        return new ReSort(this, Native.mkReSort(this.nCtx(), s.getNativeObject()));
    }

    public TupleSort mkTupleSort(Symbol name, Symbol[] fieldNames, Sort[] fieldSorts) {
        this.checkContextMatch(name);
        this.checkContextMatch(fieldNames);
        this.checkContextMatch(fieldSorts);
        return new TupleSort(this, name, fieldNames.length, fieldNames, fieldSorts);
    }

    public final <R> EnumSort<R> mkEnumSort(Symbol name, Symbol ... enumNames) {
        this.checkContextMatch(name);
        this.checkContextMatch(enumNames);
        return new EnumSort(this, name, enumNames);
    }

    public final <R> EnumSort<R> mkEnumSort(String name, String ... enumNames) {
        return new EnumSort(this, this.mkSymbol(name), this.mkSymbols(enumNames));
    }

    public final <R extends Sort> ListSort<R> mkListSort(Symbol name, R elemSort) {
        this.checkContextMatch(name);
        this.checkContextMatch(elemSort);
        return new ListSort(this, name, elemSort);
    }

    public final <R extends Sort> ListSort<R> mkListSort(String name, R elemSort) {
        this.checkContextMatch(elemSort);
        return new ListSort(this, this.mkSymbol(name), elemSort);
    }

    public final <R> FiniteDomainSort<R> mkFiniteDomainSort(Symbol name, long size) {
        this.checkContextMatch(name);
        return new FiniteDomainSort(this, name, size);
    }

    public final <R> FiniteDomainSort<R> mkFiniteDomainSort(String name, long size) {
        return new FiniteDomainSort(this, this.mkSymbol(name), size);
    }

    public final <R> Constructor<R> mkConstructor(Symbol name, Symbol recognizer, Symbol[] fieldNames, Sort[] sorts, int[] sortRefs) {
        return Constructor.of(this, name, recognizer, fieldNames, sorts, sortRefs);
    }

    public final <R> Constructor<R> mkConstructor(String name, String recognizer, String[] fieldNames, Sort[] sorts, int[] sortRefs) {
        return Constructor.of(this, this.mkSymbol(name), this.mkSymbol(recognizer), this.mkSymbols(fieldNames), sorts, sortRefs);
    }

    public final <R> DatatypeSort<R> mkDatatypeSort(Symbol name, Constructor<R>[] constructors) {
        this.checkContextMatch(name);
        this.checkContextMatch(constructors);
        return new DatatypeSort<R>(this, name, constructors);
    }

    public final <R> DatatypeSort<R> mkDatatypeSort(String name, Constructor<R>[] constructors) {
        this.checkContextMatch(constructors);
        return new DatatypeSort<R>(this, this.mkSymbol(name), constructors);
    }

    public DatatypeSort<Object>[] mkDatatypeSorts(Symbol[] names, Constructor<Object>[][] c) {
        this.checkContextMatch(names);
        int n = names.length;
        ConstructorList[] cla = new ConstructorList[n];
        long[] n_constr = new long[n];
        for (int i = 0; i < n; ++i) {
            Z3Object[] constructor = c[i];
            this.checkContextMatch(constructor);
            cla[i] = new ConstructorList(this, (Constructor<R>[])constructor);
            n_constr[i] = cla[i].getNativeObject();
        }
        long[] n_res = new long[n];
        Native.mkDatatypes(this.nCtx(), n, Symbol.arrayToNative(names), n_res, n_constr);
        DatatypeSort[] res = new DatatypeSort[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new DatatypeSort(this, n_res[i]);
        }
        return res;
    }

    public DatatypeSort<Object>[] mkDatatypeSorts(String[] names, Constructor<Object>[][] c) {
        return this.mkDatatypeSorts(this.mkSymbols(names), c);
    }

    public final <F extends Sort, R extends Sort> Expr<R> mkUpdateField(FuncDecl<F> field, Expr<R> t, Expr<F> v) throws Z3Exception {
        return Expr.create(this, Native.datatypeUpdateField(this.nCtx(), field.getNativeObject(), t.getNativeObject(), v.getNativeObject()));
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(Symbol name, Sort[] domain, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, name, domain, range);
    }

    public final <R extends Sort> FuncDecl<R> mkPropagateFunction(Symbol name, Sort[] domain, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        long f = Native.solverPropagateDeclare(this.nCtx(), name.getNativeObject(), AST.arrayLength(domain), AST.arrayToNative(domain), range.getNativeObject());
        return new FuncDecl(this, f);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(Symbol name, Sort domain, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        Sort[] q = new Sort[]{domain};
        return new FuncDecl<R>(this, name, q, range);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(String name, Sort[] domain, R range) {
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, this.mkSymbol(name), domain, range);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(String name, Sort domain, R range) {
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        Sort[] q = new Sort[]{domain};
        return new FuncDecl<R>(this, this.mkSymbol(name), q, range);
    }

    public final <R extends Sort> FuncDecl<R> mkRecFuncDecl(Symbol name, Sort[] domain, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, name, domain, range, true);
    }

    public final <R extends Sort> void AddRecDef(FuncDecl<R> f, Expr<?>[] args, Expr<R> body) {
        this.checkContextMatch(f);
        this.checkContextMatch(args);
        this.checkContextMatch(body);
        long[] argsNative = AST.arrayToNative(args);
        Native.addRecDef(this.nCtx(), f.getNativeObject(), args.length, argsNative, body.getNativeObject());
    }

    public final <R extends Sort> FuncDecl<R> mkFreshFuncDecl(String prefix, Sort[] domain, R range) {
        this.checkContextMatch(domain);
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, prefix, domain, range);
    }

    public final <R extends Sort> FuncDecl<R> mkConstDecl(Symbol name, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, name, null, range);
    }

    public final <R extends Sort> FuncDecl<R> mkConstDecl(String name, R range) {
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, this.mkSymbol(name), null, range);
    }

    public final <R extends Sort> FuncDecl<R> mkFreshConstDecl(String prefix, R range) {
        this.checkContextMatch(range);
        return new FuncDecl<R>(this, prefix, null, range);
    }

    public final <R extends Sort> Expr<R> mkBound(int index, R ty) {
        return Expr.create(this, Native.mkBound(this.nCtx(), index, ty.getNativeObject()));
    }

    @SafeVarargs
    public final Pattern mkPattern(Expr<?> ... terms) {
        if (terms.length == 0) {
            throw new Z3Exception("Cannot create a pattern from zero terms");
        }
        long[] termsNative = AST.arrayToNative(terms);
        return new Pattern(this, Native.mkPattern(this.nCtx(), terms.length, termsNative));
    }

    public final <R extends Sort> Expr<R> mkConst(Symbol name, R range) {
        this.checkContextMatch(name);
        this.checkContextMatch(range);
        return Expr.create(this, Native.mkConst(this.nCtx(), name.getNativeObject(), range.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkConst(String name, R range) {
        return this.mkConst(this.mkSymbol(name), range);
    }

    public final <R extends Sort> Expr<R> mkFreshConst(String prefix, R range) {
        this.checkContextMatch(range);
        return Expr.create(this, Native.mkFreshConst(this.nCtx(), prefix, range.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkConst(FuncDecl<R> f) {
        return this.mkApp(f, null);
    }

    public BoolExpr mkBoolConst(Symbol name) {
        return (BoolExpr)this.mkConst(name, this.getBoolSort());
    }

    public BoolExpr mkBoolConst(String name) {
        return (BoolExpr)this.mkConst(this.mkSymbol(name), this.getBoolSort());
    }

    public IntExpr mkIntConst(Symbol name) {
        return (IntExpr)this.mkConst(name, this.getIntSort());
    }

    public IntExpr mkIntConst(String name) {
        return (IntExpr)this.mkConst(name, this.getIntSort());
    }

    public RealExpr mkRealConst(Symbol name) {
        return (RealExpr)this.mkConst(name, this.getRealSort());
    }

    public RealExpr mkRealConst(String name) {
        return (RealExpr)this.mkConst(name, this.getRealSort());
    }

    public BitVecExpr mkBVConst(Symbol name, int size) {
        return (BitVecExpr)this.mkConst(name, this.mkBitVecSort(size));
    }

    public BitVecExpr mkBVConst(String name, int size) {
        return (BitVecExpr)this.mkConst(name, this.mkBitVecSort(size));
    }

    @SafeVarargs
    public final <R extends Sort> Expr<R> mkApp(FuncDecl<R> f, Expr<?> ... args) {
        this.checkContextMatch(f);
        this.checkContextMatch(args);
        return Expr.create(this, f, args);
    }

    public BoolExpr mkTrue() {
        return new BoolExpr(this, Native.mkTrue(this.nCtx()));
    }

    public BoolExpr mkFalse() {
        return new BoolExpr(this, Native.mkFalse(this.nCtx()));
    }

    public BoolExpr mkBool(boolean value) {
        return value ? this.mkTrue() : this.mkFalse();
    }

    public BoolExpr mkEq(Expr<?> x, Expr<?> y) {
        this.checkContextMatch(x);
        this.checkContextMatch(y);
        return new BoolExpr(this, Native.mkEq(this.nCtx(), x.getNativeObject(), y.getNativeObject()));
    }

    @SafeVarargs
    public final BoolExpr mkDistinct(Expr<?> ... args) {
        this.checkContextMatch(args);
        return new BoolExpr(this, Native.mkDistinct(this.nCtx(), args.length, AST.arrayToNative(args)));
    }

    public final BoolExpr mkNot(Expr<BoolSort> a) {
        this.checkContextMatch(a);
        return new BoolExpr(this, Native.mkNot(this.nCtx(), a.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkITE(Expr<BoolSort> t1, Expr<? extends R> t2, Expr<? extends R> t3) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        this.checkContextMatch(t3);
        return Expr.create(this, Native.mkIte(this.nCtx(), t1.getNativeObject(), t2.getNativeObject(), t3.getNativeObject()));
    }

    public BoolExpr mkIff(Expr<BoolSort> t1, Expr<BoolSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkIff(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkImplies(Expr<BoolSort> t1, Expr<BoolSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkImplies(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkXor(Expr<BoolSort> t1, Expr<BoolSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkXor(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    @SafeVarargs
    public final BoolExpr mkAnd(Expr<BoolSort> ... t) {
        this.checkContextMatch(t);
        return new BoolExpr(this, Native.mkAnd(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final BoolExpr mkOr(Expr<BoolSort> ... t) {
        this.checkContextMatch(t);
        return new BoolExpr(this, Native.mkOr(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkAdd(Expr<? extends R> ... t) {
        this.checkContextMatch(t);
        return (ArithExpr)Expr.create(this, Native.mkAdd(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkMul(Expr<? extends R> ... t) {
        this.checkContextMatch(t);
        return (ArithExpr)Expr.create(this, Native.mkMul(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkSub(Expr<? extends R> ... t) {
        this.checkContextMatch(t);
        return (ArithExpr)Expr.create(this, Native.mkSub(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    public final <R extends ArithSort> ArithExpr<R> mkUnaryMinus(Expr<R> t) {
        this.checkContextMatch(t);
        return (ArithExpr)Expr.create(this, Native.mkUnaryMinus(this.nCtx(), t.getNativeObject()));
    }

    public final <R extends ArithSort> ArithExpr<R> mkDiv(Expr<? extends R> t1, Expr<? extends R> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return (ArithExpr)Expr.create(this, Native.mkDiv(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public IntExpr mkMod(Expr<IntSort> t1, Expr<IntSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new IntExpr(this, Native.mkMod(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public IntExpr mkRem(Expr<IntSort> t1, Expr<IntSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new IntExpr(this, Native.mkRem(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public final <R extends ArithSort> ArithExpr<R> mkPower(Expr<? extends R> t1, Expr<? extends R> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return (ArithExpr)Expr.create(this, Native.mkPower(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkLt(Expr<? extends ArithSort> t1, Expr<? extends ArithSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkLt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkLe(Expr<? extends ArithSort> t1, Expr<? extends ArithSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkLe(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkGt(Expr<? extends ArithSort> t1, Expr<? extends ArithSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkGt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkGe(Expr<? extends ArithSort> t1, Expr<? extends ArithSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkGe(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public RealExpr mkInt2Real(Expr<IntSort> t) {
        this.checkContextMatch(t);
        return new RealExpr(this, Native.mkInt2real(this.nCtx(), t.getNativeObject()));
    }

    public IntExpr mkReal2Int(Expr<RealSort> t) {
        this.checkContextMatch(t);
        return new IntExpr(this, Native.mkReal2int(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkIsInteger(Expr<RealSort> t) {
        this.checkContextMatch(t);
        return new BoolExpr(this, Native.mkIsInt(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkBVNot(Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkBvnot(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkBVRedAND(Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkBvredand(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkBVRedOR(Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkBvredor(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkBVAND(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvand(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVOR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvor(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVXOR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvxor(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVNAND(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvnand(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVNOR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvnor(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVXNOR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvxnor(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVNeg(Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkBvneg(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkBVAdd(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvadd(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVSub(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvsub(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVMul(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvmul(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVUDiv(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvudiv(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVSDiv(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvsdiv(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVURem(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvurem(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVSRem(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvsrem(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVSMod(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvsmod(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVULT(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvult(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSLT(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvslt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVULE(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvule(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSLE(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsle(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVUGE(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvuge(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSGE(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsge(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVUGT(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvugt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSGT(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsgt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkConcat(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkConcat(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkExtract(int high, int low, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkExtract(this.nCtx(), high, low, t.getNativeObject()));
    }

    public BitVecExpr mkSignExt(int i, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkSignExt(this.nCtx(), i, t.getNativeObject()));
    }

    public BitVecExpr mkZeroExt(int i, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkZeroExt(this.nCtx(), i, t.getNativeObject()));
    }

    public BitVecExpr mkRepeat(int i, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkRepeat(this.nCtx(), i, t.getNativeObject()));
    }

    public BitVecExpr mkBVSHL(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvshl(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVLSHR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvlshr(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVASHR(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkBvashr(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(int i, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkRotateLeft(this.nCtx(), i, t.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(int i, Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkRotateRight(this.nCtx(), i, t.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkExtRotateLeft(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BitVecExpr(this, Native.mkExtRotateRight(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BitVecExpr mkInt2BV(int n, Expr<IntSort> t) {
        this.checkContextMatch(t);
        return new BitVecExpr(this, Native.mkInt2bv(this.nCtx(), n, t.getNativeObject()));
    }

    public IntExpr mkBV2Int(Expr<BitVecSort> t, boolean signed) {
        this.checkContextMatch(t);
        return new IntExpr(this, Native.mkBv2int(this.nCtx(), t.getNativeObject(), signed));
    }

    public BoolExpr mkBVAddNoOverflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2, boolean isSigned) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvaddNoOverflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject(), isSigned));
    }

    public BoolExpr mkBVAddNoUnderflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvaddNoUnderflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoOverflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsubNoOverflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoUnderflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2, boolean isSigned) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsubNoUnderflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject(), isSigned));
    }

    public BoolExpr mkBVSDivNoOverflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvsdivNoOverflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkBVNegNoOverflow(Expr<BitVecSort> t) {
        this.checkContextMatch(t);
        return new BoolExpr(this, Native.mkBvnegNoOverflow(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkBVMulNoOverflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2, boolean isSigned) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvmulNoOverflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject(), isSigned));
    }

    public BoolExpr mkBVMulNoUnderflow(Expr<BitVecSort> t1, Expr<BitVecSort> t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new BoolExpr(this, Native.mkBvmulNoUnderflow(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkArrayConst(Symbol name, D domain, R range) {
        return (ArrayExpr)this.mkConst(name, this.mkArraySort(domain, range));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkArrayConst(String name, D domain, R range) {
        return (ArrayExpr)this.mkConst(this.mkSymbol(name), this.mkArraySort(domain, range));
    }

    public final <D extends Sort, R extends Sort> Expr<R> mkSelect(Expr<ArraySort<D, R>> a, Expr<D> i) {
        this.checkContextMatch(a);
        this.checkContextMatch(i);
        return Expr.create(this, Native.mkSelect(this.nCtx(), a.getNativeObject(), i.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkSelect(Expr<ArraySort<Sort, R>> a, Expr<?>[] args) {
        this.checkContextMatch(a);
        this.checkContextMatch(args);
        return Expr.create(this, Native.mkSelectN(this.nCtx(), a.getNativeObject(), args.length, AST.arrayToNative(args)));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkStore(Expr<ArraySort<D, R>> a, Expr<D> i, Expr<R> v) {
        this.checkContextMatch(a);
        this.checkContextMatch(i);
        this.checkContextMatch(v);
        return new ArrayExpr(this, Native.mkStore(this.nCtx(), a.getNativeObject(), i.getNativeObject(), v.getNativeObject()));
    }

    public final <R extends Sort> ArrayExpr<Sort, R> mkStore(Expr<ArraySort<Sort, R>> a, Expr<?>[] args, Expr<R> v) {
        this.checkContextMatch(a);
        this.checkContextMatch(args);
        this.checkContextMatch(v);
        return new ArrayExpr(this, Native.mkStoreN(this.nCtx(), a.getNativeObject(), args.length, AST.arrayToNative(args), v.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkConstArray(D domain, Expr<R> v) {
        this.checkContextMatch(domain);
        this.checkContextMatch(v);
        return new ArrayExpr(this, Native.mkConstArray(this.nCtx(), domain.getNativeObject(), v.getNativeObject()));
    }

    @SafeVarargs
    public final <D extends Sort, R1 extends Sort, R2 extends Sort> ArrayExpr<D, R2> mkMap(FuncDecl<R2> f, Expr<ArraySort<D, R1>> ... args) {
        this.checkContextMatch(f);
        this.checkContextMatch(args);
        return (ArrayExpr)Expr.create(this, Native.mkMap(this.nCtx(), f.getNativeObject(), AST.arrayLength(args), AST.arrayToNative(args)));
    }

    public final <D extends Sort, R extends Sort> Expr<R> mkTermArray(Expr<ArraySort<D, R>> array) {
        this.checkContextMatch(array);
        return Expr.create(this, Native.mkArrayDefault(this.nCtx(), array.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> Expr<D> mkArrayExt(Expr<ArraySort<D, R>> arg1, Expr<ArraySort<D, R>> arg2) {
        this.checkContextMatch(arg1);
        this.checkContextMatch(arg2);
        return Expr.create(this, Native.mkArrayExt(this.nCtx(), arg1.getNativeObject(), arg2.getNativeObject()));
    }

    public final <D extends Sort> SetSort<D> mkSetSort(D ty) {
        this.checkContextMatch(ty);
        return new SetSort<D>(this, ty);
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkEmptySet(D domain) {
        this.checkContextMatch(domain);
        return (ArrayExpr)Expr.create(this, Native.mkEmptySet(this.nCtx(), domain.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkFullSet(D domain) {
        this.checkContextMatch(domain);
        return (ArrayExpr)Expr.create(this, Native.mkFullSet(this.nCtx(), domain.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetAdd(Expr<ArraySort<D, BoolSort>> set, Expr<D> element) {
        this.checkContextMatch(set);
        this.checkContextMatch(element);
        return (ArrayExpr)Expr.create(this, Native.mkSetAdd(this.nCtx(), set.getNativeObject(), element.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetDel(Expr<ArraySort<D, BoolSort>> set, Expr<D> element) {
        this.checkContextMatch(set);
        this.checkContextMatch(element);
        return (ArrayExpr)Expr.create(this, Native.mkSetDel(this.nCtx(), set.getNativeObject(), element.getNativeObject()));
    }

    @SafeVarargs
    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetUnion(Expr<ArraySort<D, BoolSort>> ... args) {
        this.checkContextMatch(args);
        return (ArrayExpr)Expr.create(this, Native.mkSetUnion(this.nCtx(), args.length, AST.arrayToNative(args)));
    }

    @SafeVarargs
    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetIntersection(Expr<ArraySort<D, BoolSort>> ... args) {
        this.checkContextMatch(args);
        return (ArrayExpr)Expr.create(this, Native.mkSetIntersect(this.nCtx(), args.length, AST.arrayToNative(args)));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetDifference(Expr<ArraySort<D, BoolSort>> arg1, Expr<ArraySort<D, BoolSort>> arg2) {
        this.checkContextMatch(arg1);
        this.checkContextMatch(arg2);
        return (ArrayExpr)Expr.create(this, Native.mkSetDifference(this.nCtx(), arg1.getNativeObject(), arg2.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetComplement(Expr<ArraySort<D, BoolSort>> arg) {
        this.checkContextMatch(arg);
        return (ArrayExpr)Expr.create(this, Native.mkSetComplement(this.nCtx(), arg.getNativeObject()));
    }

    public final <D extends Sort> BoolExpr mkSetMembership(Expr<D> elem, Expr<ArraySort<D, BoolSort>> set) {
        this.checkContextMatch(elem);
        this.checkContextMatch(set);
        return (BoolExpr)Expr.create(this, Native.mkSetMember(this.nCtx(), elem.getNativeObject(), set.getNativeObject()));
    }

    public final <D extends Sort> BoolExpr mkSetSubset(Expr<ArraySort<D, BoolSort>> arg1, Expr<ArraySort<D, BoolSort>> arg2) {
        this.checkContextMatch(arg1);
        this.checkContextMatch(arg2);
        return (BoolExpr)Expr.create(this, Native.mkSetSubset(this.nCtx(), arg1.getNativeObject(), arg2.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkEmptySeq(R s) {
        this.checkContextMatch(s);
        return (SeqExpr)Expr.create(this, Native.mkSeqEmpty(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkUnit(Expr<R> elem) {
        this.checkContextMatch(elem);
        return (SeqExpr)Expr.create(this, Native.mkSeqUnit(this.nCtx(), elem.getNativeObject()));
    }

    public SeqExpr<CharSort> mkString(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int code = s.codePointAt(i);
            if (code <= 32 || 127 < code) {
                buf.append(String.format("\\u{%x}", code));
                continue;
            }
            buf.append(s.charAt(i));
        }
        return (SeqExpr)Expr.create(this, Native.mkString(this.nCtx(), buf.toString()));
    }

    public SeqExpr<CharSort> intToString(Expr<IntSort> e) {
        return (SeqExpr)Expr.create(this, Native.mkIntToStr(this.nCtx(), e.getNativeObject()));
    }

    public SeqExpr<CharSort> ubvToString(Expr<BitVecSort> e) {
        return (SeqExpr)Expr.create(this, Native.mkUbvToStr(this.nCtx(), e.getNativeObject()));
    }

    public SeqExpr<CharSort> sbvToString(Expr<BitVecSort> e) {
        return (SeqExpr)Expr.create(this, Native.mkSbvToStr(this.nCtx(), e.getNativeObject()));
    }

    public IntExpr stringToInt(Expr<SeqSort<CharSort>> e) {
        return (IntExpr)Expr.create(this, Native.mkStrToInt(this.nCtx(), e.getNativeObject()));
    }

    @SafeVarargs
    public final <R extends Sort> SeqExpr<R> mkConcat(Expr<SeqSort<R>> ... t) {
        this.checkContextMatch(t);
        return (SeqExpr)Expr.create(this, Native.mkSeqConcat(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    public final <R extends Sort> IntExpr mkLength(Expr<SeqSort<R>> s) {
        this.checkContextMatch(s);
        return (IntExpr)Expr.create(this, Native.mkSeqLength(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkPrefixOf(Expr<SeqSort<R>> s1, Expr<SeqSort<R>> s2) {
        this.checkContextMatch(s1, s2);
        return (BoolExpr)Expr.create(this, Native.mkSeqPrefix(this.nCtx(), s1.getNativeObject(), s2.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkSuffixOf(Expr<SeqSort<R>> s1, Expr<SeqSort<R>> s2) {
        this.checkContextMatch(s1, s2);
        return (BoolExpr)Expr.create(this, Native.mkSeqSuffix(this.nCtx(), s1.getNativeObject(), s2.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkContains(Expr<SeqSort<R>> s1, Expr<SeqSort<R>> s2) {
        this.checkContextMatch(s1, s2);
        return (BoolExpr)Expr.create(this, Native.mkSeqContains(this.nCtx(), s1.getNativeObject(), s2.getNativeObject()));
    }

    public BoolExpr MkStringLt(Expr<SeqSort<CharSort>> s1, Expr<SeqSort<CharSort>> s2) {
        this.checkContextMatch(s1, s2);
        return new BoolExpr(this, Native.mkStrLt(this.nCtx(), s1.getNativeObject(), s2.getNativeObject()));
    }

    public BoolExpr MkStringLe(Expr<SeqSort<CharSort>> s1, Expr<SeqSort<CharSort>> s2) {
        this.checkContextMatch(s1, s2);
        return new BoolExpr(this, Native.mkStrLe(this.nCtx(), s1.getNativeObject(), s2.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkAt(Expr<SeqSort<R>> s, Expr<IntSort> index) {
        this.checkContextMatch(s, index);
        return (SeqExpr)Expr.create(this, Native.mkSeqAt(this.nCtx(), s.getNativeObject(), index.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNth(Expr<SeqSort<R>> s, Expr<IntSort> index) {
        this.checkContextMatch(s, index);
        return Expr.create(this, Native.mkSeqNth(this.nCtx(), s.getNativeObject(), index.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkExtract(Expr<SeqSort<R>> s, Expr<IntSort> offset, Expr<IntSort> length) {
        this.checkContextMatch(s, offset, length);
        return (SeqExpr)Expr.create(this, Native.mkSeqExtract(this.nCtx(), s.getNativeObject(), offset.getNativeObject(), length.getNativeObject()));
    }

    public final <R extends Sort> IntExpr mkIndexOf(Expr<SeqSort<R>> s, Expr<SeqSort<R>> substr, Expr<IntSort> offset) {
        this.checkContextMatch(s, substr, offset);
        return (IntExpr)Expr.create(this, Native.mkSeqIndex(this.nCtx(), s.getNativeObject(), substr.getNativeObject(), offset.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkReplace(Expr<SeqSort<R>> s, Expr<SeqSort<R>> src, Expr<SeqSort<R>> dst) {
        this.checkContextMatch(s, src, dst);
        return (SeqExpr)Expr.create(this, Native.mkSeqReplace(this.nCtx(), s.getNativeObject(), src.getNativeObject(), dst.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<SeqSort<R>> mkToRe(Expr<SeqSort<R>> s) {
        this.checkContextMatch(s);
        return (ReExpr)Expr.create(this, Native.mkSeqToRe(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkInRe(Expr<SeqSort<R>> s, ReExpr<SeqSort<R>> re) {
        this.checkContextMatch(s, re);
        return (BoolExpr)Expr.create(this, Native.mkSeqInRe(this.nCtx(), s.getNativeObject(), re.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkStar(Expr<ReSort<R>> re) {
        this.checkContextMatch(re);
        return (ReExpr)Expr.create(this, Native.mkReStar(this.nCtx(), re.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkPower(Expr<ReSort<R>> re, int n) {
        return (ReExpr)Expr.create(this, Native.mkRePower(this.nCtx(), re.getNativeObject(), n));
    }

    public final <R extends Sort> ReExpr<R> mkLoop(Expr<ReSort<R>> re, int lo, int hi) {
        return (ReExpr)Expr.create(this, Native.mkReLoop(this.nCtx(), re.getNativeObject(), lo, hi));
    }

    public final <R extends Sort> ReExpr<R> mkLoop(Expr<ReSort<R>> re, int lo) {
        return (ReExpr)Expr.create(this, Native.mkReLoop(this.nCtx(), re.getNativeObject(), lo, 0));
    }

    public final <R extends Sort> ReExpr<R> mkPlus(Expr<ReSort<R>> re) {
        this.checkContextMatch(re);
        return (ReExpr)Expr.create(this, Native.mkRePlus(this.nCtx(), re.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkOption(Expr<ReSort<R>> re) {
        this.checkContextMatch(re);
        return (ReExpr)Expr.create(this, Native.mkReOption(this.nCtx(), re.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkComplement(Expr<ReSort<R>> re) {
        this.checkContextMatch(re);
        return (ReExpr)Expr.create(this, Native.mkReComplement(this.nCtx(), re.getNativeObject()));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkConcat(ReExpr<R> ... t) {
        this.checkContextMatch(t);
        return (ReExpr)Expr.create(this, Native.mkReConcat(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkUnion(Expr<ReSort<R>> ... t) {
        this.checkContextMatch(t);
        return (ReExpr)Expr.create(this, Native.mkReUnion(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkIntersect(Expr<ReSort<R>> ... t) {
        this.checkContextMatch(t);
        return (ReExpr)Expr.create(this, Native.mkReIntersect(this.nCtx(), t.length, AST.arrayToNative(t)));
    }

    public final <R extends Sort> ReExpr<R> mkDiff(Expr<ReSort<R>> a, Expr<ReSort<R>> b) {
        this.checkContextMatch(a, b);
        return (ReExpr)Expr.create(this, Native.mkReDiff(this.nCtx(), a.getNativeObject(), b.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkEmptyRe(ReSort<R> s) {
        return (ReExpr)Expr.create(this, Native.mkReEmpty(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkFullRe(ReSort<R> s) {
        return (ReExpr)Expr.create(this, Native.mkReFull(this.nCtx(), s.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkAllcharRe(ReSort<R> s) {
        return (ReExpr)Expr.create(this, Native.mkReAllchar(this.nCtx(), s.getNativeObject()));
    }

    public final ReExpr<SeqSort<CharSort>> mkRange(Expr<SeqSort<CharSort>> lo, Expr<SeqSort<CharSort>> hi) {
        this.checkContextMatch(lo, hi);
        return (ReExpr)Expr.create(this, Native.mkReRange(this.nCtx(), lo.getNativeObject(), hi.getNativeObject()));
    }

    public BoolExpr mkCharLe(Expr<CharSort> ch1, Expr<CharSort> ch2) {
        this.checkContextMatch(ch1, ch2);
        return (BoolExpr)Expr.create(this, Native.mkCharLe(this.nCtx(), ch1.getNativeObject(), ch2.getNativeObject()));
    }

    public IntExpr charToInt(Expr<CharSort> ch) {
        this.checkContextMatch(ch);
        return (IntExpr)Expr.create(this, Native.mkCharToInt(this.nCtx(), ch.getNativeObject()));
    }

    public BitVecExpr charToBv(Expr<CharSort> ch) {
        this.checkContextMatch(ch);
        return (BitVecExpr)Expr.create(this, Native.mkCharToBv(this.nCtx(), ch.getNativeObject()));
    }

    public Expr<CharSort> charFromBv(BitVecExpr bv) {
        this.checkContextMatch(bv);
        return Expr.create(this, Native.mkCharFromBv(this.nCtx(), bv.getNativeObject()));
    }

    public BoolExpr mkIsDigit(Expr<CharSort> ch) {
        this.checkContextMatch(ch);
        return (BoolExpr)Expr.create(this, Native.mkCharIsDigit(this.nCtx(), ch.getNativeObject()));
    }

    public BoolExpr mkAtMost(Expr<BoolSort>[] args, int k) {
        this.checkContextMatch(args);
        return (BoolExpr)Expr.create(this, Native.mkAtmost(this.nCtx(), args.length, AST.arrayToNative(args), k));
    }

    public BoolExpr mkAtLeast(Expr<BoolSort>[] args, int k) {
        this.checkContextMatch(args);
        return (BoolExpr)Expr.create(this, Native.mkAtleast(this.nCtx(), args.length, AST.arrayToNative(args), k));
    }

    public BoolExpr mkPBLe(int[] coeffs, Expr<BoolSort>[] args, int k) {
        this.checkContextMatch(args);
        return (BoolExpr)Expr.create(this, Native.mkPble(this.nCtx(), args.length, AST.arrayToNative(args), coeffs, k));
    }

    public BoolExpr mkPBGe(int[] coeffs, Expr<BoolSort>[] args, int k) {
        this.checkContextMatch(args);
        return (BoolExpr)Expr.create(this, Native.mkPbge(this.nCtx(), args.length, AST.arrayToNative(args), coeffs, k));
    }

    public BoolExpr mkPBEq(int[] coeffs, Expr<BoolSort>[] args, int k) {
        this.checkContextMatch(args);
        return (BoolExpr)Expr.create(this, Native.mkPbeq(this.nCtx(), args.length, AST.arrayToNative(args), coeffs, k));
    }

    public final <R extends Sort> Expr<R> mkNumeral(String v, R ty) {
        this.checkContextMatch(ty);
        return Expr.create(this, Native.mkNumeral(this.nCtx(), v, ty.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNumeral(int v, R ty) {
        this.checkContextMatch(ty);
        return Expr.create(this, Native.mkInt(this.nCtx(), v, ty.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNumeral(long v, R ty) {
        this.checkContextMatch(ty);
        return Expr.create(this, Native.mkInt64(this.nCtx(), v, ty.getNativeObject()));
    }

    public RatNum mkReal(int num, int den) {
        if (den == 0) {
            throw new Z3Exception("Denominator is zero");
        }
        return new RatNum(this, Native.mkReal(this.nCtx(), num, den));
    }

    public RatNum mkReal(String v) {
        return new RatNum(this, Native.mkNumeral(this.nCtx(), v, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(int v) {
        return new RatNum(this, Native.mkInt(this.nCtx(), v, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(long v) {
        return new RatNum(this, Native.mkInt64(this.nCtx(), v, this.getRealSort().getNativeObject()));
    }

    public IntNum mkInt(String v) {
        return new IntNum(this, Native.mkNumeral(this.nCtx(), v, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(int v) {
        return new IntNum(this, Native.mkInt(this.nCtx(), v, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(long v) {
        return new IntNum(this, Native.mkInt64(this.nCtx(), v, this.getIntSort().getNativeObject()));
    }

    public BitVecNum mkBV(String v, int size) {
        return (BitVecNum)this.mkNumeral(v, this.mkBitVecSort(size));
    }

    public BitVecNum mkBV(int v, int size) {
        return (BitVecNum)this.mkNumeral(v, (Sort)this.mkBitVecSort(size));
    }

    public BitVecNum mkBV(long v, int size) {
        return (BitVecNum)this.mkNumeral(v, this.mkBitVecSort(size));
    }

    public Quantifier mkForall(Sort[] sorts, Symbol[] names, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        return Quantifier.of(this, true, sorts, names, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public Quantifier mkForall(Expr<?>[] boundConstants, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        return Quantifier.of(this, true, boundConstants, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public Quantifier mkExists(Sort[] sorts, Symbol[] names, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        return Quantifier.of(this, false, sorts, names, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public Quantifier mkExists(Expr<?>[] boundConstants, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        return Quantifier.of(this, false, boundConstants, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public Quantifier mkQuantifier(boolean universal, Sort[] sorts, Symbol[] names, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        if (universal) {
            return this.mkForall(sorts, names, body, weight, patterns, noPatterns, quantifierID, skolemID);
        }
        return this.mkExists(sorts, names, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public Quantifier mkQuantifier(boolean universal, Expr<?>[] boundConstants, Expr<BoolSort> body, int weight, Pattern[] patterns, Expr<?>[] noPatterns, Symbol quantifierID, Symbol skolemID) {
        if (universal) {
            return this.mkForall(boundConstants, body, weight, patterns, noPatterns, quantifierID, skolemID);
        }
        return this.mkExists(boundConstants, body, weight, patterns, noPatterns, quantifierID, skolemID);
    }

    public final <R extends Sort> Lambda<R> mkLambda(Sort[] sorts, Symbol[] names, Expr<R> body) {
        return Lambda.of(this, sorts, names, body);
    }

    public final <R extends Sort> Lambda<R> mkLambda(Expr<?>[] boundConstants, Expr<R> body) {
        return Lambda.of(this, boundConstants, body);
    }

    public void setPrintMode(Z3_ast_print_mode value) {
        Native.setAstPrintMode(this.nCtx(), value.toInt());
    }

    public String benchmarkToSMTString(String name, String logic, String status, String attributes, Expr<BoolSort>[] assumptions, Expr<BoolSort> formula) {
        return Native.benchmarkToSmtlibString(this.nCtx(), name, logic, status, attributes, assumptions.length, AST.arrayToNative(assumptions), formula.getNativeObject());
    }

    public BoolExpr[] parseSMTLIB2String(String str, Symbol[] sortNames, Sort[] sorts, Symbol[] declNames, FuncDecl<?>[] decls) {
        int csn = Symbol.arrayLength(sortNames);
        int cs = Sort.arrayLength(sorts);
        int cdn = Symbol.arrayLength(declNames);
        int cd = AST.arrayLength(decls);
        if (csn != cs || cdn != cd) {
            throw new Z3Exception("Argument size mismatch");
        }
        ASTVector v = new ASTVector(this, Native.parseSmtlib2String(this.nCtx(), str, AST.arrayLength(sorts), Symbol.arrayToNative(sortNames), AST.arrayToNative(sorts), AST.arrayLength(decls), Symbol.arrayToNative(declNames), AST.arrayToNative(decls)));
        return v.ToBoolExprArray();
    }

    public BoolExpr[] parseSMTLIB2File(String fileName, Symbol[] sortNames, Sort[] sorts, Symbol[] declNames, FuncDecl<?>[] decls) {
        int csn = Symbol.arrayLength(sortNames);
        int cs = Sort.arrayLength(sorts);
        int cdn = Symbol.arrayLength(declNames);
        int cd = AST.arrayLength(decls);
        if (csn != cs || cdn != cd) {
            throw new Z3Exception("Argument size mismatch");
        }
        ASTVector v = new ASTVector(this, Native.parseSmtlib2File(this.nCtx(), fileName, AST.arrayLength(sorts), Symbol.arrayToNative(sortNames), AST.arrayToNative(sorts), AST.arrayLength(decls), Symbol.arrayToNative(declNames), AST.arrayToNative(decls)));
        return v.ToBoolExprArray();
    }

    public Goal mkGoal(boolean models, boolean unsatCores, boolean proofs) {
        return new Goal(this, models, unsatCores, proofs);
    }

    public Params mkParams() {
        return new Params(this);
    }

    public int getNumTactics() {
        return Native.getNumTactics(this.nCtx());
    }

    public String[] getTacticNames() {
        int n = this.getNumTactics();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Native.getTacticName(this.nCtx(), i);
        }
        return res;
    }

    public String getTacticDescription(String name) {
        return Native.tacticGetDescr(this.nCtx(), name);
    }

    public Tactic mkTactic(String name) {
        return new Tactic(this, name);
    }

    public Tactic andThen(Tactic t1, Tactic t2, Tactic ... ts) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        this.checkContextMatch(ts);
        long last = 0L;
        if (ts != null && ts.length > 0) {
            last = ts[ts.length - 1].getNativeObject();
            for (int i = ts.length - 2; i >= 0; --i) {
                last = Native.tacticAndThen(this.nCtx(), ts[i].getNativeObject(), last);
            }
        }
        if (last != 0L) {
            last = Native.tacticAndThen(this.nCtx(), t2.getNativeObject(), last);
            return new Tactic(this, Native.tacticAndThen(this.nCtx(), t1.getNativeObject(), last));
        }
        return new Tactic(this, Native.tacticAndThen(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public Tactic then(Tactic t1, Tactic t2, Tactic ... ts) {
        return this.andThen(t1, t2, ts);
    }

    public Tactic orElse(Tactic t1, Tactic t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new Tactic(this, Native.tacticOrElse(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public Tactic tryFor(Tactic t, int ms) {
        this.checkContextMatch(t);
        return new Tactic(this, Native.tacticTryFor(this.nCtx(), t.getNativeObject(), ms));
    }

    public Tactic when(Probe p, Tactic t) {
        this.checkContextMatch(t);
        this.checkContextMatch(p);
        return new Tactic(this, Native.tacticWhen(this.nCtx(), p.getNativeObject(), t.getNativeObject()));
    }

    public Tactic cond(Probe p, Tactic t1, Tactic t2) {
        this.checkContextMatch(p);
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new Tactic(this, Native.tacticCond(this.nCtx(), p.getNativeObject(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public Tactic repeat(Tactic t, int max) {
        this.checkContextMatch(t);
        return new Tactic(this, Native.tacticRepeat(this.nCtx(), t.getNativeObject(), max));
    }

    public Tactic skip() {
        return new Tactic(this, Native.tacticSkip(this.nCtx()));
    }

    public Tactic fail() {
        return new Tactic(this, Native.tacticFail(this.nCtx()));
    }

    public Tactic failIf(Probe p) {
        this.checkContextMatch(p);
        return new Tactic(this, Native.tacticFailIf(this.nCtx(), p.getNativeObject()));
    }

    public Tactic failIfNotDecided() {
        return new Tactic(this, Native.tacticFailIfNotDecided(this.nCtx()));
    }

    public Tactic usingParams(Tactic t, Params p) {
        this.checkContextMatch(t);
        this.checkContextMatch(p);
        return new Tactic(this, Native.tacticUsingParams(this.nCtx(), t.getNativeObject(), p.getNativeObject()));
    }

    public Tactic with(Tactic t, Params p) {
        return this.usingParams(t, p);
    }

    public Tactic parOr(Tactic ... t) {
        this.checkContextMatch(t);
        return new Tactic(this, Native.tacticParOr(this.nCtx(), Tactic.arrayLength(t), Tactic.arrayToNative(t)));
    }

    public Tactic parAndThen(Tactic t1, Tactic t2) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        return new Tactic(this, Native.tacticParAndThen(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public void interrupt() {
        Native.interrupt(this.nCtx());
    }

    public int getNumSimplifiers() {
        return Native.getNumSimplifiers(this.nCtx());
    }

    public String[] getSimplifierNames() {
        int n = this.getNumSimplifiers();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Native.getSimplifierName(this.nCtx(), i);
        }
        return res;
    }

    public String getSimplifierDescription(String name) {
        return Native.simplifierGetDescr(this.nCtx(), name);
    }

    public Simplifier mkSimplifier(String name) {
        return new Simplifier(this, name);
    }

    public Simplifier andThen(Simplifier t1, Simplifier t2, Simplifier ... ts) {
        this.checkContextMatch(t1);
        this.checkContextMatch(t2);
        this.checkContextMatch(ts);
        long last = 0L;
        if (ts != null && ts.length > 0) {
            last = ts[ts.length - 1].getNativeObject();
            for (int i = ts.length - 2; i >= 0; --i) {
                last = Native.simplifierAndThen(this.nCtx(), ts[i].getNativeObject(), last);
            }
        }
        if (last != 0L) {
            last = Native.simplifierAndThen(this.nCtx(), t2.getNativeObject(), last);
            return new Simplifier(this, Native.simplifierAndThen(this.nCtx(), t1.getNativeObject(), last));
        }
        return new Simplifier(this, Native.simplifierAndThen(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public Simplifier then(Simplifier t1, Simplifier t2, Simplifier ... ts) {
        return this.andThen(t1, t2, ts);
    }

    public Simplifier usingParams(Simplifier t, Params p) {
        this.checkContextMatch(t);
        this.checkContextMatch(p);
        return new Simplifier(this, Native.simplifierUsingParams(this.nCtx(), t.getNativeObject(), p.getNativeObject()));
    }

    public Simplifier with(Simplifier t, Params p) {
        return this.usingParams(t, p);
    }

    public int getNumProbes() {
        return Native.getNumProbes(this.nCtx());
    }

    public String[] getProbeNames() {
        int n = this.getNumProbes();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Native.getProbeName(this.nCtx(), i);
        }
        return res;
    }

    public String getProbeDescription(String name) {
        return Native.probeGetDescr(this.nCtx(), name);
    }

    public Probe mkProbe(String name) {
        return new Probe(this, name);
    }

    public Probe constProbe(double val) {
        return new Probe(this, Native.probeConst(this.nCtx(), val));
    }

    public Probe lt(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeLt(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe gt(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeGt(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe le(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeLe(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe ge(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeGe(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe eq(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeEq(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe and(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeAnd(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe or(Probe p1, Probe p2) {
        this.checkContextMatch(p1);
        this.checkContextMatch(p2);
        return new Probe(this, Native.probeOr(this.nCtx(), p1.getNativeObject(), p2.getNativeObject()));
    }

    public Probe not(Probe p) {
        this.checkContextMatch(p);
        return new Probe(this, Native.probeNot(this.nCtx(), p.getNativeObject()));
    }

    public Solver mkSolver() {
        return this.mkSolver((Symbol)null);
    }

    public Solver mkSolver(Symbol logic) {
        if (logic == null) {
            return new Solver(this, Native.mkSolver(this.nCtx()));
        }
        return new Solver(this, Native.mkSolverForLogic(this.nCtx(), logic.getNativeObject()));
    }

    public Solver mkSolver(String logic) {
        return this.mkSolver(this.mkSymbol(logic));
    }

    public Solver mkSimpleSolver() {
        return new Solver(this, Native.mkSimpleSolver(this.nCtx()));
    }

    public Solver mkSolver(Tactic t) {
        return new Solver(this, Native.mkSolverFromTactic(this.nCtx(), t.getNativeObject()));
    }

    public Solver mkSolver(Solver s, Simplifier simp) {
        return new Solver(this, Native.solverAddSimplifier(this.nCtx(), s.getNativeObject(), simp.getNativeObject()));
    }

    public Fixedpoint mkFixedpoint() {
        return new Fixedpoint(this);
    }

    public Optimize mkOptimize() {
        return new Optimize(this);
    }

    public FPRMSort mkFPRoundingModeSort() {
        return new FPRMSort(this);
    }

    public FPRMExpr mkFPRoundNearestTiesToEven() {
        return new FPRMExpr(this, Native.mkFpaRoundNearestTiesToEven(this.nCtx()));
    }

    public FPRMNum mkFPRNE() {
        return new FPRMNum(this, Native.mkFpaRne(this.nCtx()));
    }

    public FPRMNum mkFPRoundNearestTiesToAway() {
        return new FPRMNum(this, Native.mkFpaRoundNearestTiesToAway(this.nCtx()));
    }

    public FPRMNum mkFPRNA() {
        return new FPRMNum(this, Native.mkFpaRna(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardPositive() {
        return new FPRMNum(this, Native.mkFpaRoundTowardPositive(this.nCtx()));
    }

    public FPRMNum mkFPRTP() {
        return new FPRMNum(this, Native.mkFpaRtp(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardNegative() {
        return new FPRMNum(this, Native.mkFpaRoundTowardNegative(this.nCtx()));
    }

    public FPRMNum mkFPRTN() {
        return new FPRMNum(this, Native.mkFpaRtn(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardZero() {
        return new FPRMNum(this, Native.mkFpaRoundTowardZero(this.nCtx()));
    }

    public FPRMNum mkFPRTZ() {
        return new FPRMNum(this, Native.mkFpaRtz(this.nCtx()));
    }

    public FPSort mkFPSort(int ebits, int sbits) {
        return new FPSort(this, ebits, sbits);
    }

    public FPSort mkFPSortHalf() {
        return new FPSort(this, Native.mkFpaSortHalf(this.nCtx()));
    }

    public FPSort mkFPSort16() {
        return new FPSort(this, Native.mkFpaSort16(this.nCtx()));
    }

    public FPSort mkFPSortSingle() {
        return new FPSort(this, Native.mkFpaSortSingle(this.nCtx()));
    }

    public FPSort mkFPSort32() {
        return new FPSort(this, Native.mkFpaSort32(this.nCtx()));
    }

    public FPSort mkFPSortDouble() {
        return new FPSort(this, Native.mkFpaSortDouble(this.nCtx()));
    }

    public FPSort mkFPSort64() {
        return new FPSort(this, Native.mkFpaSort64(this.nCtx()));
    }

    public FPSort mkFPSortQuadruple() {
        return new FPSort(this, Native.mkFpaSortQuadruple(this.nCtx()));
    }

    public FPSort mkFPSort128() {
        return new FPSort(this, Native.mkFpaSort128(this.nCtx()));
    }

    public FPNum mkFPNaN(FPSort s) {
        return new FPNum(this, Native.mkFpaNan(this.nCtx(), s.getNativeObject()));
    }

    public FPNum mkFPInf(FPSort s, boolean negative) {
        return new FPNum(this, Native.mkFpaInf(this.nCtx(), s.getNativeObject(), negative));
    }

    public FPNum mkFPZero(FPSort s, boolean negative) {
        return new FPNum(this, Native.mkFpaZero(this.nCtx(), s.getNativeObject(), negative));
    }

    public FPNum mkFPNumeral(float v, FPSort s) {
        return new FPNum(this, Native.mkFpaNumeralFloat(this.nCtx(), v, s.getNativeObject()));
    }

    public FPNum mkFPNumeral(double v, FPSort s) {
        return new FPNum(this, Native.mkFpaNumeralDouble(this.nCtx(), v, s.getNativeObject()));
    }

    public FPNum mkFPNumeral(int v, FPSort s) {
        return new FPNum(this, Native.mkFpaNumeralInt(this.nCtx(), v, s.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean sgn, int exp, int sig, FPSort s) {
        return new FPNum(this, Native.mkFpaNumeralIntUint(this.nCtx(), sgn, exp, sig, s.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean sgn, long exp, long sig, FPSort s) {
        return new FPNum(this, Native.mkFpaNumeralInt64Uint64(this.nCtx(), sgn, exp, sig, s.getNativeObject()));
    }

    public FPNum mkFP(float v, FPSort s) {
        return this.mkFPNumeral(v, s);
    }

    public FPNum mkFP(double v, FPSort s) {
        return this.mkFPNumeral(v, s);
    }

    public FPNum mkFP(int v, FPSort s) {
        return this.mkFPNumeral(v, s);
    }

    public FPNum mkFP(boolean sgn, int exp, int sig, FPSort s) {
        return this.mkFPNumeral(sgn, exp, sig, s);
    }

    public FPNum mkFP(boolean sgn, long exp, long sig, FPSort s) {
        return this.mkFPNumeral(sgn, exp, sig, s);
    }

    public FPExpr mkFPAbs(Expr<FPSort> t) {
        return new FPExpr(this, Native.mkFpaAbs(this.nCtx(), t.getNativeObject()));
    }

    public FPExpr mkFPNeg(Expr<FPSort> t) {
        return new FPExpr(this, Native.mkFpaNeg(this.nCtx(), t.getNativeObject()));
    }

    public FPExpr mkFPAdd(Expr<FPRMSort> rm, Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaAdd(this.nCtx(), rm.getNativeObject(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPSub(Expr<FPRMSort> rm, Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaSub(this.nCtx(), rm.getNativeObject(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPMul(Expr<FPRMSort> rm, Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaMul(this.nCtx(), rm.getNativeObject(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPDiv(Expr<FPRMSort> rm, Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaDiv(this.nCtx(), rm.getNativeObject(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPFMA(Expr<FPRMSort> rm, Expr<FPSort> t1, Expr<FPSort> t2, Expr<FPSort> t3) {
        return new FPExpr(this, Native.mkFpaFma(this.nCtx(), rm.getNativeObject(), t1.getNativeObject(), t2.getNativeObject(), t3.getNativeObject()));
    }

    public FPExpr mkFPSqrt(Expr<FPRMSort> rm, Expr<FPSort> t) {
        return new FPExpr(this, Native.mkFpaSqrt(this.nCtx(), rm.getNativeObject(), t.getNativeObject()));
    }

    public FPExpr mkFPRem(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaRem(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPRoundToIntegral(Expr<FPRMSort> rm, Expr<FPSort> t) {
        return new FPExpr(this, Native.mkFpaRoundToIntegral(this.nCtx(), rm.getNativeObject(), t.getNativeObject()));
    }

    public FPExpr mkFPMin(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaMin(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public FPExpr mkFPMax(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new FPExpr(this, Native.mkFpaMax(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPLEq(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new BoolExpr(this, Native.mkFpaLeq(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPLt(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new BoolExpr(this, Native.mkFpaLt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPGEq(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new BoolExpr(this, Native.mkFpaGeq(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPGt(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new BoolExpr(this, Native.mkFpaGt(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPEq(Expr<FPSort> t1, Expr<FPSort> t2) {
        return new BoolExpr(this, Native.mkFpaEq(this.nCtx(), t1.getNativeObject(), t2.getNativeObject()));
    }

    public BoolExpr mkFPIsNormal(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsNormal(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsSubnormal(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsSubnormal(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsZero(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsZero(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsInfinite(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsInfinite(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsNaN(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsNan(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsNegative(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsNegative(this.nCtx(), t.getNativeObject()));
    }

    public BoolExpr mkFPIsPositive(Expr<FPSort> t) {
        return new BoolExpr(this, Native.mkFpaIsPositive(this.nCtx(), t.getNativeObject()));
    }

    public FPExpr mkFP(Expr<BitVecSort> sgn, Expr<BitVecSort> sig, Expr<BitVecSort> exp) {
        return new FPExpr(this, Native.mkFpaFp(this.nCtx(), sgn.getNativeObject(), sig.getNativeObject(), exp.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<BitVecSort> bv, FPSort s) {
        return new FPExpr(this, Native.mkFpaToFpBv(this.nCtx(), bv.getNativeObject(), s.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> rm, FPExpr t, FPSort s) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), s.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> rm, RealExpr t, FPSort s) {
        return new FPExpr(this, Native.mkFpaToFpReal(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), s.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> rm, Expr<BitVecSort> t, FPSort s, boolean signed) {
        if (signed) {
            return new FPExpr(this, Native.mkFpaToFpSigned(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), s.getNativeObject()));
        }
        return new FPExpr(this, Native.mkFpaToFpUnsigned(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), s.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPSort s, Expr<FPRMSort> rm, Expr<FPSort> t) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), s.getNativeObject(), rm.getNativeObject(), t.getNativeObject()));
    }

    public BitVecExpr mkFPToBV(Expr<FPRMSort> rm, Expr<FPSort> t, int sz, boolean signed) {
        if (signed) {
            return new BitVecExpr(this, Native.mkFpaToSbv(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), sz));
        }
        return new BitVecExpr(this, Native.mkFpaToUbv(this.nCtx(), rm.getNativeObject(), t.getNativeObject(), sz));
    }

    public RealExpr mkFPToReal(Expr<FPSort> t) {
        return new RealExpr(this, Native.mkFpaToReal(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkFPToIEEEBV(Expr<FPSort> t) {
        return new BitVecExpr(this, Native.mkFpaToIeeeBv(this.nCtx(), t.getNativeObject()));
    }

    public BitVecExpr mkFPToFP(Expr<FPRMSort> rm, Expr<IntSort> exp, Expr<RealSort> sig, FPSort s) {
        return new BitVecExpr(this, Native.mkFpaToFpIntReal(this.nCtx(), rm.getNativeObject(), exp.getNativeObject(), sig.getNativeObject(), s.getNativeObject()));
    }

    public final <R extends Sort> FuncDecl<BoolSort> mkLinearOrder(R sort, int index) {
        return (FuncDecl)FuncDecl.create(this, Native.mkLinearOrder(this.nCtx(), sort.getNativeObject(), index));
    }

    public final <R extends Sort> FuncDecl<BoolSort> mkPartialOrder(R sort, int index) {
        return (FuncDecl)FuncDecl.create(this, Native.mkPartialOrder(this.nCtx(), sort.getNativeObject(), index));
    }

    public AST wrapAST(long nativeObject) {
        return AST.create(this, nativeObject);
    }

    public long unwrapAST(AST a) {
        return a.getNativeObject();
    }

    public String SimplifyHelp() {
        return Native.simplifyGetHelp(this.nCtx());
    }

    public ParamDescrs getSimplifyParameterDescriptions() {
        return new ParamDescrs(this, Native.simplifyGetParamDescrs(this.nCtx()));
    }

    public void updateParamValue(String id, String value) {
        Native.updateParamValue(this.nCtx(), id, value);
    }

    public long nCtx() {
        if (this.m_ctx == 0L) {
            throw new Z3Exception("Context closed");
        }
        return this.m_ctx;
    }

    void checkContextMatch(Z3Object other) {
        if (this != other.getContext()) {
            throw new Z3Exception("Context mismatch");
        }
    }

    void checkContextMatch(Z3Object other1, Z3Object other2) {
        this.checkContextMatch(other1);
        this.checkContextMatch(other2);
    }

    void checkContextMatch(Z3Object other1, Z3Object other2, Z3Object other3) {
        this.checkContextMatch(other1);
        this.checkContextMatch(other2);
        this.checkContextMatch(other3);
    }

    void checkContextMatch(Z3Object[] arr) {
        if (arr != null) {
            for (Z3Object a : arr) {
                this.checkContextMatch(a);
            }
        }
    }

    Z3ReferenceQueue getReferenceQueue() {
        return this.m_RefQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_ctx == 0L) {
            return;
        }
        this.m_RefQueue.forceClear();
        this.m_boolSort = null;
        this.m_intSort = null;
        this.m_realSort = null;
        this.m_stringSort = null;
        this.m_RefQueue = null;
        Object object = creation_lock;
        synchronized (object) {
            Native.delContext(this.m_ctx);
        }
        this.m_ctx = 0L;
    }
}

