/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import java.lang.ref.ReferenceQueue;

public class FuncInterp<R extends Sort>
extends Z3Object {
    public int getNumEntries() {
        return Native.funcInterpGetNumEntries(this.getContext().nCtx(), this.getNativeObject());
    }

    public Entry<R>[] getEntries() {
        int n = this.getNumEntries();
        Entry[] res = new Entry[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new Entry(this.getContext(), Native.funcInterpGetEntry(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public Expr<R> getElse() {
        return Expr.create(this.getContext(), Native.funcInterpGetElse(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getArity() {
        return Native.funcInterpGetArity(this.getContext().nCtx(), this.getNativeObject());
    }

    public String toString() {
        String res = "";
        res = res + "[";
        for (Entry<R> e : this.getEntries()) {
            int n = e.getNumArgs();
            if (n > 1) {
                res = res + "[";
            }
            Expr<?>[] args = e.getArgs();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    res = res + ", ";
                }
                res = res + args[i];
            }
            if (n > 1) {
                res = res + "]";
            }
            res = res + " -> " + e.getValue() + ", ";
        }
        res = res + "else -> " + this.getElse();
        res = res + "]";
        return res;
    }

    FuncInterp(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
        Native.funcInterpIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (x$0, x$1) -> new FuncInterpRef((FuncInterp)x$0, x$1));
    }

    private static class FuncInterpRef
    extends Z3ReferenceQueue.Reference<FuncInterp<?>> {
        private FuncInterpRef(FuncInterp<?> referent, ReferenceQueue<Z3Object> q) {
            super(referent, q);
        }

        @Override
        void decRef(Context ctx, long z3Obj) {
            Native.funcInterpDecRef(ctx.nCtx(), z3Obj);
        }
    }

    public static class Entry<R extends Sort>
    extends Z3Object {
        public Expr<R> getValue() {
            return Expr.create(this.getContext(), Native.funcEntryGetValue(this.getContext().nCtx(), this.getNativeObject()));
        }

        public int getNumArgs() {
            return Native.funcEntryGetNumArgs(this.getContext().nCtx(), this.getNativeObject());
        }

        public Expr<?>[] getArgs() {
            int n = this.getNumArgs();
            Expr[] res = new Expr[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Expr.create(this.getContext(), Native.funcEntryGetArg(this.getContext().nCtx(), this.getNativeObject(), i));
            }
            return res;
        }

        public String toString() {
            int n = this.getNumArgs();
            String res = "[";
            Expr<?>[] args = this.getArgs();
            for (int i = 0; i < n; ++i) {
                res = res + args[i] + ", ";
            }
            return res + this.getValue() + "]";
        }

        Entry(Context ctx, long obj) {
            super(ctx, obj);
        }

        @Override
        void incRef() {
            Native.funcEntryIncRef(this.getContext().nCtx(), this.getNativeObject());
        }

        @Override
        void addToReferenceQueue() {
            this.getContext().getReferenceQueue().storeReference(this, (x$0, x$1) -> new FuncEntryRef((Entry)x$0, x$1));
        }

        private static class FuncEntryRef
        extends Z3ReferenceQueue.Reference<Entry<?>> {
            private FuncEntryRef(Entry<?> referent, ReferenceQueue<Z3Object> q) {
                super(referent, q);
            }

            @Override
            void decRef(Context ctx, long z3Obj) {
                Native.funcEntryDecRef(ctx.nCtx(), z3Obj);
            }
        }
    }
}

