/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ApplyResult;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_goal_prec;
import java.lang.ref.ReferenceQueue;

public class Goal
extends Z3Object {
    public Z3_goal_prec getPrecision() {
        return Z3_goal_prec.fromInt(Native.goalPrecision(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isPrecise() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_PRECISE;
    }

    public boolean isUnderApproximation() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER;
    }

    public boolean isOverApproximation() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_OVER;
    }

    public boolean isGarbage() {
        return this.getPrecision() == Z3_goal_prec.Z3_GOAL_UNDER_OVER;
    }

    @SafeVarargs
    public final void add(Expr<BoolSort> ... constraints) {
        this.getContext().checkContextMatch(constraints);
        for (Expr<BoolSort> c : constraints) {
            Native.goalAssert(this.getContext().nCtx(), this.getNativeObject(), c.getNativeObject());
        }
    }

    public boolean inconsistent() {
        return Native.goalInconsistent(this.getContext().nCtx(), this.getNativeObject());
    }

    public int getDepth() {
        return Native.goalDepth(this.getContext().nCtx(), this.getNativeObject());
    }

    public void reset() {
        Native.goalReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public int size() {
        return Native.goalSize(this.getContext().nCtx(), this.getNativeObject());
    }

    public BoolExpr[] getFormulas() {
        int n = this.size();
        BoolExpr[] res = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            res[i] = (BoolExpr)Expr.create(this.getContext(), Native.goalFormula(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public int getNumExprs() {
        return Native.goalNumExprs(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedSat() {
        return Native.goalIsDecidedSat(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isDecidedUnsat() {
        return Native.goalIsDecidedUnsat(this.getContext().nCtx(), this.getNativeObject());
    }

    public Goal translate(Context ctx) {
        return new Goal(ctx, Native.goalTranslate(this.getContext().nCtx(), this.getNativeObject(), ctx.nCtx()));
    }

    public Goal simplify() {
        Tactic t = this.getContext().mkTactic("simplify");
        ApplyResult res = t.apply(this);
        if (res.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return res.getSubgoals()[0];
    }

    public Goal simplify(Params p) {
        Tactic t = this.getContext().mkTactic("simplify");
        ApplyResult res = t.apply(this, p);
        if (res.getNumSubgoals() == 0) {
            throw new Z3Exception("No subgoals");
        }
        return res.getSubgoals()[0];
    }

    public String toString() {
        return Native.goalToString(this.getContext().nCtx(), this.getNativeObject());
    }

    public BoolExpr AsBoolExpr() {
        int n = this.size();
        if (n == 0) {
            return this.getContext().mkTrue();
        }
        if (n == 1) {
            return this.getFormulas()[0];
        }
        return this.getContext().mkAnd(this.getFormulas());
    }

    Goal(Context ctx, long obj) {
        super(ctx, obj);
    }

    Goal(Context ctx, boolean models, boolean unsatCores, boolean proofs) {
        super(ctx, Native.mkGoal(ctx.nCtx(), models, unsatCores, proofs));
    }

    public Model convertModel(Model m) {
        return new Model(this.getContext(), Native.goalConvertModel(this.getContext().nCtx(), this.getNativeObject(), m.getNativeObject()));
    }

    @Override
    void incRef() {
        Native.goalIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (x$0, x$1) -> new GoalRef((Goal)x$0, x$1));
    }

    private static class GoalRef
    extends Z3ReferenceQueue.Reference<Goal> {
        private GoalRef(Goal referent, ReferenceQueue<Z3Object> q) {
            super(referent, q);
        }

        @Override
        void decRef(Context ctx, long z3Obj) {
            Native.goalDecRef(ctx.nCtx(), z3Obj);
        }
    }
}

