/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;

public class Lambda<R extends Sort>
extends ArrayExpr<Sort, R> {
    public int getNumBound() {
        return Native.getQuantifierNumBound(this.getContext().nCtx(), this.getNativeObject());
    }

    public Symbol[] getBoundVariableNames() {
        int n = this.getNumBound();
        Symbol[] res = new Symbol[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Symbol.create(this.getContext(), Native.getQuantifierBoundName(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public Sort[] getBoundVariableSorts() {
        int n = this.getNumBound();
        Sort[] res = new Sort[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Sort.create(this.getContext(), Native.getQuantifierBoundSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public Expr<R> getBody() {
        return Expr.create(this.getContext(), Native.getQuantifierBody(this.getContext().nCtx(), this.getNativeObject()));
    }

    @Override
    public Lambda<R> translate(Context ctx) {
        return (Lambda)super.translate(ctx);
    }

    public static <R extends Sort> Lambda<R> of(Context ctx, Sort[] sorts, Symbol[] names, Expr<R> body) {
        ctx.checkContextMatch(sorts);
        ctx.checkContextMatch(names);
        ctx.checkContextMatch(body);
        if (sorts.length != names.length) {
            throw new Z3Exception("Number of sorts does not match number of names");
        }
        long nativeObject = Native.mkLambda(ctx.nCtx(), AST.arrayLength(sorts), AST.arrayToNative(sorts), Symbol.arrayToNative(names), body.getNativeObject());
        return new Lambda<R>(ctx, nativeObject);
    }

    public static <R extends Sort> Lambda<R> of(Context ctx, Expr<?>[] bound, Expr<R> body) {
        ctx.checkContextMatch(body);
        long nativeObject = Native.mkLambdaConst(ctx.nCtx(), AST.arrayLength(bound), AST.arrayToNative(bound), body.getNativeObject());
        return new Lambda<R>(ctx, nativeObject);
    }

    private Lambda(Context ctx, long obj) {
        super(ctx, obj);
    }
}

