/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.lang.ref.ReferenceQueue;

public class Model
extends Z3Object {
    public <R extends Sort> Expr<R> getConstInterp(Expr<R> a) {
        this.getContext().checkContextMatch(a);
        return this.getConstInterp(a.getFuncDecl());
    }

    public <R extends Sort> Expr<R> getConstInterp(FuncDecl<R> f) {
        this.getContext().checkContextMatch(f);
        if (f.getArity() != 0) {
            throw new Z3Exception("Non-zero arity functions have FunctionInterpretations as a model. Use getFuncInterp.");
        }
        long n = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), f.getNativeObject());
        if (n == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), n);
    }

    public <R extends Sort> FuncInterp<R> getFuncInterp(FuncDecl<R> f) {
        this.getContext().checkContextMatch(f);
        Z3_sort_kind sk = Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), Native.getRange(this.getContext().nCtx(), f.getNativeObject())));
        if (f.getArity() == 0) {
            long n = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), f.getNativeObject());
            if (sk == Z3_sort_kind.Z3_ARRAY_SORT) {
                if (n == 0L) {
                    return null;
                }
                if (Native.isAsArray(this.getContext().nCtx(), n)) {
                    long fd = Native.getAsArrayFuncDecl(this.getContext().nCtx(), n);
                    return this.getFuncInterp(new FuncDecl(this.getContext(), fd));
                }
                return null;
            }
            throw new Z3Exception("Constant functions do not have a function interpretation; use getConstInterp");
        }
        long n = Native.modelGetFuncInterp(this.getContext().nCtx(), this.getNativeObject(), f.getNativeObject());
        if (n == 0L) {
            return null;
        }
        return new FuncInterp(this.getContext(), n);
    }

    public int getNumConsts() {
        return Native.modelGetNumConsts(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl<?>[] getConstDecls() {
        int n = this.getNumConsts();
        FuncDecl[] res = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public int getNumFuncs() {
        return Native.modelGetNumFuncs(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl<?>[] getFuncDecls() {
        int n = this.getNumFuncs();
        FuncDecl[] res = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public FuncDecl<?>[] getDecls() {
        int i;
        int nFuncs = this.getNumFuncs();
        int nConsts = this.getNumConsts();
        int n = nFuncs + nConsts;
        FuncDecl[] res = new FuncDecl[n];
        for (i = 0; i < nConsts; ++i) {
            res[i] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        for (i = 0; i < nFuncs; ++i) {
            res[nConsts + i] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public <R extends Sort> Expr<R> eval(Expr<R> t, boolean completion) {
        Native.LongPtr v = new Native.LongPtr();
        if (!Native.modelEval(this.getContext().nCtx(), this.getNativeObject(), t.getNativeObject(), completion, v)) {
            throw new ModelEvaluationFailedException();
        }
        return Expr.create(this.getContext(), v.value);
    }

    public <R extends Sort> Expr<R> evaluate(Expr<R> t, boolean completion) {
        return this.eval(t, completion);
    }

    public int getNumSorts() {
        return Native.modelGetNumSorts(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort[] getSorts() {
        int n = this.getNumSorts();
        Sort[] res = new Sort[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Sort.create(this.getContext(), Native.modelGetSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return res;
    }

    public <R extends Sort> Expr<R>[] getSortUniverse(R s) {
        ASTVector nUniv = new ASTVector(this.getContext(), Native.modelGetSortUniverse(this.getContext().nCtx(), this.getNativeObject(), s.getNativeObject()));
        return nUniv.ToExprArray();
    }

    public String toString() {
        return Native.modelToString(this.getContext().nCtx(), this.getNativeObject());
    }

    Model(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
        Native.modelIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (x$0, x$1) -> new ModelRef((Model)x$0, x$1));
    }

    private static class ModelRef
    extends Z3ReferenceQueue.Reference<Model> {
        private ModelRef(Model referent, ReferenceQueue<Z3Object> q) {
            super(referent, q);
        }

        @Override
        void decRef(Context ctx, long z3Obj) {
            Native.modelDecRef(ctx.nCtx(), z3Obj);
        }
    }

    public class ModelEvaluationFailedException
    extends Z3Exception {
    }
}

