/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.lang.ref.ReferenceQueue;
import java.util.List;

public class Solver
extends Z3Object {
    public String getHelp() {
        return Native.solverGetHelp(this.getContext().nCtx(), this.getNativeObject());
    }

    public void setParameters(Params value) {
        this.getContext().checkContextMatch(value);
        Native.solverSetParams(this.getContext().nCtx(), this.getNativeObject(), value.getNativeObject());
    }

    public ParamDescrs getParameterDescriptions() {
        return new ParamDescrs(this.getContext(), Native.solverGetParamDescrs(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumScopes() {
        return Native.solverGetNumScopes(this.getContext().nCtx(), this.getNativeObject());
    }

    public void push() {
        Native.solverPush(this.getContext().nCtx(), this.getNativeObject());
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int n) {
        Native.solverPop(this.getContext().nCtx(), this.getNativeObject(), n);
    }

    public void reset() {
        Native.solverReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public void interrupt() {
        Native.solverInterrupt(this.getContext().nCtx(), this.getNativeObject());
    }

    public void add(Expr<BoolSort> ... constraints) {
        this.getContext().checkContextMatch(constraints);
        for (Expr<BoolSort> a : constraints) {
            Native.solverAssert(this.getContext().nCtx(), this.getNativeObject(), a.getNativeObject());
        }
    }

    public void assertAndTrack(Expr<BoolSort>[] constraints, Expr<BoolSort>[] ps) {
        this.getContext().checkContextMatch(constraints);
        this.getContext().checkContextMatch(ps);
        if (constraints.length != ps.length) {
            throw new Z3Exception("Argument size mismatch");
        }
        for (int i = 0; i < constraints.length; ++i) {
            Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), constraints[i].getNativeObject(), ps[i].getNativeObject());
        }
    }

    public void assertAndTrack(Expr<BoolSort> constraint, Expr<BoolSort> p) {
        this.getContext().checkContextMatch(constraint);
        this.getContext().checkContextMatch(p);
        Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), constraint.getNativeObject(), p.getNativeObject());
    }

    public void fromFile(String file) {
        Native.solverFromFile(this.getContext().nCtx(), this.getNativeObject(), file);
    }

    public void fromString(String str) {
        Native.solverFromString(this.getContext().nCtx(), this.getNativeObject(), str);
    }

    public int getNumAssertions() {
        ASTVector assrts = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return assrts.size();
    }

    public BoolExpr[] getAssertions() {
        ASTVector assrts = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return assrts.ToBoolExprArray();
    }

    @SafeVarargs
    public final Status check(Expr<BoolSort> ... assumptions) {
        Z3_lbool r = assumptions == null ? Z3_lbool.fromInt(Native.solverCheck(this.getContext().nCtx(), this.getNativeObject())) : Z3_lbool.fromInt(Native.solverCheckAssumptions(this.getContext().nCtx(), this.getNativeObject(), assumptions.length, AST.arrayToNative(assumptions)));
        return this.lboolToStatus(r);
    }

    public Status check() {
        return this.check(null);
    }

    public Status getConsequences(Expr<BoolSort>[] assumptions, Expr<?>[] variables, List<Expr<BoolSort>> consequences) {
        ASTVector result = new ASTVector(this.getContext());
        ASTVector asms = new ASTVector(this.getContext());
        ASTVector vars = new ASTVector(this.getContext());
        for (Expr<BoolSort> expr : assumptions) {
            asms.push(expr);
        }
        for (Expr<BoolSort> expr : variables) {
            vars.push(expr);
        }
        int r = Native.solverGetConsequences(this.getContext().nCtx(), this.getNativeObject(), asms.getNativeObject(), vars.getNativeObject(), result.getNativeObject());
        for (int i = 0; i < result.size(); ++i) {
            consequences.add((BoolExpr)Expr.create(this.getContext(), result.get(i).getNativeObject()));
        }
        return this.lboolToStatus(Z3_lbool.fromInt(r));
    }

    public Model getModel() {
        long x = Native.solverGetModel(this.getContext().nCtx(), this.getNativeObject());
        if (x == 0L) {
            return null;
        }
        return new Model(this.getContext(), x);
    }

    public Expr<?> getProof() {
        long x = Native.solverGetProof(this.getContext().nCtx(), this.getNativeObject());
        if (x == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), x);
    }

    public BoolExpr[] getUnsatCore() {
        ASTVector core = new ASTVector(this.getContext(), Native.solverGetUnsatCore(this.getContext().nCtx(), this.getNativeObject()));
        return core.ToBoolExprArray();
    }

    public String getReasonUnknown() {
        return Native.solverGetReasonUnknown(this.getContext().nCtx(), this.getNativeObject());
    }

    public Solver translate(Context ctx) {
        return new Solver(ctx, Native.solverTranslate(this.getContext().nCtx(), this.getNativeObject(), ctx.nCtx()));
    }

    public Statistics getStatistics() {
        return new Statistics(this.getContext(), Native.solverGetStatistics(this.getContext().nCtx(), this.getNativeObject()));
    }

    public String toString() {
        return Native.solverToString(this.getContext().nCtx(), this.getNativeObject());
    }

    private Status lboolToStatus(Z3_lbool r) {
        switch (r) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    Solver(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
        Native.solverIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (x$0, x$1) -> new SolverRef((Solver)x$0, x$1));
    }

    private static class SolverRef
    extends Z3ReferenceQueue.Reference<Solver> {
        private SolverRef(Solver referent, ReferenceQueue<Z3Object> q) {
            super(referent, q);
        }

        @Override
        void decRef(Context ctx, long z3Obj) {
            Native.solverDecRef(ctx.nCtx(), z3Obj);
        }
    }
}

