/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Native;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_symbol_kind;

public class Symbol
extends Z3Object {
    protected Z3_symbol_kind getKind() {
        return Z3_symbol_kind.fromInt(Native.getSymbolKind(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isIntSymbol() {
        return this.getKind() == Z3_symbol_kind.Z3_INT_SYMBOL;
    }

    public boolean isStringSymbol() {
        return this.getKind() == Z3_symbol_kind.Z3_STRING_SYMBOL;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol other = (Symbol)o;
        return this.getNativeObject() == other.getNativeObject();
    }

    public String toString() {
        if (this.isIntSymbol()) {
            return Integer.toString(((IntSymbol)this).getInt());
        }
        if (this.isStringSymbol()) {
            return ((StringSymbol)this).getString();
        }
        return "Z3Exception: Unknown symbol kind encountered.";
    }

    protected Symbol(Context ctx, long obj) {
        super(ctx, obj);
    }

    @Override
    void incRef() {
    }

    @Override
    void addToReferenceQueue() {
    }

    static Symbol create(Context ctx, long obj) {
        switch (Z3_symbol_kind.fromInt(Native.getSymbolKind(ctx.nCtx(), obj))) {
            case Z3_INT_SYMBOL: {
                return new IntSymbol(ctx, obj);
            }
            case Z3_STRING_SYMBOL: {
                return new StringSymbol(ctx, obj);
            }
        }
        throw new Z3Exception("Unknown symbol kind encountered");
    }
}

