/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Z3Object;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;

class Z3ReferenceQueue {
    private final Context ctx;
    private final ReferenceQueue<Z3Object> referenceQueue = new ReferenceQueue();
    private final Reference<?> referenceList = Z3ReferenceQueue.emptyList();

    Z3ReferenceQueue(Context ctx) {
        this.ctx = ctx;
    }

    <T extends Z3Object> void storeReference(T z3Object, ReferenceConstructor<T> refConstructor) {
        ((Reference)this.referenceList).insert((Reference)refConstructor.construct(z3Object, this.referenceQueue));
        this.clear();
    }

    private void clear() {
        Reference ref;
        while ((ref = (Reference)this.referenceQueue.poll()) != null) {
            ref.cleanup(this.ctx);
        }
    }

    public void forceClear() {
        Reference cur = ((Reference)this.referenceList).next;
        while (cur.next != null) {
            cur.decRef(this.ctx, cur.nativePtr);
            cur = cur.next;
        }
        ((Reference)this.referenceList).next = cur;
        cur.prev = (Reference)this.referenceList;
        while (this.referenceQueue.poll() != null) {
        }
    }

    private static Reference<?> emptyList() {
        DummyReference head = new DummyReference();
        DummyReference tail = new DummyReference();
        ((Reference)head).next = (Reference)tail;
        ((Reference)tail).prev = (Reference)head;
        return head;
    }

    private static class DummyReference
    extends Reference<Z3Object> {
        public DummyReference() {
            super(null, (ReferenceQueue<Z3Object>)null);
        }

        @Override
        void decRef(Context ctx, long z3Obj) {
            assert (false);
        }
    }

    static abstract class Reference<T extends Z3Object>
    extends PhantomReference<T> {
        private Reference<?> prev;
        private Reference<?> next;
        private final long nativePtr;

        Reference(T referent, ReferenceQueue<Z3Object> q) {
            super(referent, q);
            this.nativePtr = referent != null ? ((Z3Object)referent).getNativeObject() : 0L;
        }

        private void cleanup(Context ctx) {
            this.decRef(ctx, this.nativePtr);
            assert (this.prev != null && this.next != null);
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }

        private void insert(Reference<?> ref) {
            assert (this.next != null);
            ref.prev = this;
            ref.next = this.next;
            ref.next.prev = ref;
            this.next = ref;
        }

        abstract void decRef(Context var1, long var2);
    }

    @FunctionalInterface
    static interface ReferenceConstructor<T extends Z3Object> {
        public Reference<T> construct(T var1, ReferenceQueue<Z3Object> var2);
    }
}

