/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk;

import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Window;

public class ZKCommonUtils {
    public static Page getFirstPage() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        return desktop.getFirstPage();
    }

    public static Window createWindow(String title, boolean closeable, boolean maximizable, String width, String height, EventListener<Event> onClose) {
        Window dialog = new Window();
        dialog.setTitle(title);
        dialog.setClosable(closeable);
        dialog.setMaximizable(maximizable);
        dialog.setBorder("normal");
        dialog.setPage(ZKCommonUtils.getFirstPage());
        dialog.setWidth(width);
        dialog.setHeight(height);
        dialog.addEventListener("onCancel", e -> {
            if (dialog.isClosable()) {
                dialog.detach();
            }
        });
        if (onClose != null) {
            dialog.addEventListener("onClose", onClose);
        }
        return dialog;
    }

    public static Window createWindow(String title, String width, String height, EventListener<Event> onClose) {
        return ZKCommonUtils.createWindow(title, true, false, width, height, onClose);
    }

    public static Window createWindow(String title, String width, String height) {
        return ZKCommonUtils.createWindow(title, width, height, null);
    }

    public static void showErrorMessage(Exception e) {
        ZKCommonUtils.showErrorMessage(e.getMessage());
    }

    public static void showErrorMessage(String message) {
        ZKCommonUtils.showErrorMessage(message, "Error");
    }

    public static void showErrorMessage(String message, String title) {
        Messagebox.show((String)message, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-error");
    }

    public static void showWarningMessage(String message) {
        ZKCommonUtils.showWarningMessage(message, "Warning");
    }

    public static void showWarningMessage(String message, String title) {
        Messagebox.show((String)message, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-exclamation");
    }
}

