/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import org.zkoss.zhtml.H4;
import org.zkoss.zhtml.I;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Button;
import org.zkoss.zul.Div;

public class Alert
extends Div {
    private H4 title;
    private Text titleValue;
    private I icon;
    private String iconSclass;
    private boolean closeable;
    private Button closeableBtn;
    private String type;
    private Text value;

    public Alert() {
        this.initUI();
    }

    protected void initUI() {
        this.setZclass("alert alert-dismissible");
        this.closeableBtn = new Button("x");
        this.closeableBtn.setZclass("close");
        this.closeableBtn.setClientDataAttribute("dismiss", "alert");
        this.closeableBtn.setClientAttribute("aria-hidden", "true");
        this.appendChild((Component)this.closeableBtn);
        this.title = new H4();
        this.title.setStyle("font-size: 110%");
        this.icon = new I();
        this.icon.setSclass("icon");
        this.title.appendChild((Component)this.icon);
        this.titleValue = new Text();
        this.title.appendChild((Component)this.titleValue);
        this.appendChild((Component)this.title);
        this.value = new Text();
        this.appendChild((Component)this.value);
        this.setType(this.type);
    }

    public void setTitle(String title) {
        this.titleValue.setValue(title);
    }

    public String getTitle() {
        return this.titleValue.getValue();
    }

    public void setValue(String value) {
        this.value.setValue(value);
    }

    public String getValue() {
        return this.value.getValue();
    }

    public String getIconSclass() {
        return this.iconSclass;
    }

    public void setIconSclass(String iconSclass) {
        this.iconSclass = iconSclass;
        this.icon.setSclass("icon " + iconSclass);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null) {
            this.type = type;
            if (type.equalsIgnoreCase("danger")) {
                type = "ERROR";
            } else if (type.equalsIgnoreCase("success")) {
                type = "NORMAL";
            }
            String sclass = "";
            String icon = null;
            switch (type.toUpperCase()) {
                case "NORMAL": 
                case "SUCCESS": {
                    sclass = "alert-success";
                    icon = "fas fa-check";
                    break;
                }
                case "ERROR": 
                case "CRITICAL": 
                case "DANGER": {
                    sclass = "alert-danger";
                    icon = "fas fa-ban";
                    break;
                }
                case "WARNING": {
                    sclass = "alert-warning";
                    icon = "fas fa-exclamation-triangle";
                    break;
                }
                case "INFO": {
                    sclass = "alert-info";
                    icon = "fas fa-info";
                    break;
                }
                case "SPECIAL": {
                    sclass = "bg-puple";
                    icon = "fas fa-smile";
                    break;
                }
                default: {
                    sclass = "alert-default";
                }
            }
            this.setZclass("alert alert-dismissible " + sclass);
            this.setIconSclass(icon);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        this.closeableBtn.setVisible(this.closeable);
    }

    public Button getCloseableBtn() {
        return this.closeableBtn;
    }
}

