/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.List;
import java.util.Objects;
import org.zkoss.zhtml.H3;
import org.zkoss.zhtml.I;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Button;
import org.zkoss.zul.Div;
import tools.dynamia.zk.ui.DivContainer;

public class Card
extends DivContainer {
    public static final String SCLASS_PREFIX = "card-";
    private Div header;
    private Div body = new Div();
    private Div tools;
    private H3 title;
    private String iconSclass;
    private I icon;
    private Text titleValue;
    private String color;
    private boolean expandable;
    private Button expandableBtn;
    private boolean collapsable;
    private Button collapsableBtn;
    private boolean closeable;
    private Button closableBtn;

    public Card() {
        this.initUI();
    }

    protected void initUI() {
        this.setZclass("card");
        this.header = new Div();
        this.header.setZclass("card-header");
        this.appendChild((Component)this.header);
        this.title = new H3();
        this.title.setSclass("card-title");
        this.titleValue = new Text();
        this.icon = new I();
        this.title.appendChild((Component)this.icon);
        this.title.appendChild((Component)this.titleValue);
        this.header.appendChild((Component)this.title);
        this.header.setVisible(false);
        this.tools = new Div();
        this.tools.setZclass("card-tools");
        this.header.appendChild((Component)this.tools);
        this.body = new Div();
        this.body.setZclass("card-body");
        this.appendChild((Component)this.body);
        this.collapsableBtn = this.createToolButton("fa fa-minus", "collapse");
        this.expandableBtn = this.createToolButton("fa fa-expand", "maximize");
        this.closableBtn = this.createToolButton("fa fa-times", "remove");
    }

    private Button createToolButton(String icon, String role) {
        Button btn = new Button();
        btn.setZclass("btn btn-tool");
        btn.setIconSclass(icon);
        btn.setClientDataAttribute("card-widget", role);
        return btn;
    }

    public void setTitle(String title) {
        if (!Objects.equals(this.titleValue.getValue(), title)) {
            this.titleValue.setValue(" " + title);
            this.header.setVisible(true);
        }
    }

    public String getTitle() {
        return this.titleValue.getValue();
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        if (!Objects.equals(this.color, color)) {
            this.removeSclass(SCLASS_PREFIX + color);
            this.color = color;
            this.addSclass(SCLASS_PREFIX + color);
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild != this.header && newChild != this.body) {
            return this.body.insertBefore(newChild, refChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public <T extends Component> List<T> getChildren() {
        return this.body.getChildren();
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
        if (this.expandable) {
            this.expandableBtn.setParent((Component)this.tools);
        } else {
            this.expandableBtn.setParent(null);
        }
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean collapsable) {
        this.collapsable = collapsable;
        if (this.collapsable) {
            this.collapsableBtn.setParent((Component)this.tools);
        } else {
            this.collapsableBtn.setParent(null);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (this.closeable) {
            this.closableBtn.setParent((Component)this.tools);
        } else {
            this.closableBtn.setParent(null);
        }
    }

    public Button getExpandableBtn() {
        return this.expandableBtn;
    }

    public Button getCollapsableBtn() {
        return this.collapsableBtn;
    }

    public Button getClosableBtn() {
        return this.closableBtn;
    }

    public String getIconSclass() {
        return this.iconSclass;
    }

    public void setIconSclass(String iconSclass) {
        if (!Objects.equals(this.iconSclass, iconSclass)) {
            this.iconSclass = iconSclass;
            this.icon.setSclass(iconSclass);
        }
    }
}

