/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.SimpleConstraint;
import tools.dynamia.zk.ui.Aceditor;

public class GrammarConstraint
extends SimpleConstraint {
    private static final long serialVersionUID = 1L;
    public static final int GRAMMAR_STRICT = 5;
    public static final int GRAMMAR_LENIENT = 6;

    public GrammarConstraint(String constraint) {
        super(constraint);
    }

    public void validate(Component comp, Object value) throws WrongValueException {
        boolean lenient;
        boolean strict = (this._flags & 5) != 0;
        boolean bl = lenient = (this._flags & 6) != 0;
        if (comp instanceof Aceditor) {
            Aceditor aceditor = (Aceditor)comp;
            if ((strict || lenient) && aceditor.annotations != null && !aceditor.annotations.isEmpty()) {
                StringBuilder issues = new StringBuilder();
                for (Map<String, Object> annotation : aceditor.annotations) {
                    if (!"error".equals(annotation.get("type")) && !strict) continue;
                    if (!issues.isEmpty()) {
                        issues.append(" ");
                    }
                    issues.append(annotation.get("text"));
                    issues.append(" (line ");
                    issues.append(annotation.get("row"));
                    issues.append(")");
                }
                if (!issues.isEmpty()) {
                    throw new WrongValueException((Component)aceditor, issues.toString());
                }
            }
        }
        super.validate(comp, value);
    }

    protected int parseConstraint(String constraint) throws UiException {
        if (constraint.equals("grammar(strict)")) {
            return 5;
        }
        if (constraint.equals("grammar(lenient)")) {
            return 6;
        }
        return super.parseConstraint(constraint);
    }
}

