/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.zkoss.util.Locales;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import tools.dynamia.zk.ZKModelsUtils;

public class LocaleCombobox
extends Combobox {
    private static final long serialVersionUID = 4710970528102748639L;
    private String selected;

    public LocaleCombobox() {
        this.setReadonly(true);
        this.initModel();
    }

    private void initModel() {
        this.setItemRenderer((item, data, index) -> {
            Locale locale = (Locale)data;
            item.setLabel(locale.getDisplayName(Locales.getCurrent()));
            item.setValue((Object)locale.toLanguageTag());
        });
        ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        locales.sort(Comparator.comparing(Locale::getDisplayName));
        ZKModelsUtils.fillCombobox((Combobox)this, locales, true);
        String defaultLocale = Locale.getDefault().toLanguageTag();
        this.setSelected(defaultLocale);
    }

    public String getSelected() {
        this.selected = null;
        if (this.getSelectedItem() != null) {
            this.selected = (String)this.getSelectedItem().getValue();
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        if (selected != this.selected) {
            this.selected = selected;
            try {
                String[] parts = selected.split("-");
                Locale locale = new Locale(parts[0]);
                if (parts.length == 2) {
                    locale = new Locale(parts[0], parts[1]);
                }
                ListModelList model = (ListModelList)this.getModel();
                model.addToSelection((Object)locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

