/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.List;
import java.util.Map;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModel;
import tools.dynamia.zk.ZKModelsUtils;
import tools.dynamia.zk.ui.SimpleItem;

public class SimpleCombobox
extends Combobox {
    private List<SimpleItem> simpleModel;
    private SimpleItem selected;

    public SimpleCombobox() {
        this.setItemRenderer((item, data, index) -> {
            item.setValue(data);
            if (data instanceof SimpleItem) {
                item.setLabel(((SimpleItem)data).getLabel().replace("_", " "));
            } else {
                item.setLabel(data.toString());
            }
        });
        this.setReadonly(true);
    }

    public void setModelMap(Map<String, Object> model) {
        List<SimpleItem> items = SimpleItem.parse(model);
        this.setSimpleModel(items);
    }

    public void setSimpleModel(List<SimpleItem> simpleModel) {
        this.simpleModel = simpleModel;
        ZKModelsUtils.fillCombobox((Combobox)this, simpleModel, true);
    }

    public List<SimpleItem> getSimpleModel() {
        return this.simpleModel;
    }

    public Object getSelected() {
        if (this.getSelectedItem() != null) {
            this.selected = (SimpleItem)this.getSelectedItem().getValue();
        }
        return this.selected.getValue();
    }

    public void setSelected(SimpleItem selected) {
        this.selected = selected;
        ListModel listModel = this.getModel();
        if (listModel instanceof AbstractListModel) {
            AbstractListModel model = (AbstractListModel)listModel;
            model.addToSelection((Object)selected);
        }
    }

    public void setSelected(Object value) {
        SimpleItem item = this.simpleModel.stream().filter(s -> s.getValue().equals(value)).findFirst().orElse(null);
        this.setSelected(item);
    }
}

