/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import tools.dynamia.zk.ZKModelsUtils;

public class TimeZoneCombobox
extends Combobox {
    private static final long serialVersionUID = 4710970528102748639L;
    private String selected;

    public TimeZoneCombobox() {
        this.setReadonly(true);
        this.initModel();
    }

    private void initModel() {
        LocalDateTime dt = LocalDateTime.now();
        this.setItemRenderer((item, data, index) -> {
            String zoneId = (String)data;
            item.setValue((Object)zoneId);
            ZoneId zone = ZoneId.of(zoneId);
            ZonedDateTime zdt = dt.atZone(zone);
            ZoneOffset offset = zdt.getOffset();
            String out = String.format("%s (%s)", zone, offset);
            item.setLabel(out);
        });
        Set<String> allZones = ZoneId.getAvailableZoneIds();
        ArrayList<String> zoneList = new ArrayList<String>(allZones);
        Collections.sort(zoneList);
        ZKModelsUtils.fillCombobox(this, zoneList, ZoneId.systemDefault().getId(), true);
    }

    public String getSelected() {
        this.selected = null;
        if (this.getSelectedItem() != null) {
            this.selected = (String)this.getSelectedItem().getValue();
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        if (selected != this.selected) {
            this.selected = selected;
            try {
                ListModelList model = (ListModelList)this.getModel();
                model.addToSelection((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

