/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui.chartjs;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import tools.dynamia.zk.LazyJSONObject;
import tools.dynamia.zk.ui.chartjs.ChartjsData;
import tools.dynamia.zk.ui.chartjs.ChartjsOptions;

public class Chartjs
extends HtmlBasedComponent {
    public static final String TYPE_BAR = "bar";
    public static final String TYPE_HORIZONTAL_BAR = "horizontalBar";
    public static final String TYPE_LINE = "line";
    public static final String TYPE_PIE = "pie";
    public static final String TYPE_SCATTER = "scatter";
    public static final String TYPE_DOUGHNUT = "doughnut";
    public static final String TYPE_RADAR = "radar";
    public static final String TYPE_POLAR_AREA = "polarArea";
    public static final String TYPE_BUBBLE = "bubble";
    public static final String ON_DATA_CHANGE = "onDataChange";
    private String type;
    private ChartjsData data;
    private ChartjsOptions options = new ChartjsOptions();

    public Chartjs() {
    }

    public Chartjs(String type) {
        this.type = type;
    }

    public Chartjs(String type, ChartjsData data) {
        this.type = type;
        this.data = data;
    }

    public Chartjs(String type, ChartjsData data, ChartjsOptions options) {
        this.type = type;
        this.data = data;
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!Objects.equals((Object)this.type, (Object)type)) {
            this.type = type;
            this.smartUpdate("type", type);
        }
    }

    public ChartjsData getData() {
        return this.data;
    }

    public void setData(ChartjsData data) {
        LazyJSONObject.init(data);
        if (!Objects.equals((Object)((Object)this.data), (Object)((Object)data))) {
            this.data = data;
            this.initListener();
            this.fireDatachange();
        }
    }

    public ChartjsOptions getOptions() {
        if (this.options == null) {
            this.options = new ChartjsOptions();
        }
        return this.options;
    }

    public void setOptions(ChartjsOptions options) {
        LazyJSONObject.init(options);
        if (!Objects.equals((Object)((Object)this.options), (Object)((Object)options))) {
            this.options = options;
            this.smartUpdate("options", (Object)options);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        LazyJSONObject.init(this.options);
        this.render(renderer, "type", this.type);
        this.render(renderer, "data", this.data);
        this.render(renderer, "options", this.options);
    }

    public String getTitle() {
        return this.getOptions().getTitle();
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this.getOptions().getTitle(), (Object)title)) {
            this.getOptions().setTitle(title);
            this.smartUpdate("options", (Object)this.getOptions());
        }
    }

    public void setResponsive(boolean responsive) {
        if (!Objects.equals((Object)this.getOptions().isResponsive(), (Object)responsive)) {
            this.getOptions().setResponsive(responsive);
            this.smartUpdate("options", (Object)this.getOptions());
        }
    }

    public boolean isReponsive() {
        return this.getOptions().isResponsive();
    }

    private void fireDatachange() {
        this.smartUpdate("data", (Object)this.data);
        Events.postEvent((String)ON_DATA_CHANGE, (Component)this, (Object)((Object)this.data));
    }

    private void initListener() {
        if (this.data != null) {
            this.data.addPropertyChangeListener(evt -> this.fireDatachange());
        }
    }

    protected void render(ContentRenderer renderer, String name, LazyJSONObject value) throws IOException {
        if (value != null) {
            value.init();
        }
        super.render(renderer, name, (Object)value);
    }

    public static Number randomScallingFactor() {
        return (Math.random() > 0.5 ? 1.0 : -1.0) * (double)Math.round(Math.random() * 100.0);
    }

    public static int randomColorFactor() {
        return (int)Math.round(Math.random() * 255.0);
    }

    public static String randomColor() {
        return "rgba(" + Chartjs.randomColorFactor() + "," + Chartjs.randomColorFactor() + "," + Chartjs.randomColorFactor() + ",.7)";
    }
}

