/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui.chartjs;

import java.util.HashMap;
import tools.dynamia.zk.LazyJSONObject;
import tools.dynamia.zk.ui.chartjs.Legend;
import tools.dynamia.zk.ui.chartjs.Scales;
import tools.dynamia.zk.ui.chartjs.Tooltips;

public class ChartjsOptions
extends LazyJSONObject {
    private String title;
    private boolean responsive = true;
    private Scales scales;
    private Legend legend;
    private Tooltips tooltips;

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Tooltips getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(Tooltips tooltips) {
        this.tooltips = tooltips;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isResponsive() {
        return this.responsive;
    }

    public void setResponsive(boolean responsive) {
        this.responsive = responsive;
    }

    public Scales getScales() {
        return this.scales;
    }

    public void setScales(Scales scales) {
        this.scales = scales;
    }

    @Override
    public void init() {
        super.init();
        if (this.title != null) {
            HashMap<String, Object> titleMap = new HashMap<String, Object>();
            titleMap.put("text", this.title);
            titleMap.put("display", true);
            this.put("title", titleMap);
        }
        this.put("responsive", this.responsive);
        if (this.scales != null) {
            this.scales.init();
            this.put("scales", (Object)this.scales);
        }
    }

    public static final class Builder {
        private String title;
        private boolean responsive = true;
        private Scales scales;
        private Legend legend;
        private Tooltips tooltips;

        private Builder() {
        }

        public static Builder init() {
            return new Builder();
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder responsive(boolean responsive) {
            this.responsive = responsive;
            return this;
        }

        public Builder scales(Scales scales) {
            this.scales = scales;
            return this;
        }

        public Builder legend(Legend legend) {
            this.legend = legend;
            return this;
        }

        public Builder tooltips(Tooltips tooltips) {
            this.tooltips = tooltips;
            return this;
        }

        public ChartjsOptions build() {
            ChartjsOptions chartjsOptions = new ChartjsOptions();
            chartjsOptions.setTitle(this.title);
            chartjsOptions.setResponsive(this.responsive);
            chartjsOptions.setScales(this.scales);
            chartjsOptions.setLegend(this.legend);
            chartjsOptions.setTooltips(this.tooltips);
            chartjsOptions.init();
            return chartjsOptions;
        }
    }
}

