/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui.chartjs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tools.dynamia.zk.LazyJSONObject;
import tools.dynamia.zk.ui.chartjs.ChartjsColorPalette;

public class Dataset<T>
extends LazyJSONObject {
    private String type;
    private List<T> data;
    private String label;
    private String backgroundColor;
    private List<String> backgroundColors;
    private String borderColor;
    private Integer borderWidth;
    private String borderCapStyle;
    private String borderJoinStyle;
    private String borderDash;
    private String borderDashOffset;
    private String hoverBackgroundColor;
    private List<String> hoverBackgroundColors;
    private String pointBackgroundColor;
    private String pointBorderColor;
    private Integer pointBorderWidth;
    private String pointStyle;
    private Integer pointHitRadius;
    private String pointHoverBackgroundColor;
    private String pointHoverBorderColor;
    private Integer pointHoverBorderWidth;
    private Integer pointHoverRadius;
    private Integer radius;
    private Integer lineTension;
    private Boolean hidden;
    private Boolean fill;
    private Boolean showLine;
    private Boolean spanGaps;
    private Boolean steppedLine;
    private String xAxisID;
    private String yAxisID;
    private ChartjsColorPalette colorPalette = new ChartjsColorPalette();

    public Dataset() {
    }

    public Dataset(String label) {
        this.label = label;
    }

    public Dataset(String label, List<T> data) {
        this.label = label;
        this.data = data;
        for (T t : data) {
            this.addBackgroundColor(this.colorPalette.nextColor());
        }
    }

    public Dataset(String label, String backgroundColor, List<T> data) {
        this.label = label;
        this.backgroundColor = backgroundColor;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public Dataset<T> setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public Dataset<T> setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public List<T> getData() {
        return this.data;
    }

    public Dataset<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public Dataset<T> setData(T ... data) {
        this.data = Arrays.asList(data);
        return this;
    }

    public Dataset<T> addData(T data) {
        if (this.data == null) {
            this.data = new ArrayList<T>();
        }
        this.data.add(data);
        String color = this.colorPalette.nextColor();
        this.addBackgroundColor(color);
        return this;
    }

    public List<String> getBackgroundColors() {
        return this.backgroundColors;
    }

    public Dataset<T> setBackgroundColors(List<String> backgroundColors) {
        this.backgroundColors = backgroundColors;
        return this;
    }

    public Dataset<T> setBackgroundColors(String ... colors) {
        this.backgroundColors = Arrays.asList(colors);
        return this;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Dataset<T> setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public String getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    public Dataset<T> setHoverBackgroundColor(String hoverBackgroundColor) {
        this.hoverBackgroundColor = hoverBackgroundColor;
        return this;
    }

    public List<String> getHoverBackgroundColors() {
        return this.hoverBackgroundColors;
    }

    public Dataset<T> setHoverBackgroundColors(List<String> hoverBackgroundColors) {
        this.hoverBackgroundColors = hoverBackgroundColors;
        return this;
    }

    public Dataset<T> setHoverBackgroundColors(String ... colors) {
        this.hoverBackgroundColors = Arrays.asList(colors);
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public Dataset<T> setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public String getPointBackgroundColor() {
        return this.pointBackgroundColor;
    }

    public Dataset<T> setPointBackgroundColor(String pointBackgroundColor) {
        this.pointBackgroundColor = pointBackgroundColor;
        return this;
    }

    public String getPointBorderColor() {
        return this.pointBorderColor;
    }

    public Dataset<T> setPointBorderColor(String pointBorderColor) {
        this.pointBorderColor = pointBorderColor;
        return this;
    }

    public int getPointBorderWidth() {
        return this.pointBorderWidth;
    }

    public Dataset<T> setPointBorderWidth(int pointBorderWidth) {
        this.pointBorderWidth = pointBorderWidth;
        return this;
    }

    public ChartjsColorPalette getColorPalette() {
        return this.colorPalette;
    }

    public void setColorPalette(ChartjsColorPalette colorPalette) {
        if (colorPalette != null) {
            this.colorPalette = colorPalette;
        }
    }

    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public String getBorderCapStyle() {
        return this.borderCapStyle;
    }

    public void setBorderCapStyle(String borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
    }

    public String getBorderJoinStyle() {
        return this.borderJoinStyle;
    }

    public void setBorderJoinStyle(String borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
    }

    public String getBorderDash() {
        return this.borderDash;
    }

    public void setBorderDash(String borderDash) {
        this.borderDash = borderDash;
    }

    public String getBorderDashOffset() {
        return this.borderDashOffset;
    }

    public void setBorderDashOffset(String borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
    }

    public void setPointBorderWidth(Integer pointBorderWidth) {
        this.pointBorderWidth = pointBorderWidth;
    }

    public String getPointStyle() {
        return this.pointStyle;
    }

    public void setPointStyle(String pointStyle) {
        this.pointStyle = pointStyle;
    }

    public Integer getLineTension() {
        return this.lineTension;
    }

    public void setLineTension(Integer lineTension) {
        this.lineTension = lineTension;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getFill() {
        return this.fill;
    }

    public void setFill(Boolean fill) {
        this.fill = fill;
    }

    public Integer getPointHitRadius() {
        return this.pointHitRadius;
    }

    public void setPointHitRadius(Integer pointHitRadius) {
        this.pointHitRadius = pointHitRadius;
    }

    public String getPointHoverBackgroundColor() {
        return this.pointHoverBackgroundColor;
    }

    public void setPointHoverBackgroundColor(String pointHoverBackgroundColor) {
        this.pointHoverBackgroundColor = pointHoverBackgroundColor;
    }

    public String getPointHoverBorderColor() {
        return this.pointHoverBorderColor;
    }

    public void setPointHoverBorderColor(String pointHoverBorderColor) {
        this.pointHoverBorderColor = pointHoverBorderColor;
    }

    public Integer getPointHoverBorderWidth() {
        return this.pointHoverBorderWidth;
    }

    public void setPointHoverBorderWidth(Integer pointHoverBorderWidth) {
        this.pointHoverBorderWidth = pointHoverBorderWidth;
    }

    public Integer getPointHoverRadius() {
        return this.pointHoverRadius;
    }

    public void setPointHoverRadius(Integer pointHoverRadius) {
        this.pointHoverRadius = pointHoverRadius;
    }

    public Boolean getShowLine() {
        return this.showLine;
    }

    public void setShowLine(Boolean showLine) {
        this.showLine = showLine;
    }

    public Boolean getSpanGaps() {
        return this.spanGaps;
    }

    public void setSpanGaps(Boolean spanGaps) {
        this.spanGaps = spanGaps;
    }

    public Boolean getSteppedLine() {
        return this.steppedLine;
    }

    public void setSteppedLine(Boolean steppedLine) {
        this.steppedLine = steppedLine;
    }

    @Override
    public void init() {
        super.init();
        if (this.backgroundColor != null) {
            this.put("backgroundColor", this.backgroundColor);
        } else if (this.backgroundColors != null && !this.backgroundColors.isEmpty()) {
            this.put("backgroundColor", this.backgroundColors);
        }
        if (this.hoverBackgroundColor != null) {
            this.put("hoverBackgroundColor", this.hoverBackgroundColor);
        } else if (this.hoverBackgroundColors != null && !this.hoverBackgroundColors.isEmpty()) {
            this.put("hoverBackgroundColor", this.hoverBackgroundColors);
        }
        this.put("data", this.data);
    }

    public void addBackgroundColor(String color) {
        if (this.backgroundColors == null) {
            this.backgroundColors = new ArrayList<String>();
        }
        this.backgroundColors.add(color);
    }

    public String getxAxisID() {
        return this.xAxisID;
    }

    public void setxAxisID(String xAxisID) {
        this.xAxisID = xAxisID;
    }

    public String getyAxisID() {
        return this.yAxisID;
    }

    public void setyAxisID(String yAxisID) {
        this.yAxisID = yAxisID;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    public static final class Builder {
        private List data;
        private String label;
        private String backgroundColor;
        private List<String> backgroundColors;
        private String borderColor;
        private Integer borderWidth;
        private String borderCapStyle;
        private String borderJoinStyle;
        private String borderDash;
        private String borderDashOffset;
        private String hoverBackgroundColor;
        private List<String> hoverBackgroundColors;
        private String pointBackgroundColor;
        private String pointBorderColor;
        private Integer pointBorderWidth;
        private String pointStyle;
        private Integer pointHitRadius;
        private String pointHoverBackgroundColor;
        private String pointHoverBorderColor;
        private Integer pointHoverBorderWidth;
        private Integer pointHoverRadius;
        private Integer lineTension;
        private Boolean hidden;
        private Boolean fill;
        private Boolean showLine;
        private Boolean spanGaps;
        private Boolean steppedLine;
        private String xAxisID;
        private String yAxisID;
        private Integer radius;

        private Builder() {
        }

        public static Builder init() {
            return new Builder();
        }

        public Builder data(List data) {
            this.data = data;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder backgroundColors(List<String> backgroundColors) {
            this.backgroundColors = backgroundColors;
            return this;
        }

        public Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public Builder borderWidth(Integer borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        public Builder borderCapStyle(String borderCapStyle) {
            this.borderCapStyle = borderCapStyle;
            return this;
        }

        public Builder borderJoinStyle(String borderJoinStyle) {
            this.borderJoinStyle = borderJoinStyle;
            return this;
        }

        public Builder borderDash(String borderDash) {
            this.borderDash = borderDash;
            return this;
        }

        public Builder borderDashOffset(String borderDashOffset) {
            this.borderDashOffset = borderDashOffset;
            return this;
        }

        public Builder hoverBackgroundColor(String hoverBackgroundColor) {
            this.hoverBackgroundColor = hoverBackgroundColor;
            return this;
        }

        public Builder hoverBackgroundColors(List<String> hoverBackgroundColors) {
            this.hoverBackgroundColors = hoverBackgroundColors;
            return this;
        }

        public Builder pointBackgroundColor(String pointBackgroundColor) {
            this.pointBackgroundColor = pointBackgroundColor;
            return this;
        }

        public Builder pointBorderColor(String pointBorderColor) {
            this.pointBorderColor = pointBorderColor;
            return this;
        }

        public Builder pointBorderWidth(Integer pointBorderWidth) {
            this.pointBorderWidth = pointBorderWidth;
            return this;
        }

        public Builder pointStyle(String pointStyle) {
            this.pointStyle = pointStyle;
            return this;
        }

        public Builder pointHitRadius(Integer pointHitRadius) {
            this.pointHitRadius = pointHitRadius;
            return this;
        }

        public Builder pointHoverBackgroundColor(String pointHoverBackgroundColor) {
            this.pointHoverBackgroundColor = pointHoverBackgroundColor;
            return this;
        }

        public Builder pointHoverBorderColor(String pointHoverBorderColor) {
            this.pointHoverBorderColor = pointHoverBorderColor;
            return this;
        }

        public Builder pointHoverBorderWidth(Integer pointHoverBorderWidth) {
            this.pointHoverBorderWidth = pointHoverBorderWidth;
            return this;
        }

        public Builder pointHoverRadius(Integer pointHoverRadius) {
            this.pointHoverRadius = pointHoverRadius;
            return this;
        }

        public Builder lineTension(Integer lineTension) {
            this.lineTension = lineTension;
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder fill(Boolean fill) {
            this.fill = fill;
            return this;
        }

        public Builder showLine(Boolean showLine) {
            this.showLine = showLine;
            return this;
        }

        public Builder spanGaps(Boolean spanGaps) {
            this.spanGaps = spanGaps;
            return this;
        }

        public Builder steppedLine(Boolean steppedLine) {
            this.steppedLine = steppedLine;
            return this;
        }

        public Builder xAxisID(String xAxisID) {
            this.xAxisID = xAxisID;
            return this;
        }

        public Builder yAxisID(String yAxisID) {
            this.yAxisID = yAxisID;
            return this;
        }

        public Builder radius(Integer radius) {
            this.radius = radius;
            return this;
        }

        public Dataset build() {
            Dataset dataset = new Dataset();
            dataset.setData(this.data);
            dataset.setLabel(this.label);
            dataset.setBackgroundColor(this.backgroundColor);
            dataset.setBackgroundColors(this.backgroundColors);
            dataset.setBorderColor(this.borderColor);
            dataset.setBorderWidth(this.borderWidth);
            dataset.setBorderCapStyle(this.borderCapStyle);
            dataset.setBorderJoinStyle(this.borderJoinStyle);
            dataset.setBorderDash(this.borderDash);
            dataset.setBorderDashOffset(this.borderDashOffset);
            dataset.setHoverBackgroundColor(this.hoverBackgroundColor);
            dataset.setHoverBackgroundColors(this.hoverBackgroundColors);
            dataset.setPointBackgroundColor(this.pointBackgroundColor);
            dataset.setPointBorderColor(this.pointBorderColor);
            dataset.setPointBorderWidth(this.pointBorderWidth);
            dataset.setPointStyle(this.pointStyle);
            dataset.setPointHitRadius(this.pointHitRadius);
            dataset.setPointHoverBackgroundColor(this.pointHoverBackgroundColor);
            dataset.setPointHoverBorderColor(this.pointHoverBorderColor);
            dataset.setPointHoverBorderWidth(this.pointHoverBorderWidth);
            dataset.setPointHoverRadius(this.pointHoverRadius);
            dataset.setLineTension(this.lineTension);
            dataset.setHidden(this.hidden);
            dataset.setFill(this.fill);
            dataset.setShowLine(this.showLine);
            dataset.setSpanGaps(this.spanGaps);
            dataset.setSteppedLine(this.steppedLine);
            dataset.xAxisID = this.xAxisID;
            dataset.yAxisID = this.yAxisID;
            dataset.setRadius(this.radius);
            return dataset;
        }
    }
}

