/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.addons.chartjs;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import tools.dynamia.zk.addons.chartjs.Dataset;
import tools.dynamia.zk.addons.chartjs.LazyJSONObject;

public class ChartjsData
extends LazyJSONObject {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private List<String> labels = new ArrayList<String>();
    private final List<Dataset> datasets = new ArrayList<Dataset>();

    @Override
    public void init() {
        for (Dataset dataset : this.datasets) {
            dataset.init();
        }
        this.put("labels", this.labels);
        this.put("datasets", this.datasets);
    }

    public void addLabel(String label) {
        this.labels.add(label);
        this.propertyChangeSupport.firePropertyChange("labels", null, this.labels);
    }

    public void setLabels(String ... labels) {
        if (labels != null) {
            for (String label : labels) {
                this.labels.add(label);
            }
            this.propertyChangeSupport.firePropertyChange("labels", null, this.labels);
        }
    }

    public void setLabels(List<String> labels) {
        if (labels != null) {
            this.labels = labels;
            this.propertyChangeSupport.firePropertyChange("labels", null, this.labels);
        }
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void addDataset(Dataset dataset) {
        this.datasets.add(dataset);
        this.fireDatasetChange();
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Dataset getDataset(String label) {
        Dataset result = null;
        if (label != null && this.datasets != null) {
            for (Dataset dataset : this.datasets) {
                if (!label.equals(dataset.getLabel())) continue;
                result = dataset;
            }
        }
        return result;
    }

    public void removeDatasets() {
        if (this.datasets != null) {
            this.datasets.clear();
            this.fireDatasetChange();
        }
    }

    public void removeLabels() {
        if (this.labels != null) {
            this.labels.clear();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void notifyChange() {
        this.fireDatasetChange();
    }

    private void fireDatasetChange() {
        this.propertyChangeSupport.firePropertyChange("dataset", null, this.datasets);
    }
}

