/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab;

import android.content.Context;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.regex.Pattern;
import tools.fastlane.screengrab.FileWritingScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotStrategy;
import tools.fastlane.screengrab.UiAutomatorScreenshotStrategy;

public class Screengrab {
    private static final Pattern TAG_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private static ScreenshotStrategy defaultScreenshotStrategy = new UiAutomatorScreenshotStrategy();

    public static ScreenshotStrategy getDefaultScreenshotStrategy() {
        return defaultScreenshotStrategy;
    }

    public static void setDefaultScreenshotStrategy(ScreenshotStrategy strategy) {
        defaultScreenshotStrategy = strategy;
    }

    public static void screenshot(String screenshotName) {
        Screengrab.screenshot(screenshotName, defaultScreenshotStrategy);
    }

    public static void screenshot(String screenshotName, ScreenshotStrategy strategy) {
        Context appContext = InstrumentationRegistry.getInstrumentation().getTargetContext().getApplicationContext();
        Screengrab.screenshot(screenshotName, strategy, new FileWritingScreenshotCallback(appContext));
    }

    public static void screenshot(String screenshotName, ScreenshotStrategy strategy, ScreenshotCallback callback) {
        if (!TAG_PATTERN.matcher(screenshotName).matches()) {
            throw new IllegalArgumentException("screenshotName may only contain the letters a-z,  A-Z, the numbers 0-9, underscores, and hyphens");
        }
        strategy.takeScreenshot(screenshotName, callback);
    }

    private Screengrab() {
    }
}

