/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab;

import android.content.Context;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.Locale;
import java.util.regex.Pattern;
import tools.fastlane.screengrab.FileWritingScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotCallback;
import tools.fastlane.screengrab.ScreenshotStrategy;
import tools.fastlane.screengrab.UiAutomatorScreenshotStrategy;

public class Screengrab {
    private static final Pattern TAG_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private static ScreenshotStrategy defaultScreenshotStrategy = new UiAutomatorScreenshotStrategy();
    private static String locale;

    public static String getLocale() {
        if (locale == null) {
            Locale implicitLocale = Locale.getDefault();
            StringBuilder sb = new StringBuilder(implicitLocale.getLanguage());
            String localeCountry = implicitLocale.getCountry();
            if (localeCountry.length() != 0) {
                sb.append("-").append(localeCountry);
            }
            return sb.toString();
        }
        return locale;
    }

    public static void setLocale(String locale) {
        Screengrab.locale = locale;
    }

    public static ScreenshotStrategy getDefaultScreenshotStrategy() {
        return defaultScreenshotStrategy;
    }

    public static void setDefaultScreenshotStrategy(ScreenshotStrategy strategy) {
        defaultScreenshotStrategy = strategy;
    }

    public static void screenshot(String screenshotName) {
        Screengrab.screenshot(screenshotName, defaultScreenshotStrategy);
    }

    public static void screenshot(String screenshotName, ScreenshotStrategy strategy) {
        Context appContext = InstrumentationRegistry.getInstrumentation().getTargetContext().getApplicationContext();
        Screengrab.screenshot(screenshotName, strategy, new FileWritingScreenshotCallback(appContext, Screengrab.getLocale()));
    }

    public static void screenshot(String screenshotName, ScreenshotStrategy strategy, ScreenshotCallback callback) {
        if (!TAG_PATTERN.matcher(screenshotName).matches()) {
            throw new IllegalArgumentException("screenshotName may only contain the letters a-z,  A-Z, the numbers 0-9, underscores, and hyphens");
        }
        strategy.takeScreenshot(screenshotName, callback);
    }

    private Screengrab() {
    }
}

