/*
 * Decompiled with CFR 0.152.
 */
package tools.fastlane.screengrab.locale;

import android.os.Build;
import android.os.LocaleList;
import androidx.annotation.RequiresApi;
import java.util.Locale;

class LocaleListCompat {
    private Locale mLocale = null;
    private LocaleList mLocaleList = null;

    LocaleListCompat(Locale locale) {
        this.mLocale = locale;
        if (Build.VERSION.SDK_INT >= 24) {
            this.mLocaleList = new LocaleList(new Locale[]{locale});
        }
    }

    @RequiresApi(value=24)
    LocaleListCompat(LocaleList localeList) {
        this.mLocaleList = localeList;
    }

    Locale getLocale() {
        return this.mLocale;
    }

    @RequiresApi(value=24)
    LocaleList getLocaleList() {
        return this.mLocaleList;
    }

    Locale getPreferredLocale() {
        if (this.mLocaleList != null && Build.VERSION.SDK_INT >= 24) {
            return this.mLocaleList.get(0);
        }
        return this.mLocale;
    }
}

