/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.TreeCodec;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.filter.FilteringParserDelegate;
import tools.jackson.core.filter.JsonPointerBasedFilter;
import tools.jackson.core.filter.TokenFilter;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.MappingIterator;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.ContextAttributes;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DeserializationContexts;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.TreeTraversingParser;
import tools.jackson.databind.type.SimpleType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;

public class ObjectReader
implements Versioned,
TreeCodec {
    protected static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DeserializationContexts _contexts;
    protected final TokenStreamFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final ValueDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final ConcurrentHashMap<JavaType, ValueDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config) {
        this(mapper, config, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._contexts = mapper._deserializationContexts;
        this._rootDeserializers = mapper._rootDeserializers;
        this._parserFactory = mapper._streamFactory;
        this._valueType = valueType;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(valueType);
        this._filter = null;
    }

    protected ObjectReader(ObjectReader base, DeserializationConfig config, JavaType valueType, ValueDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = valueType;
        this._rootDeserializer = rootDeser;
        this._valueToUpdate = valueToUpdate;
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._filter = base._filter;
    }

    protected ObjectReader(ObjectReader base, DeserializationConfig config) {
        this._config = config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = base._valueType;
        this._rootDeserializer = base._rootDeserializer;
        this._valueToUpdate = base._valueToUpdate;
        this._schema = base._schema;
        this._injectableValues = base._injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._filter = base._filter;
    }

    protected ObjectReader(ObjectReader base, TokenFilter filter) {
        this._config = base._config;
        this._contexts = base._contexts;
        this._rootDeserializers = base._rootDeserializers;
        this._parserFactory = base._parserFactory;
        this._valueType = base._valueType;
        this._rootDeserializer = base._rootDeserializer;
        this._valueToUpdate = base._valueToUpdate;
        this._schema = base._schema;
        this._injectableValues = base._injectableValues;
        this._unwrapRoot = base._unwrapRoot;
        this._filter = filter;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectReader _new(ObjectReader base, DeserializationConfig config) {
        return new ObjectReader(base, config);
    }

    protected ObjectReader _new(ObjectReader base, DeserializationConfig config, JavaType valueType, ValueDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        return new ObjectReader(base, config, valueType, rootDeser, valueToUpdate, schema, injectableValues);
    }

    protected <T> MappingIterator<T> _newIterator(JsonParser p, DeserializationContext ctxt, ValueDeserializer<?> deser, boolean parserManaged) {
        return new MappingIterator(this._valueType, p, ctxt, deser, parserManaged, this._valueToUpdate);
    }

    protected JsonToken _initForReading(DeserializationContextExt ctxt, JsonParser p) {
        ctxt.assignParser(p);
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            ctxt.reportInputMismatch(this._valueType, "No content to map due to end-of-input", new Object[0]);
        }
        return t;
    }

    protected void _initForMultiRead(DeserializationContextExt ctxt, JsonParser p) {
        ctxt.assignParser(p);
    }

    public ObjectReader with(DeserializationFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader with(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.with(first, other));
    }

    public ObjectReader withFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(DeserializationFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader without(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.without(first, other));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(DatatypeFeature feature) {
        return this._with((DeserializationConfig)this._config.with(feature));
    }

    public ObjectReader withFeatures(DatatypeFeature ... features) {
        return this._with((DeserializationConfig)this._config.withFeatures(features));
    }

    public ObjectReader without(DatatypeFeature feature) {
        return this._with((DeserializationConfig)this._config.without(feature));
    }

    public ObjectReader withoutFeatures(DatatypeFeature ... features) {
        return this._with((DeserializationConfig)this._config.withoutFeatures(features));
    }

    public ObjectReader with(StreamReadFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(StreamReadFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(StreamReadFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(StreamReadFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(FormatFeature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(FormatFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(FormatFeature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(FormatFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader at(String pointerExpr) {
        this._assertNotNull("pointerExpr", pointerExpr);
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(pointerExpr));
    }

    public ObjectReader at(JsonPointer pointer) {
        this._assertNotNull("pointer", pointer);
        return new ObjectReader(this, (TokenFilter)new JsonPointerBasedFilter(pointer));
    }

    public ObjectReader with(DeserializationConfig config) {
        return this._with(config);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues);
    }

    public ObjectReader with(JsonNodeFactory f) {
        return this._with((DeserializationConfig)this._config.with(f));
    }

    public ObjectReader withRootName(String rootName) {
        return this._with((DeserializationConfig)this._config.withRootName(rootName));
    }

    public ObjectReader withRootName(PropertyName rootName) {
        return this._with(this._config.withRootName(rootName));
    }

    public ObjectReader withoutRootName() {
        return this._with(this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema schema) {
        if (this._schema == schema) {
            return this;
        }
        this._verifySchemaType(schema);
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, schema, this._injectableValues);
    }

    public ObjectReader forType(JavaType valueType) {
        if (valueType != null && valueType.equals(this._valueType)) {
            return this;
        }
        ValueDeserializer<Object> rootDeser = this._prefetchRootDeserializer(valueType);
        return this._new(this, this._config, valueType, rootDeser, this._valueToUpdate, this._schema, this._injectableValues);
    }

    public ObjectReader forType(Class<?> valueType) {
        return this.forType(this._config.constructType(valueType));
    }

    public ObjectReader forType(TypeReference<?> valueTypeRef) {
        return this.forType(this._config.getTypeFactory().constructType(valueTypeRef.getType()));
    }

    public ObjectReader withValueToUpdate(Object value) {
        if (value == this._valueToUpdate) {
            return this;
        }
        if (value == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues);
        }
        JavaType t = this._valueType == null ? this._config.constructType(value.getClass()) : this._valueType;
        return this._new(this, this._config, t, this._rootDeserializer, value, this._schema, this._injectableValues);
    }

    public ObjectReader withView(Class<?> activeView) {
        return this._with((DeserializationConfig)this._config.withView((Class)activeView));
    }

    public ObjectReader with(Locale l) {
        return this._with((DeserializationConfig)this._config.with(l));
    }

    public ObjectReader with(TimeZone tz) {
        return this._with((DeserializationConfig)this._config.with(tz));
    }

    public ObjectReader withHandler(DeserializationProblemHandler h) {
        return this._with(this._config.withHandler(h));
    }

    public ObjectReader with(Base64Variant defaultBase64) {
        return this._with((DeserializationConfig)this._config.with(defaultBase64));
    }

    public ObjectReader with(ContextAttributes attrs) {
        return this._with(this._config.with(attrs));
    }

    public ObjectReader withAttributes(Map<?, ?> attrs) {
        return this._with((DeserializationConfig)this._config.withAttributes(attrs));
    }

    public ObjectReader withAttribute(Object key, Object value) {
        return this._with((DeserializationConfig)this._config.withAttribute(key, value));
    }

    public ObjectReader withoutAttribute(Object key) {
        return this._with((DeserializationConfig)this._config.withoutAttribute(key));
    }

    protected final ObjectReader _with(DeserializationConfig newConfig) {
        if (newConfig == this._config) {
            return this;
        }
        return this._new(this, newConfig);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(DatatypeFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return this._config.isEnabled(f);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    public TokenStreamFactory parserFactory() {
        return this._parserFactory;
    }

    public TypeFactory typeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    @Deprecated
    public TypeFactory getTypeFactory() {
        return this.typeFactory();
    }

    public JsonParser createParser(File src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(Path src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(URL src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(InputStream src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(Reader src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(byte[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(DataInput content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createNonBlockingByteArrayParser() throws JacksonException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._parserFactory.createNonBlockingByteArrayParser((ObjectReadContext)ctxt));
    }

    public ObjectNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public JsonNode booleanNode(boolean b) {
        return this._config.getNodeFactory().booleanNode(b);
    }

    public JsonNode stringNode(String text) {
        return this._config.getNodeFactory().stringNode(text);
    }

    public JsonNode missingNode() {
        return this._config.getNodeFactory().missingNode();
    }

    public JsonNode nullNode() {
        return this._config.getNodeFactory().nullNode();
    }

    public JsonParser treeAsTokens(TreeNode n) {
        this._assertNotNull("n", n);
        return this.treeAsTokens((JsonNode)n, this._deserializationContext());
    }

    protected JsonParser treeAsTokens(JsonNode n, DeserializationContext ctxt) {
        this._assertNotNull("n", n);
        return new TreeTraversingParser(n, ctxt);
    }

    public JsonNode readTree(JsonParser p) throws JacksonException {
        this._assertNotNull("p", p);
        return this._bindAsTreeOrNull(this._deserializationContext(p), p);
    }

    public void writeTree(JsonGenerator g, TreeNode tree) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(JsonParser p) throws JacksonException {
        this._assertNotNull("p", p);
        DeserializationContextExt ctxt = this._deserializationContext(p);
        return (T)this._bind(ctxt, p, this._valueToUpdate);
    }

    public <T> Iterator<T> readValues(JsonParser p, Class<T> valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return this.forType(valueType).readValues(p);
    }

    public <T> Iterator<T> readValues(JsonParser p, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("p", p);
        return this.forType(valueTypeRef).readValues(p);
    }

    public <T> Iterator<T> readValues(JsonParser p, ResolvedType valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return this.readValues(p, (JavaType)valueType);
    }

    public <T> Iterator<T> readValues(JsonParser p, JavaType valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return this.forType(valueType).readValues(p);
    }

    public <T> T readValue(InputStream in) throws JacksonException {
        this._assertNotNull("in", in);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, in), false));
    }

    public <T> T readValue(Reader r) throws JacksonException {
        this._assertNotNull("r", r);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, r), false));
    }

    public <T> T readValue(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), false));
    }

    public <T> T readValue(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), false));
    }

    public <T> T readValue(byte[] buffer, int offset, int length) throws JacksonException {
        this._assertNotNull("buffer", buffer);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, buffer, offset, length), false));
    }

    public <T> T readValue(File f) throws JacksonException {
        this._assertNotNull("f", f);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, f), false));
    }

    public <T> T readValue(Path path) throws JacksonException {
        this._assertNotNull("path", path);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, path), false));
    }

    public <T> T readValue(URL url) throws JacksonException {
        this._assertNotNull("src", url);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, url), false));
    }

    public <T> T readValue(JsonNode node) throws JacksonException {
        this._assertNotNull("node", node);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this.treeAsTokens(node, ctxt), false));
    }

    public <T> T readValue(DataInput input) throws JacksonException {
        this._assertNotNull("input", input);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._bindAndClose(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, input), false));
    }

    public JsonNode readTree(InputStream src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public JsonNode readTree(Reader src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), false));
    }

    public JsonNode readTree(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), false));
    }

    public JsonNode readTree(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), false));
    }

    public JsonNode readTree(byte[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content, offset, len), false));
    }

    public JsonNode readTree(DataInput content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndCloseAsTree(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser p) throws JacksonException {
        this._assertNotNull("p", p);
        DeserializationContextExt ctxt = this._deserializationContext(p);
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), false);
    }

    public <T> MappingIterator<T> readValues(InputStream src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(Reader src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        JsonParser p = this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true);
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        JsonParser p = this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content), true);
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(byte[] content, int offset, int length) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, content, offset, length), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        return this.readValues(content, 0, content.length);
    }

    public <T> MappingIterator<T> readValues(File src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(Path src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(URL src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> MappingIterator<T> readValues(DataInput src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._bindAndReadValues(ctxt, this._considerFilter(this._parserFactory.createParser((ObjectReadContext)ctxt, src), true));
    }

    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JacksonException {
        this._assertNotNull("n", n);
        return this.forType(valueType).readValue(this.treeAsTokens(n));
    }

    public <T> T treeToValue(TreeNode n, JavaType valueType) throws JacksonException {
        this._assertNotNull("n", n);
        return this.forType(valueType).readValue(this.treeAsTokens(n));
    }

    protected Object _bind(DeserializationContextExt ctxt, JsonParser p, Object valueToUpdate) throws JacksonException {
        JsonToken t = this._initForReading(ctxt, p);
        Object result = t == JsonToken.VALUE_NULL ? (valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : valueToUpdate) : (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT ? valueToUpdate : (t == JsonToken.NOT_AVAILABLE ? valueToUpdate : ctxt.readRootValue(p, this._valueType, this._findRootDeserializer(ctxt), this._valueToUpdate)));
        p.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, this._valueType);
        }
        return result;
    }

    protected Object _bindAndClose(DeserializationContextExt ctxt, JsonParser p0) throws JacksonException {
        try (JsonParser p = p0;){
            JsonToken t = this._initForReading(ctxt, p);
            Object result = t == JsonToken.VALUE_NULL ? (this._valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : this._valueToUpdate) : (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT ? this._valueToUpdate : (t == JsonToken.NOT_AVAILABLE ? this._valueToUpdate : ctxt.readRootValue(p, this._valueType, this._findRootDeserializer(ctxt), this._valueToUpdate)));
            if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, this._valueType);
            }
            Object object = result;
            return object;
        }
    }

    protected final JsonNode _bindAndCloseAsTree(DeserializationContextExt ctxt, JsonParser p0) throws JacksonException {
        try (JsonParser p = ctxt.assignAndReturnParser(p0);){
            JsonNode jsonNode = this._bindAsTree(ctxt, p);
            return jsonNode;
        }
    }

    protected final JsonNode _bindAsTree(DeserializationContextExt ctxt, JsonParser p) throws JacksonException {
        if (this._valueToUpdate != null) {
            return (JsonNode)this._bind(ctxt, p, this._valueToUpdate);
        }
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return this._config.getNodeFactory().missingNode();
        }
        JsonNode resultNode = t == JsonToken.VALUE_NULL ? ctxt.getNodeFactory().nullNode() : (JsonNode)ctxt.readRootValue(p, JSON_NODE_TYPE, this._findTreeDeserializer(ctxt), null);
        p.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, JSON_NODE_TYPE);
        }
        return resultNode;
    }

    protected final JsonNode _bindAsTreeOrNull(DeserializationContextExt ctxt, JsonParser p) throws JacksonException {
        if (this._valueToUpdate != null) {
            return (JsonNode)this._bind(ctxt, p, this._valueToUpdate);
        }
        ctxt.assignParser(p);
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return null;
        }
        JsonNode resultNode = t == JsonToken.VALUE_NULL ? ctxt.getNodeFactory().nullNode() : (JsonNode)ctxt.readRootValue(p, JSON_NODE_TYPE, this._findTreeDeserializer(ctxt), null);
        p.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, JSON_NODE_TYPE);
        }
        return resultNode;
    }

    protected <T> MappingIterator<T> _bindAndReadValues(DeserializationContextExt ctxt, JsonParser p) throws JacksonException {
        this._initForMultiRead(ctxt, p);
        p.nextToken();
        return this._newIterator(p, ctxt, this._findRootDeserializer(ctxt), true);
    }

    protected JsonParser _considerFilter(JsonParser p, boolean multiValue) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(p) ? p : new FilteringParserDelegate(p, this._filter, TokenFilter.Inclusion.ONLY_INCLUDE_ALL, multiValue);
    }

    protected final void _verifyNoTrailingTokens(JsonParser p, DeserializationContext ctxt, JavaType bindType) throws JacksonException {
        JsonToken t = p.nextToken();
        if (t != null) {
            Class<?> bt = ClassUtil.rawClass(bindType);
            if (bt == null && this._valueToUpdate != null) {
                bt = this._valueToUpdate.getClass();
            }
            ctxt.reportTrailingTokens(bt, p, t);
        }
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._parserFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DeserializationContextExt _deserializationContext() {
        return this._contexts.createContext(this._config, this._schema, this._injectableValues);
    }

    protected DeserializationContextExt _deserializationContext(JsonParser p) {
        return this._contexts.createContext(this._config, this._schema, this._injectableValues).assignParser(p);
    }

    protected InputStream _inputStream(URL src) throws JacksonException {
        try {
            return src.openStream();
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }

    protected InputStream _inputStream(File f) throws JacksonException {
        try {
            return new FileInputStream(f);
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }

    protected InputStream _inputStream(Path path) throws JacksonException {
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }

    protected ValueDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt) throws DatabindException {
        ValueDeserializer<Object> deser;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType t = this._valueType;
        if (t == null) {
            ctxt.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((deser = this._rootDeserializers.get(t)) != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(t);
        if (deser == null) {
            ctxt.reportBadDefinition(t, "Cannot find a deserializer for type " + String.valueOf(t));
        }
        this._rootDeserializers.put(t, deser);
        return deser;
    }

    protected ValueDeserializer<Object> _findTreeDeserializer(DeserializationContext ctxt) throws DatabindException {
        ValueDeserializer<Object> deser = this._rootDeserializers.get(JSON_NODE_TYPE);
        if (deser == null) {
            deser = ctxt.findRootValueDeserializer(JSON_NODE_TYPE);
            if (deser == null) {
                ctxt.reportBadDefinition(JSON_NODE_TYPE, "Cannot find a deserializer for type " + String.valueOf(JSON_NODE_TYPE));
            }
            this._rootDeserializers.put(JSON_NODE_TYPE, deser);
        }
        return deser;
    }

    protected ValueDeserializer<Object> _prefetchRootDeserializer(JavaType valueType) {
        if (valueType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        ValueDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser == null) {
            try {
                DeserializationContextExt ctxt = this._deserializationContext();
                deser = ctxt.findRootValueDeserializer(valueType);
                if (deser != null) {
                    this._rootDeserializers.put(valueType, deser);
                }
                return deser;
            }
            catch (JacksonException jacksonException) {
                // empty catch block
            }
        }
        return deser;
    }
}

