/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.EnumNamingStrategy;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.CompactStringObjectMap;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    protected EnumResolver(Class<Enum<?>> enumClass, Enum<?>[] enums, HashMap<String, Enum<?>> enumsById, Enum<?> defaultValue, boolean isIgnoreCase, boolean isFromIntValue) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = enumsById;
        this._defaultValue = defaultValue;
        this._isIgnoreCase = isIgnoreCase;
        this._isFromIntValue = isFromIntValue;
    }

    public static EnumResolver constructFor(DeserializationConfig config, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        boolean isIgnoreCase = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls);
        Enum<?> defaultEnum = EnumResolver._enumDefault(config, annotatedClass, enumConstants);
        String[] names = ai.findEnumValues(config, annotatedClass, enumConstants, new String[enumConstants.length]);
        String[][] allAliases = new String[names.length][];
        ai.findEnumAliases(config, annotatedClass, enumConstants, allAliases);
        HashMap map = new HashMap();
        int len = enumConstants.length;
        for (int i = 0; i < len; ++i) {
            Enum<?> enumValue = enumConstants[i];
            String name = names[i];
            if (name == null) {
                name = enumValue.name();
            }
            map.put(name, enumValue);
            String[] aliases = allAliases[i];
            if (aliases == null) continue;
            for (String alias : aliases) {
                map.putIfAbsent(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, defaultEnum, isIgnoreCase, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig config, AnnotatedClass annotatedClass) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        boolean isIgnoreCase = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls);
        Enum<?> defaultEnum = EnumResolver._enumDefault(config, annotatedClass, enumConstants);
        String[] names = new String[enumConstants.length];
        String[][] allAliases = new String[enumConstants.length][];
        if (ai != null) {
            ai.findEnumValues(config, annotatedClass, enumConstants, names);
            ai.findEnumAliases(config, annotatedClass, enumConstants, allAliases);
        }
        HashMap map = new HashMap();
        int i = enumConstants.length;
        while (--i >= 0) {
            Enum<?> enumValue = enumConstants[i];
            String name = names[i];
            if (name == null) {
                name = enumValue.toString();
            }
            map.put(name, enumValue);
            String[] aliases = allAliases[i];
            if (aliases == null) continue;
            for (String alias : aliases) {
                map.putIfAbsent(alias, enumValue);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, defaultEnum, isIgnoreCase, false);
    }

    public static EnumResolver constructUsingIndex(DeserializationConfig config, AnnotatedClass annotatedClass) {
        boolean isIgnoreCase = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls);
        Enum<?> defaultEnum = EnumResolver._enumDefault(config, annotatedClass, enumConstants);
        HashMap map = new HashMap();
        int i = enumConstants.length;
        while (--i >= 0) {
            Enum<?> enumValue = enumConstants[i];
            map.put(String.valueOf(i), enumValue);
        }
        return new EnumResolver(enumCls, enumConstants, map, defaultEnum, isIgnoreCase, false);
    }

    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig config, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy) {
        boolean isIgnoreCase = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls);
        Enum<?> defaultEnum = EnumResolver._enumDefault(config, annotatedClass, enumConstants);
        String[] names = new String[enumConstants.length];
        String[][] allAliases = new String[enumConstants.length][];
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        if (ai != null) {
            ai.findEnumValues(config, annotatedClass, enumConstants, names);
            ai.findEnumAliases(config, annotatedClass, enumConstants, allAliases);
        }
        HashMap map = new HashMap();
        int i = enumConstants.length;
        while (--i >= 0) {
            Enum<?> anEnum = enumConstants[i];
            String name = names[i];
            if (name == null) {
                name = enumNamingStrategy.convertEnumToExternalName(config, annotatedClass, anEnum.name());
            }
            map.put(name, anEnum);
            String[] aliases = allAliases[i];
            if (aliases == null) continue;
            for (String alias : aliases) {
                map.putIfAbsent(alias, anEnum);
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, defaultEnum, isIgnoreCase, false);
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig config, AnnotatedClass annotatedClass, AnnotatedMember accessor) {
        boolean isIgnoreCase = config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> enumCls0 = annotatedClass.getRawType();
        Class<Enum<?>> enumCls = EnumResolver._enumClass(enumCls0);
        Enum<?>[] enumConstants = EnumResolver._enumConstants(enumCls);
        Enum<?> defaultEnum = EnumResolver._enumDefault(config, annotatedClass, enumConstants);
        HashMap map = new HashMap();
        int i = enumConstants.length;
        while (--i >= 0) {
            Enum<?> en = enumConstants[i];
            try {
                Object o = accessor.getValue(en);
                if (o == null) continue;
                map.put(o.toString(), en);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + String.valueOf(en) + ": " + e.getMessage());
            }
        }
        return new EnumResolver(enumCls, enumConstants, map, defaultEnum, isIgnoreCase, EnumResolver._isIntType(accessor.getRawType()));
    }

    protected static Class<Enum<?>> _enumClass(Class<?> cls) {
        return cls;
    }

    protected static Enum<?>[] _enumConstants(Class<Enum<?>> enumCls) {
        Enum<?>[] ecs = enumCls.getEnumConstants();
        if (ecs == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        return ecs;
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Enum<?> _enumDefault(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enums) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        return intr != null ? intr.findDefaultEnumValue(config, annotatedClass, enums) : null;
    }

    protected static boolean _isIntType(Class<?> erasedType) {
        if (erasedType.isPrimitive()) {
            erasedType = ClassUtil.wrapperType(erasedType);
        }
        return erasedType == Long.class || erasedType == Integer.class || erasedType == Short.class || erasedType == Byte.class;
    }

    public Enum<?> findEnum(String key) {
        Enum<?> en = this._enumsById.get(key);
        if (en == null && this._isIgnoreCase) {
            return this._findEnumIgnoreCase(key);
        }
        return en;
    }

    private final Enum<?> _findEnumIgnoreCase(String key) {
        return this._enumsById.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).map(e -> (Enum)e.getValue()).findFirst().orElseGet(null);
    }

    public Enum<?> getEnum(int index) {
        if (index < 0 || index >= this._enums.length) {
            return null;
        }
        return this._enums[index];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList enums = new ArrayList(this._enums.length);
        for (Enum<?> e : this._enums) {
            enums.add(e);
        }
        return enums;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

