/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedCreatorCollector;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedFieldCollector;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedMethodCollector;
import tools.jackson.databind.introspect.AnnotatedMethodMap;
import tools.jackson.databind.introspect.AnnotationCollector;
import tools.jackson.databind.introspect.MixInResolver;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.databind.type.TypeBindings;
import tools.jackson.databind.util.Annotations;
import tools.jackson.databind.util.ClassUtil;

public final class AnnotatedClass
extends Annotated
implements TypeResolutionContext {
    private static final Creators NO_CREATORS = new Creators(null, Collections.emptyList(), Collections.emptyList());
    protected final MapperConfig<?> _config;
    protected final JavaType _type;
    protected final Class<?> _class;
    protected final TypeBindings _bindings;
    protected final List<JavaType> _superTypes;
    protected final MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected final boolean _collectAnnotations;
    protected final Annotations _classAnnotations;
    protected Creators _creators;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;
    protected transient Boolean _nonStaticInnerClass;

    AnnotatedClass(MapperConfig<?> config, JavaType type, Class<?> rawType, List<JavaType> superTypes, Class<?> primaryMixIn, Annotations classAnnotations, TypeBindings bindings, MixInResolver mir, boolean collectAnnotations) {
        this._config = config;
        this._type = type;
        this._class = rawType;
        this._superTypes = superTypes;
        this._primaryMixIn = primaryMixIn;
        this._classAnnotations = classAnnotations;
        this._bindings = bindings;
        this._mixInResolver = mir;
        this._collectAnnotations = collectAnnotations;
    }

    AnnotatedClass(Class<?> rawType) {
        this._config = null;
        this._type = null;
        this._class = rawType;
        this._superTypes = Collections.emptyList();
        this._primaryMixIn = null;
        this._classAnnotations = AnnotationCollector.emptyAnnotations();
        this._bindings = TypeBindings.emptyBindings();
        this._mixInResolver = null;
        this._collectAnnotations = false;
        this._creators = NO_CREATORS;
        this._fields = Collections.emptyList();
        this._memberMethods = new AnnotatedMethodMap();
    }

    @Override
    public JavaType resolveType(Type type) {
        return this._config.getTypeFactory().resolveMemberType(type, this._bindings);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._classAnnotations.get(acls);
    }

    @Override
    public boolean hasAnnotation(Class<?> acls) {
        return this._classAnnotations.has(acls);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
        return this._classAnnotations.hasOneOf(annoClasses);
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        return this._creators().defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        return this._creators().constructors;
    }

    public List<AnnotatedMethod> getFactoryMethods() {
        return this._creators().creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        return this._methods();
    }

    public int getMemberMethodCount() {
        return this._methods().size();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._methods().find(name, paramTypes);
    }

    public int getFieldCount() {
        return this._fields().size();
    }

    public Iterable<AnnotatedField> fields() {
        return this._fields();
    }

    public boolean isNonStaticInnerClass() {
        Boolean B = this._nonStaticInnerClass;
        if (B == null) {
            this._nonStaticInnerClass = B = Boolean.valueOf(ClassUtil.isNonStaticInnerClass(this._class));
        }
        return B;
    }

    private final List<AnnotatedField> _fields() {
        List<AnnotatedField> f = this._fields;
        if (f == null) {
            f = this._type == null ? Collections.emptyList() : AnnotatedFieldCollector.collectFields(this._config, this, this._mixInResolver, this._type, this._primaryMixIn, this._collectAnnotations);
        }
        return f;
    }

    private final AnnotatedMethodMap _methods() {
        AnnotatedMethodMap m = this._memberMethods;
        if (m == null) {
            m = this._type == null ? new AnnotatedMethodMap() : AnnotatedMethodCollector.collectMethods(this._config, this, this._mixInResolver, this._type, this._superTypes, this._primaryMixIn, this._collectAnnotations);
            this._memberMethods = m;
        }
        return m;
    }

    private final Creators _creators() {
        Creators c = this._creators;
        if (c == null) {
            this._creators = c = AnnotatedCreatorCollector.collectCreators(this._config, this, this._type, this._primaryMixIn, this._collectAnnotations);
        }
        return c;
    }

    @Override
    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public int hashCode() {
        return this._class.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!ClassUtil.hasClass(o, this.getClass())) {
            return false;
        }
        return ((AnnotatedClass)o)._class == this._class;
    }

    public static final class Creators {
        public final AnnotatedConstructor defaultConstructor;
        public final List<AnnotatedConstructor> constructors;
        public final List<AnnotatedMethod> creatorMethods;

        public Creators(AnnotatedConstructor defCtor, List<AnnotatedConstructor> ctors, List<AnnotatedMethod> ctorMethods) {
            this.defaultConstructor = defCtor;
            this.constructors = ctors;
            this.creatorMethods = ctorMethods;
        }
    }
}

