/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.NumberInput;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.xml.PackageVersion;
import tools.jackson.dataformat.xml.XmlNameProcessor;
import tools.jackson.dataformat.xml.XmlReadFeature;
import tools.jackson.dataformat.xml.deser.ElementWrappable;
import tools.jackson.dataformat.xml.deser.XmlReadContext;
import tools.jackson.dataformat.xml.deser.XmlTokenStream;
import tools.jackson.dataformat.xml.util.CaseInsensitiveNameSet;
import tools.jackson.dataformat.xml.util.StaxUtil;

public class FromXmlParser
extends ParserMinimalBase
implements ElementWrappable {
    public static final String DEFAULT_UNNAMED_TEXT_PROPERTY = "";
    protected static final JacksonFeatureSet<StreamReadCapability> XML_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.DUPLICATE_PROPERTIES).with((JacksonFeature)StreamReadCapability.SCALARS_AS_OBJECTS).with((JacksonFeature)StreamReadCapability.UNTYPED_SCALARS);
    protected final String _cfgNameForTextElement;
    protected final int _formatFeatures;
    protected XmlReadContext _streamReadContext;
    protected final XmlTokenStream _xmlTokens;
    protected boolean _mayBeLeaf;
    protected JsonToken _nextToken;
    protected String _currText;
    protected boolean _nextIsLeadingMixed;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected BigInteger _numberBigInt;

    public FromXmlParser(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, int xmlFeatures, XMLStreamReader xmlReader, XmlNameProcessor nameProcessor, String nameForTextElement) {
        this(readCtxt, ioCtxt, parserFeatures, xmlFeatures, xmlReader, new XmlTokenStream(xmlReader, ioCtxt.contentReference(), xmlFeatures, nameProcessor), nameProcessor, nameForTextElement);
    }

    public FromXmlParser(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, int xmlFeatures, XMLStreamReader xmlReader, XmlTokenStream tokenStream, XmlNameProcessor nameProcessor, String nameForTextElement) {
        super(readCtxt, ioCtxt, parserFeatures);
        int firstToken;
        this._formatFeatures = xmlFeatures;
        DupDetector dups = StreamReadFeature.STRICT_DUPLICATE_DETECTION.enabledIn(parserFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._streamReadContext = XmlReadContext.createRootContext(dups, -1, -1);
        this._xmlTokens = Objects.requireNonNull(tokenStream, "xmlTokenStream cannot be null");
        this._cfgNameForTextElement = nameForTextElement;
        try {
            firstToken = this._xmlTokens.initialize();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsReadException(e, (JsonParser)this);
            return;
        }
        if (this._xmlTokens.hasXsiNil()) {
            this._nextToken = JsonToken.VALUE_NULL;
            this._xmlTokens.markAsStreamEnd();
        } else {
            switch (firstToken) {
                case 1: {
                    this._nextToken = JsonToken.START_OBJECT;
                    break;
                }
                case 7: {
                    this._currText = this._xmlTokens.getText();
                    if (this._currText == null) {
                        this._nextToken = JsonToken.VALUE_NULL;
                        break;
                    }
                    this._nextToken = JsonToken.VALUE_STRING;
                    break;
                }
                default: {
                    this._reportError("Internal problem: invalid starting state (%s)", this._xmlTokens._currentStateDesc());
                }
            }
        }
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public XMLStreamReader2 streamReadInputSource() {
        return this._xmlTokens.getXmlReader();
    }

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return XML_READ_CAPABILITIES;
    }

    public XMLStreamReader getStaxReader() {
        return this._xmlTokens.getXmlReader();
    }

    @Override
    public void addVirtualWrapping(Set<String> namesToWrap0, boolean caseInsensitive) {
        String name;
        CaseInsensitiveNameSet namesToWrap;
        CaseInsensitiveNameSet caseInsensitiveNameSet = namesToWrap = caseInsensitive ? CaseInsensitiveNameSet.construct(namesToWrap0) : namesToWrap0;
        if (!this._streamReadContext.inRoot() && !this._streamReadContext.getParent().inRoot() && (name = this._xmlTokens.getLocalName()) != null && namesToWrap.contains(name)) {
            this._xmlTokens.repeatStartElement();
        }
        this._streamReadContext.setNamesToWrap(namesToWrap);
    }

    public final boolean isEnabled(XmlReadFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public String currentName() {
        String name;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            XmlReadContext parent = this._streamReadContext.getParent();
            name = parent.currentName();
        } else {
            name = this._streamReadContext.currentName();
        }
        if (name == null) {
            throw new IllegalStateException("Missing name, in state: " + String.valueOf(this._currToken));
        }
        return name;
    }

    protected void _closeInput() throws IOException {
        try {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
                this._xmlTokens.closeCompletely();
            } else {
                this._xmlTokens.close();
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsReadException(e, (JsonParser)this);
        }
    }

    protected void _releaseBuffers() {
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public TokenStreamLocation currentTokenLocation() {
        return this._xmlTokens.getTokenLocation();
    }

    public TokenStreamLocation currentLocation() {
        return this._xmlTokens.getCurrentLocation();
    }

    public boolean isExpectedStartArrayToken() {
        JsonToken t = this._currToken;
        if (t == JsonToken.START_OBJECT) {
            this._updateToken(JsonToken.START_ARRAY);
            this._streamReadContext.convertToArray();
            this._nextToken = this._nextToken == JsonToken.END_OBJECT ? JsonToken.END_ARRAY : null;
            this._xmlTokens.skipAttributes();
            return true;
        }
        return t == JsonToken.START_ARRAY;
    }

    public boolean isExpectedNumberIntToken() {
        String text;
        int len;
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING && (len = this._isIntNumber(text = this._currText.trim())) > 0) {
            boolean stillLong;
            if (len <= 9) {
                this._numberInt = NumberInput.parseInt((String)text);
                this._numTypesValid = 1;
                this._updateToken(JsonToken.VALUE_NUMBER_INT);
                return true;
            }
            if (len <= 18) {
                int asInt;
                long l2;
                long l = NumberInput.parseLong((String)text);
                if (len == 10 && l == (l2 = (long)(asInt = (int)l))) {
                    this._numberInt = asInt;
                    this._numTypesValid = 1;
                    this._updateToken(JsonToken.VALUE_NUMBER_INT);
                    return true;
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                this._updateToken(JsonToken.VALUE_NUMBER_INT);
                return true;
            }
            if (len == 19 && (stillLong = text.charAt(0) == '-' ? NumberInput.inLongRange((String)text.substring(1), (boolean)true) : NumberInput.inLongRange((String)text, (boolean)false))) {
                this._numberLong = NumberInput.parseLong((String)text);
                this._numTypesValid = 2;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            this.streamReadConstraints().validateIntegerLength(text.length());
            this._numberBigInt = NumberInput.parseBigInteger((String)text, (boolean)this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            this._numTypesValid = 4;
            this._updateToken(JsonToken.VALUE_NUMBER_INT);
            return true;
        }
        return t == JsonToken.VALUE_NUMBER_INT;
    }

    public JsonToken nextToken() throws JacksonException {
        this._binaryValue = null;
        this._numTypesValid = 0;
        if (this._nextToken != null) {
            JsonToken t = this._updateToken(this._nextToken);
            this._nextToken = null;
            switch (t) {
                case START_OBJECT: {
                    this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                    break;
                }
                case START_ARRAY: {
                    this._streamReadContext = this._streamReadContext.createChildArrayContext(-1, -1);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    this._streamReadContext = this._streamReadContext.getParent();
                    break;
                }
                case PROPERTY_NAME: {
                    if (this._nextIsLeadingMixed) {
                        this._nextIsLeadingMixed = false;
                        this._streamReadContext.setCurrentName(this._cfgNameForTextElement);
                        this._nextToken = JsonToken.VALUE_STRING;
                        break;
                    }
                    this._streamReadContext.setCurrentName(this._xmlTokens.getLocalName());
                    break;
                }
                default: {
                    this._streamReadContext.valueStarted();
                }
            }
            return t;
        }
        int token = this._nextToken();
        while (token == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.PROPERTY_NAME;
                this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                return this._updateToken(JsonToken.START_OBJECT);
            }
            if (this._streamReadContext.inArray()) {
                token = this._nextToken();
                this._mayBeLeaf = true;
                continue;
            }
            String name = this._xmlTokens.getLocalName();
            this._streamReadContext.setCurrentName(name);
            if (this._streamReadContext.shouldWrap(name)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            return this._updateToken(JsonToken.PROPERTY_NAME);
        }
        block14: while (true) {
            switch (token) {
                case 2: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        if (this._streamReadContext.inArray()) {
                            this._nextToken = JsonToken.END_OBJECT;
                            this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                            return this._updateToken(JsonToken.START_OBJECT);
                        }
                        if (this._currToken != JsonToken.VALUE_NULL) {
                            this._streamReadContext.valueStarted();
                            return this._updateToken(JsonToken.VALUE_NULL);
                        }
                    }
                    this._updateToken(this._streamReadContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT);
                    this._streamReadContext = this._streamReadContext.getParent();
                    return this._currToken;
                }
                case 3: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        this._nextToken = JsonToken.PROPERTY_NAME;
                        this._currText = this._xmlTokens.getText();
                        this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                        return this._updateToken(JsonToken.START_OBJECT);
                    }
                    this._streamReadContext.setCurrentName(this._xmlTokens.getLocalName());
                    return this._updateToken(JsonToken.PROPERTY_NAME);
                }
                case 4: {
                    this._currText = this._xmlTokens.getText();
                    this._streamReadContext.valueStarted();
                    return this._updateToken(JsonToken.VALUE_STRING);
                }
                case 5: {
                    this._currText = this._xmlTokens.getText();
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        token = this._nextToken();
                        if (token == 2) {
                            if (this._streamReadContext.inArray() && XmlTokenStream._allWs(this._currText)) {
                                this._nextToken = JsonToken.END_OBJECT;
                                this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                                return this._updateToken(JsonToken.START_OBJECT);
                            }
                            return this._updateToken(JsonToken.VALUE_STRING);
                        }
                        if (token != 1) {
                            throw this._constructReadException(String.format("Internal error: Expected END_ELEMENT (%d) or START_ELEMENT (%d), got event of type %d", 2, 1, token));
                        }
                        this._xmlTokens.pushbackCurrentToken();
                        this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                    }
                    if (this._streamReadContext.inObject()) {
                        if (this._currToken == JsonToken.PROPERTY_NAME) {
                            this._nextIsLeadingMixed = true;
                            this._nextToken = JsonToken.PROPERTY_NAME;
                            return this._updateToken(JsonToken.START_OBJECT);
                        }
                        if (XmlTokenStream._allWs(this._currText)) {
                            token = this._nextToken();
                            continue block14;
                        }
                    } else if (this._streamReadContext.inArray() && XmlTokenStream._allWs(this._currText)) {
                        token = this._nextToken();
                        continue block14;
                    }
                    this._streamReadContext.setCurrentName(this._cfgNameForTextElement);
                    this._nextToken = JsonToken.VALUE_STRING;
                    return this._updateToken(JsonToken.PROPERTY_NAME);
                }
                case 8: {
                    return this._updateTokenToNull();
                }
            }
            break;
        }
        return (JsonToken)this._internalErrorUnknownToken(token);
    }

    public String nextStringValue() throws JacksonException {
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken t = this._updateToken(this._nextToken);
            this._nextToken = null;
            if (t == JsonToken.VALUE_STRING) {
                this._streamReadContext.valueStarted();
                return this._currText;
            }
            this._updateState(t);
            return null;
        }
        int token = this._nextToken();
        while (token == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.PROPERTY_NAME;
                this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                this._updateToken(JsonToken.START_OBJECT);
                return null;
            }
            if (this._streamReadContext.inArray()) {
                token = this._nextToken();
                this._mayBeLeaf = true;
                continue;
            }
            String name = this._xmlTokens.getLocalName();
            this._streamReadContext.setCurrentName(name);
            if (this._streamReadContext.shouldWrap(name)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._updateToken(JsonToken.PROPERTY_NAME);
            return null;
        }
        switch (token) {
            case 2: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._updateToken(JsonToken.VALUE_NULL);
                    this._streamReadContext.valueStarted();
                    this._currText = null;
                    return null;
                }
                this._updateToken(this._streamReadContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT);
                this._streamReadContext = this._streamReadContext.getParent();
                break;
            }
            case 3: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._nextToken = JsonToken.PROPERTY_NAME;
                    this._currText = this._xmlTokens.getText();
                    this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                    this._updateToken(JsonToken.START_OBJECT);
                    break;
                }
                this._streamReadContext.setCurrentName(this._xmlTokens.getLocalName());
                this._updateToken(JsonToken.PROPERTY_NAME);
                break;
            }
            case 4: {
                this._updateToken(JsonToken.VALUE_STRING);
                this._streamReadContext.valueStarted();
                this._currText = this._xmlTokens.getText();
                return this._currText;
            }
            case 5: {
                this._currText = this._xmlTokens.getText();
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._skipEndElement();
                    this._streamReadContext.valueStarted();
                    this._updateToken(JsonToken.VALUE_STRING);
                    return this._currText;
                }
                this._streamReadContext.setCurrentName(this._cfgNameForTextElement);
                this._nextToken = JsonToken.VALUE_STRING;
                this._updateToken(JsonToken.PROPERTY_NAME);
                break;
            }
            case 8: {
                this._updateTokenToNull();
            }
            default: {
                return (String)this._internalErrorUnknownToken(token);
            }
        }
        return null;
    }

    private void _updateState(JsonToken t) {
        switch (t) {
            case START_OBJECT: {
                this._streamReadContext = this._streamReadContext.createChildObjectContext(-1, -1);
                break;
            }
            case START_ARRAY: {
                this._streamReadContext = this._streamReadContext.createChildArrayContext(-1, -1);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._streamReadContext = this._streamReadContext.getParent();
                break;
            }
            case PROPERTY_NAME: {
                this._streamReadContext.setCurrentName(this._xmlTokens.getLocalName());
                break;
            }
            default: {
                this._internalErrorUnknownToken(t);
            }
        }
    }

    public String getString() throws JacksonException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case PROPERTY_NAME: {
                return this.currentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
        }
        return this._currToken.asString();
    }

    public char[] getStringCharacters() throws JacksonException {
        String text = this.getString();
        return text == null ? null : text.toCharArray();
    }

    public int getStringLength() throws JacksonException {
        String text = this.getString();
        return text == null ? 0 : text.length();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public boolean hasStringCharacters() {
        return false;
    }

    public int getString(Writer writer) throws JacksonException {
        String str = this.getString();
        if (str == null) {
            return 0;
        }
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return str.length();
    }

    public Object getEmbeddedObject() throws JacksonException {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws JacksonException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + String.valueOf(this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, cannot access as binary");
        }
        if (this._binaryValue == null) {
            try {
                this._binaryValue = this._decodeBase64(b64variant);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructReadException("Failed to decode VALUE_STRING as base64 (%s): %s", b64variant, iae.getMessage());
            }
        }
        return this._binaryValue;
    }

    protected byte[] _decodeBase64(Base64Variant b64variant) throws JacksonException {
        ByteArrayBuilder builder = this._getByteArrayBuilder();
        String str = this.getString();
        this._decodeBase64(str, builder, b64variant);
        return builder.toByteArray();
    }

    public boolean isNaN() {
        return false;
    }

    public JsonParser.NumberType getNumberType() {
        if (this._numTypesValid != 0) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        return null;
    }

    public Number getNumberValue() throws JacksonException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt;
        }
        this._throwInternal();
        return null;
    }

    public int getIntValue() throws JacksonException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this._convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public long getLongValue() throws JacksonException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this._convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public BigInteger getBigIntegerValue() throws JacksonException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this._convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public float getFloatValue() throws JacksonException {
        if ((this._numTypesValid & 0x20) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(32);
        }
        return this._convertNumberToFloat();
    }

    public double getDoubleValue() throws JacksonException {
        if ((this._numTypesValid & 8) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(8);
        }
        return this._convertNumberToDouble();
    }

    public BigDecimal getDecimalValue() throws JacksonException {
        if ((this._numTypesValid & 0x10) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(16);
        }
        return this._convertNumberToBigDecimal();
    }

    protected final void _checkNumericValue(int expType) throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            return;
        }
        throw this._constructReadException("Current token (%s) not numeric, cannot use numeric value accessors", this.currentToken());
    }

    protected final int _isIntNumber(String text) {
        int len = text.length();
        if (len > 0) {
            int start;
            for (int i = start = (c = text.charAt(0)) == '-' ? 1 : 0; i < len; ++i) {
                char ch = text.charAt(i);
                if (ch <= '9' && ch >= '0') continue;
                return -1;
            }
            return len - start;
        }
        return 0;
    }

    protected void _convertNumberToInt() throws JacksonException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (" + this.getString() + ") out of range of int");
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void _convertNumberToLong() throws JacksonException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this._reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void _convertNumberToBigInteger() throws JacksonException {
        if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected float _convertNumberToFloat() throws JacksonException {
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt.floatValue();
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        this._throwInternal();
        return 0.0f;
    }

    protected double _convertNumberToDouble() throws JacksonException {
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt.doubleValue();
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        this._throwInternal();
        return 0.0;
    }

    protected BigDecimal _convertNumberToBigDecimal() throws JacksonException {
        if ((this._numTypesValid & 4) != 0) {
            return new BigDecimal(this._numberBigInt);
        }
        if ((this._numTypesValid & 2) != 0) {
            return BigDecimal.valueOf(this._numberLong);
        }
        if ((this._numTypesValid & 1) != 0) {
            return BigDecimal.valueOf(this._numberInt);
        }
        this._throwInternal();
        return null;
    }

    protected void _handleEOF() throws StreamReadException {
        if (!this._streamReadContext.inRoot()) {
            String marker = this._streamReadContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", marker, this._streamReadContext.startLocation(this._ioContext.contentReference())), null);
        }
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    private <T> T _internalErrorUnknownToken(Object token) {
        throw new IllegalStateException("Internal error: unrecognized XmlTokenStream token: " + String.valueOf(token));
    }

    protected int _nextToken() throws JacksonException {
        try {
            return this._xmlTokens.next();
        }
        catch (XMLStreamException e) {
            return (Integer)StaxUtil.throwAsReadException(e, (JsonParser)this);
        }
        catch (IllegalStateException e) {
            throw new StreamReadException((JsonParser)this, e.getMessage(), (Throwable)e);
        }
    }

    protected void _skipEndElement() throws JacksonException {
        try {
            this._xmlTokens.skipEndElement();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwAsReadException(e, (JsonParser)this);
        }
        catch (Exception e) {
            throw new StreamReadException((JsonParser)this, e.getMessage(), (Throwable)e);
        }
    }
}

