/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.typed.Base64Variant;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.exc.StreamWriteException;

public class StaxUtil {
    public static <T> T throwAsReadException(XMLStreamException e, JsonParser p) throws JacksonException {
        Throwable t = StaxUtil._unwrap(e);
        throw new StreamReadException(p, StaxUtil._message(t, e), t);
    }

    public static <T> T throwAsWriteException(XMLStreamException e, JsonGenerator g) throws JacksonException {
        Throwable t = StaxUtil._unwrap(e);
        throw new StreamWriteException(g, StaxUtil._message(t, e), t);
    }

    private static Throwable _unwrap(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return t;
    }

    private static String _message(Throwable t1, Throwable t2) {
        String msg = t1.getMessage();
        if (msg == null) {
            msg = t2.getMessage();
        }
        return msg;
    }

    public static String sanitizeXmlTypeName(String name) {
        StringBuilder sb;
        if (name == null) {
            return null;
        }
        int changes = 0;
        if (name.endsWith("[]")) {
            do {
                name = name.substring(0, name.length() - 2);
                ++changes;
            } while (name.endsWith("[]"));
            sb = new StringBuilder(name);
            if (name.endsWith("s")) {
                sb.append("es");
            } else {
                sb.append('s');
            }
        } else {
            sb = new StringBuilder(name);
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c > '\u007f' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-') continue;
            ++changes;
            if (c == '$') {
                sb.setCharAt(i, '.');
                continue;
            }
            sb.setCharAt(i, '_');
        }
        if (changes == 0) {
            return name;
        }
        return sb.toString();
    }

    public static Base64Variant toStax2Base64Variant(tools.jackson.core.Base64Variant j64b) {
        return Base64Mapper.instance.map(j64b);
    }

    private static class Base64Mapper {
        public static final Base64Mapper instance = new Base64Mapper();
        private final Map<String, Base64Variant> j2stax2 = new HashMap<String, Base64Variant>();

        private Base64Mapper() {
            this.j2stax2.put(Base64Variants.MIME.getName(), org.codehaus.stax2.typed.Base64Variants.MIME);
            this.j2stax2.put(Base64Variants.MIME_NO_LINEFEEDS.getName(), org.codehaus.stax2.typed.Base64Variants.MIME_NO_LINEFEEDS);
            this.j2stax2.put(Base64Variants.MODIFIED_FOR_URL.getName(), org.codehaus.stax2.typed.Base64Variants.MODIFIED_FOR_URL);
            this.j2stax2.put(Base64Variants.PEM.getName(), org.codehaus.stax2.typed.Base64Variants.PEM);
        }

        public Base64Variant map(tools.jackson.core.Base64Variant j64b) {
            Base64Variant result = this.j2stax2.get(j64b.getName());
            if (result == null) {
                result = org.codehaus.stax2.typed.Base64Variants.getDefaultVariant();
            }
            return result;
        }
    }
}

