/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import com.fasterxml.jackson.annotation.JsonFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.ReflectionCache;
import tools.jackson.module.kotlin.ValueClassStaticJsonKeySerializer;
import tools.jackson.module.kotlin.ValueClassUnboxConverter;
import tools.jackson.module.kotlin.ValueClassUnboxKeySerializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltools/jackson/module/kotlin/KotlinKeySerializers;", "Ltools/jackson/databind/ser/Serializers$Base;", "cache", "Ltools/jackson/module/kotlin/ReflectionCache;", "<init>", "(Ltools/jackson/module/kotlin/ReflectionCache;)V", "findSerializer", "Ltools/jackson/databind/ValueSerializer;", "config", "Ltools/jackson/databind/SerializationConfig;", "type", "Ltools/jackson/databind/JavaType;", "beanDescRef", "Ltools/jackson/databind/BeanDescription$Supplier;", "formatOverrides", "Lcom/fasterxml/jackson/annotation/JsonFormat$Value;", "jackson-module-kotlin"})
public final class KotlinKeySerializers
extends Serializers.Base {
    @NotNull
    private final ReflectionCache cache;

    public KotlinKeySerializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Nullable
    public ValueSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription.Supplier beanDescRef, @Nullable JsonFormat.Value formatOverrides) {
        ValueSerializer valueSerializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDescRef, (String)"beanDescRef");
        Class rawClass = type.getRawClass();
        Intrinsics.checkNotNull((Object)rawClass);
        if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
            ValueClassUnboxConverter<?, ?> unboxConverter = this.cache.getValueClassUnboxConverter(rawClass);
            ValueClassStaticJsonKeySerializer<?> valueClassStaticJsonKeySerializer = ValueClassStaticJsonKeySerializer.Companion.createOrNull(unboxConverter);
            valueSerializer = (ValueSerializer)(valueClassStaticJsonKeySerializer != null ? (StdSerializer)valueClassStaticJsonKeySerializer : (StdSerializer)new ValueClassUnboxKeySerializer(unboxConverter));
        } else {
            valueSerializer = null;
        }
        return valueSerializer;
    }
}

