/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;
import one.convert.Arguments;
import one.convert.Classifier;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.EventCollector;
import one.jfr.event.ExecutionSample;
import one.jfr.event.LiveObject;
import one.jfr.event.MallocEvent;
import one.jfr.event.MallocLeakAggregator;

public abstract class JfrConverter
extends Classifier {
    protected final JfrReader jfr;
    protected final Arguments args;
    protected final EventCollector collector;
    protected Dictionary<String> methodNames;

    public JfrConverter(JfrReader jfr, Arguments args) {
        this.jfr = jfr;
        this.args = args;
        EventCollector collector = this.createCollector(args);
        this.collector = args.nativemem && args.leak ? new MallocLeakAggregator(collector, args.tail) : collector;
    }

    public void convert() throws IOException {
        this.jfr.stopAtNewChunk = true;
        while (this.jfr.hasMoreChunks()) {
            this.methodNames = new Dictionary();
            this.collector.beforeChunk();
            this.collectEvents();
            this.collector.afterChunk();
            this.convertChunk();
        }
        if (this.collector.finish()) {
            this.convertChunk();
        }
    }

    protected EventCollector createCollector(Arguments args) {
        return new EventAggregator(args.threads, args.grain);
    }

    protected void collectEvents() throws IOException {
        MallocEvent event;
        long endTicks;
        Class<MallocEvent> eventClass = this.args.nativemem ? MallocEvent.class : (this.args.live ? LiveObject.class : (this.args.alloc ? AllocationSample.class : (this.args.lock ? ContendedLock.class : ExecutionSample.class)));
        BitSet threadStates = null;
        if (this.args.state != null) {
            threadStates = new BitSet();
            for (String state : this.args.state.toUpperCase().split(",")) {
                threadStates.set(this.toThreadState(state));
            }
        } else if (this.args.cpu) {
            threadStates = this.getThreadStates(true);
        } else if (this.args.wall) {
            threadStates = this.getThreadStates(false);
        }
        long startTicks = this.args.from != 0L ? this.toTicks(this.args.from) : Long.MIN_VALUE;
        long l = endTicks = this.args.to != 0L ? this.toTicks(this.args.to) : Long.MAX_VALUE;
        while ((event = this.jfr.readEvent(eventClass)) != null) {
            if (event.time < startTicks || event.time > endTicks || threadStates != null && !threadStates.get(((ExecutionSample)((Object)event)).threadState)) continue;
            this.collector.collect(event);
        }
    }

    protected void convertChunk() {
    }

    protected int toThreadState(String name) {
        Map<Integer, String> threadStates = this.jfr.enums.get("jdk.types.ThreadState");
        if (threadStates != null) {
            for (Map.Entry<Integer, String> entry : threadStates.entrySet()) {
                if (!entry.getValue().startsWith(name, 6)) continue;
                return entry.getKey();
            }
        }
        throw new IllegalArgumentException("Unknown thread state: " + name);
    }

    protected BitSet getThreadStates(boolean cpu) {
        BitSet set = new BitSet();
        Map<Integer, String> threadStates = this.jfr.enums.get("jdk.types.ThreadState");
        if (threadStates != null) {
            for (Map.Entry<Integer, String> entry : threadStates.entrySet()) {
                set.set((int)entry.getKey(), "STATE_DEFAULT".equals(entry.getValue()) == cpu);
            }
        }
        return set;
    }

    protected long toTicks(long millis) {
        long nanos = millis * 1000000L;
        if (millis < 0L) {
            nanos += this.jfr.endNanos;
        } else if (millis < 1500000000000L) {
            nanos += this.jfr.startNanos;
        }
        return (long)((double)(nanos - this.jfr.chunkStartNanos) * ((double)this.jfr.ticksPerSec / 1.0E9)) + this.jfr.chunkStartTicks;
    }

    @Override
    public String getMethodName(long methodId, byte methodType) {
        String result = this.methodNames.get(methodId);
        if (result == null) {
            result = this.resolveMethodName(methodId, methodType);
            this.methodNames.put(methodId, result);
        }
        return result;
    }

    private String resolveMethodName(long methodId, byte methodType) {
        MethodRef method = this.jfr.methods.get(methodId);
        if (method == null) {
            return "unknown";
        }
        ClassRef cls = this.jfr.classes.get(method.cls);
        byte[] className = this.jfr.symbols.get(cls.name);
        byte[] methodName = this.jfr.symbols.get(method.name);
        if (className == null || className.length == 0 || this.isNativeFrame(methodType)) {
            return new String(methodName, StandardCharsets.UTF_8);
        }
        String classStr = this.toJavaClassName(className, 0, this.args.dot);
        if (methodName == null || methodName.length == 0) {
            return classStr;
        }
        String methodStr = new String(methodName, StandardCharsets.UTF_8);
        return classStr + '.' + methodStr;
    }

    public String getClassName(long classId) {
        ClassRef cls = this.jfr.classes.get(classId);
        if (cls == null) {
            return "null";
        }
        byte[] className = this.jfr.symbols.get(cls.name);
        int arrayDepth = 0;
        while (className[arrayDepth] == 91) {
            ++arrayDepth;
        }
        String name = this.toJavaClassName(className, arrayDepth, true);
        while (arrayDepth-- > 0) {
            name = name.concat("[]");
        }
        return name;
    }

    private String toJavaClassName(byte[] symbol, int start, boolean dotted) {
        int i;
        int end = symbol.length;
        if (start > 0) {
            switch (symbol[start]) {
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 90: {
                    return "boolean";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 76: {
                    ++start;
                    --end;
                }
            }
        }
        if (this.args.norm) {
            for (i = end - 2; i > start; --i) {
                if (symbol[i] != 47 && symbol[i] != 46) continue;
                if (symbol[i + 1] < 48 || symbol[i + 1] > 57) break;
                end = i;
                if (i <= start + 19 || symbol[i - 19] != 43 || symbol[i - 18] != 48) break;
                end = i - 19;
                break;
            }
        }
        if (this.args.simple) {
            for (i = end - 2; i >= start; --i) {
                if (symbol[i] != 47 || symbol[i + 1] >= 48 && symbol[i + 1] <= 57) continue;
                start = i + 1;
                break;
            }
        }
        String s = new String(symbol, start, end - start, StandardCharsets.UTF_8);
        return dotted ? s.replace('/', '.') : s;
    }

    public StackTraceElement getStackTraceElement(long methodId, byte methodType, int location) {
        MethodRef method = this.jfr.methods.get(methodId);
        if (method == null) {
            return new StackTraceElement("", "unknown", null, 0);
        }
        ClassRef cls = this.jfr.classes.get(method.cls);
        byte[] className = this.jfr.symbols.get(cls.name);
        byte[] methodName = this.jfr.symbols.get(method.name);
        String classStr = className == null || className.length == 0 || this.isNativeFrame(methodType) ? "" : this.toJavaClassName(className, 0, this.args.dot);
        String methodStr = methodName == null || methodName.length == 0 ? "" : new String(methodName, StandardCharsets.UTF_8);
        return new StackTraceElement(classStr, methodStr, null, location >>> 16);
    }

    public String getThreadName(int tid) {
        String threadName = this.jfr.threads.get(tid);
        return threadName == null ? "[tid=" + tid + ']' : (threadName.startsWith("[tid=") ? threadName : '[' + threadName + " tid=" + tid + ']');
    }

    protected boolean isNativeFrame(byte methodType) {
        return methodType == 3 && this.jfr.getEnumValue("jdk.types.FrameType", 5) != null || methodType == 4 || methodType == 5;
    }

    public String getValueType() {
        if (this.args.nativemem) {
            return "malloc";
        }
        if (this.args.alloc || this.args.live) {
            return "allocations";
        }
        if (this.args.lock) {
            return "locks";
        }
        return "cpu";
    }

    public String getSampleUnits() {
        return "count";
    }

    public String getTotalUnits() {
        if (this.args.nativemem || this.args.alloc || this.args.live) {
            return "bytes";
        }
        return "nanoseconds";
    }

    public double counterFactor() {
        return this.args.lock ? 1.0E9 / (double)this.jfr.ticksPerSec : 1.0;
    }

    protected abstract class AggregatedEventVisitor
    implements EventCollector.Visitor {
        private final double factor;

        protected AggregatedEventVisitor() {
            this.factor = !JfrConverter.this.args.total ? 0.0 : JfrConverter.this.counterFactor();
        }

        @Override
        public final void visit(Event event, long samples, long value) {
            this.visit(event, this.factor == 0.0 ? samples : (this.factor == 1.0 ? value : (long)((double)value * this.factor)));
        }

        protected abstract void visit(Event var1, long var2);
    }
}

