/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import one.convert.Arguments;
import one.convert.JfrConverter;
import one.heatmap.Heatmap;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventCollector;

public class JfrToHeatmap
extends JfrConverter {
    private final Heatmap heatmap;

    public JfrToHeatmap(JfrReader jfr, Arguments args) {
        super(jfr, args);
        this.heatmap = new Heatmap(args, this);
    }

    @Override
    protected EventCollector createCollector(Arguments args) {
        return new EventCollector(){

            @Override
            public void collect(Event event) {
                int extra = 0;
                byte type = 0;
                if (event instanceof AllocationSample) {
                    extra = ((AllocationSample)event).classId;
                    type = ((AllocationSample)event).tlabSize == 0L ? (byte)5 : 2;
                } else if (event instanceof ContendedLock) {
                    extra = ((ContendedLock)event).classId;
                    type = 5;
                }
                long msFromStart = (event.time - JfrToHeatmap.this.jfr.chunkStartTicks) * 1000L / JfrToHeatmap.this.jfr.ticksPerSec;
                long timeMs = JfrToHeatmap.this.jfr.chunkStartNanos / 1000000L + msFromStart;
                JfrToHeatmap.this.heatmap.addEvent(event.stackTraceId, extra, type, timeMs);
            }

            @Override
            public void beforeChunk() {
                JfrToHeatmap.this.heatmap.beforeChunk();
                JfrToHeatmap.this.jfr.stackTraces.forEach(new Dictionary.Visitor<StackTrace>(){

                    @Override
                    public void visit(long key, StackTrace trace) {
                        JfrToHeatmap.this.heatmap.addStack(key, trace.methods, trace.locations, trace.types, trace.methods.length);
                    }
                });
            }

            @Override
            public void afterChunk() {
                JfrToHeatmap.this.jfr.stackTraces.clear();
            }

            @Override
            public boolean finish() {
                JfrToHeatmap.this.heatmap.finish(JfrToHeatmap.this.jfr.startNanos / 1000000L);
                return false;
            }

            @Override
            public void forEach(EventCollector.Visitor visitor) {
                throw new AssertionError((Object)"Should not be called");
            }
        };
    }

    public void dump(OutputStream out) throws IOException {
        try (PrintStream ps = new PrintStream(out, false, "UTF-8");){
            this.heatmap.dump(ps);
        }
    }

    public static void convert(String input, String output, Arguments args) throws IOException {
        JfrToHeatmap converter;
        try (JfrReader jfr = new JfrReader(input);){
            converter = new JfrToHeatmap(jfr, args);
            converter.convert();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output));){
            converter.dump(out);
        }
    }
}

