/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.convert.Arguments;
import one.convert.Index;
import one.convert.JfrConverter;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.Event;
import one.jfr.event.EventCollector;
import one.proto.Proto;

public class JfrToOtlp
extends JfrConverter {
    private static final int MSG_LARGE = 5;
    private static final int MSG_SMALL = 1;
    private final Index<String> stringPool = new Index<String>(String.class, "");
    private final Index<String> functionPool = new Index<String>(String.class, "");
    private final Index<Line> linePool = new Index<Line>(Line.class, Line.EMPTY);
    private final Index<KeyValue> attributesPool = new Index<KeyValue>(KeyValue.class, KeyValue.EMPTY);
    private final Proto proto = new Proto(1024);

    public JfrToOtlp(JfrReader jfr, Arguments args) {
        super(jfr, args);
    }

    public void dump(OutputStream out) throws IOException {
        out.write(this.proto.buffer(), 0, this.proto.size());
    }

    @Override
    public void convert() throws IOException {
        long rpMark = this.proto.startField(1, 5);
        long spMark = this.proto.startField(2, 5);
        super.convert();
        this.proto.commitField(spMark);
        this.proto.commitField(rpMark);
        this.writeProfileDictionary();
    }

    @Override
    protected void convertChunk() {
        long pMark = this.proto.startField(2, 5);
        this.writeSampleTypes();
        this.writeTimingInformation();
        ArrayList<Integer> locationIndices = new ArrayList<Integer>();
        this.collector.forEach(new OtlpEventToSampleVisitor(locationIndices));
        long liMark = this.proto.startField(3, 5);
        locationIndices.forEach(this.proto::writeInt);
        this.proto.commitField(liMark);
        this.proto.commitField(pMark);
    }

    private void writeSampleTypes() {
        long stsMark = this.proto.startField(1, 1);
        this.proto.field(1, this.stringPool.index(this.getValueType()));
        this.proto.field(2, this.stringPool.index(this.getSampleUnits()));
        this.proto.field(3, 2);
        this.proto.commitField(stsMark);
        long sttMark = this.proto.startField(1, 1);
        this.proto.field(1, this.stringPool.index(this.getValueType()));
        this.proto.field(2, this.stringPool.index(this.getTotalUnits()));
        this.proto.field(3, 2);
        this.proto.commitField(sttMark);
    }

    private void writeTimingInformation() {
        this.proto.field(4, this.jfr.chunkStartNanos);
        this.proto.field(5, this.jfr.chunkDurationNanos());
    }

    private void writeProfileDictionary() {
        long profilesDictionaryMark = this.proto.startField(2, 5);
        long mMark = this.proto.startField(1, 1);
        this.proto.commitField(mMark);
        for (String name : this.functionPool.keys()) {
            long fMark = this.proto.startField(3, 1);
            this.proto.field(1, this.stringPool.index(name));
            this.proto.commitField(fMark);
        }
        for (Line line : this.linePool.keys()) {
            long locMark = this.proto.startField(2, 1);
            this.proto.field(1, 0);
            long lineMark = this.proto.startField(3, 1);
            this.proto.field(1, line.functionIdx);
            this.proto.field(2, line.lineNumber);
            this.proto.commitField(lineMark);
            this.proto.commitField(locMark);
        }
        for (String s : this.stringPool.keys()) {
            this.proto.field(5, s);
        }
        for (KeyValue kv : this.attributesPool.keys()) {
            long aMark = this.proto.startField(6, 5);
            this.proto.field(1, kv.key);
            long vMark = this.proto.startField(2, 5);
            this.proto.field(1, kv.value);
            this.proto.commitField(vMark);
            this.proto.commitField(aMark);
        }
        this.proto.commitField(profilesDictionaryMark);
    }

    public static void convert(String input, String output, Arguments args) throws IOException {
        JfrToOtlp converter;
        try (JfrReader jfr = new JfrReader(input);){
            converter = new JfrToOtlp(jfr, args);
            converter.convert();
        }
        try (FileOutputStream out = new FileOutputStream(output);){
            converter.dump(out);
        }
    }

    private static final class Line {
        static final Line EMPTY = new Line(0, 0);
        final int functionIdx;
        final int lineNumber;

        private Line(int functionIdx, int lineNumber) {
            this.functionIdx = functionIdx;
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Line)) {
                return false;
            }
            Line other = (Line)o;
            return this.functionIdx == other.functionIdx && this.lineNumber == other.lineNumber;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.functionIdx;
            return 31 * result + this.lineNumber;
        }
    }

    private static final class KeyValue {
        static final KeyValue EMPTY = new KeyValue("", "");
        final String key;
        final String value;

        private KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.key.hashCode();
            return 31 * result + this.value.hashCode();
        }
    }

    private final class OtlpEventToSampleVisitor
    implements EventCollector.Visitor {
        private final List<Integer> locationIndices;
        private final double factor;
        private final double ticksPerNanosecond;
        private final Map<Integer, Range> idToRange;
        private int nextLocationIdx;

        public OtlpEventToSampleVisitor(List<Integer> locationIndices) {
            this.factor = JfrToOtlp.this.counterFactor();
            this.ticksPerNanosecond = (double)JfrToOtlp.this.jfr.ticksPerSec / 1.0E9;
            this.idToRange = new HashMap<Integer, Range>();
            this.nextLocationIdx = 0;
            this.locationIndices = locationIndices;
        }

        @Override
        public void visit(Event event, long samples, long value) {
            long nanosFromStart = (long)((double)(event.time - JfrToOtlp.this.jfr.chunkStartTicks) / this.ticksPerNanosecond);
            long timeNanos = JfrToOtlp.this.jfr.chunkStartNanos + nanosFromStart;
            Range range = this.idToRange.computeIfAbsent(event.stackTraceId, this::computeLocationRange);
            long sMark = JfrToOtlp.this.proto.startField(2, 1);
            JfrToOtlp.this.proto.field(1, range.start);
            JfrToOtlp.this.proto.field(2, range.length);
            JfrToOtlp.this.proto.field(6, timeNanos);
            KeyValue threadName = new KeyValue("thread.name", JfrToOtlp.this.getThreadName(event.tid));
            JfrToOtlp.this.proto.field(4, JfrToOtlp.this.attributesPool.index(threadName));
            long svMark = JfrToOtlp.this.proto.startField(3, 1);
            JfrToOtlp.this.proto.writeLong(samples);
            JfrToOtlp.this.proto.writeLong(this.factor == 1.0 ? value : (long)((double)value * this.factor));
            JfrToOtlp.this.proto.commitField(svMark);
            JfrToOtlp.this.proto.commitField(sMark);
        }

        private Range computeLocationRange(int stackTraceId) {
            StackTrace st = JfrToOtlp.this.jfr.stackTraces.get(stackTraceId);
            if (st == null) {
                return new Range(0, 0);
            }
            for (int i = 0; i < st.methods.length; ++i) {
                this.locationIndices.add(JfrToOtlp.this.linePool.index(this.makeLine(st, i)));
            }
            Range range = new Range(this.nextLocationIdx, st.methods.length);
            this.nextLocationIdx += st.methods.length;
            return range;
        }

        private Line makeLine(StackTrace stackTrace, int i) {
            String methodName = JfrToOtlp.this.getMethodName(stackTrace.methods[i], stackTrace.types[i]);
            int lineNumber = stackTrace.locations[i] >>> 16;
            int functionIdx = JfrToOtlp.this.functionPool.index(methodName);
            return new Line(functionIdx, lineNumber);
        }
    }

    private static final class Range {
        final int start;
        final int length;

        public Range(int start, int length) {
            this.start = start;
            this.length = length;
        }
    }
}

