/*
 * Decompiled with CFR 0.152.
 */
package one.convert;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import one.convert.Arguments;
import one.convert.Index;
import one.convert.JfrConverter;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.Event;
import one.proto.Proto;

public class JfrToPprof
extends JfrConverter {
    private final Proto profile = new Proto(100000);
    private final Index<String> strings = new Index<String>(String.class, "");
    private final Index<String> functions = new Index<String>(String.class, "");
    private final Index<Long> locations = new Index<Long>(Long.class, Long.valueOf(0L));

    public JfrToPprof(JfrReader jfr, Arguments args) {
        super(jfr, args);
        this.profile.field(1, this.valueType(this.getValueType(), args.total ? this.getTotalUnits() : this.getSampleUnits())).field(13, this.strings.index("Produced by async-profiler"));
    }

    @Override
    protected void convertChunk() {
        this.collector.forEach(new JfrConverter.AggregatedEventVisitor(){
            final Proto s = new Proto(100);

            @Override
            public void visit(Event event, long value) {
                JfrToPprof.this.profile.field(2, JfrToPprof.this.sample(this.s, event, value));
                this.s.reset();
            }
        });
    }

    public void dump(OutputStream out) throws IOException {
        String[] strings;
        this.profile.field(3, this.mapping(1, 0L, Long.MAX_VALUE, "async-profiler"));
        Long[] locations = this.locations.keys();
        for (int i = 1; i < locations.length; ++i) {
            this.profile.field(4, this.location(i, locations[i]));
        }
        String[] functions = this.functions.keys();
        for (int i = 1; i < functions.length; ++i) {
            this.profile.field(5, this.function(i, functions[i]));
        }
        for (String string : strings = this.strings.keys()) {
            this.profile.field(6, string);
        }
        this.profile.field(9, this.jfr.startNanos).field(10, this.jfr.durationNanos());
        out.write(this.profile.buffer(), 0, this.profile.size());
    }

    private Proto sample(Proto s, Event event, long value) {
        StackTrace stackTrace;
        long packedLocations = s.startField(1, 3);
        long classId = event.classId();
        if (classId != 0L) {
            int function = this.functions.index(this.getClassName(classId));
            s.writeInt(this.locations.index((long)function << 16));
        }
        if ((stackTrace = this.jfr.stackTraces.get(event.stackTraceId)) != null) {
            long[] methods = stackTrace.methods;
            byte[] types = stackTrace.types;
            int[] lines = stackTrace.locations;
            for (int i = 0; i < methods.length; ++i) {
                String methodName = this.getMethodName(methods[i], types[i]);
                int function = this.functions.index(methodName);
                s.writeInt(this.locations.index((long)function << 16 | (long)(lines[i] >>> 16)));
            }
        }
        s.commitField(packedLocations);
        s.field(2, value);
        if (this.args.threads && event.tid != 0) {
            s.field(3, this.label("thread", this.getThreadName(event.tid)));
        }
        if (this.args.classify && stackTrace != null) {
            s.field(3, this.label("category", this.getCategory((StackTrace)stackTrace).title));
        }
        return s;
    }

    private Proto valueType(String type, String unit) {
        return new Proto(16).field(1, this.strings.index(type)).field(2, this.strings.index(unit));
    }

    private Proto label(String key, String str) {
        return new Proto(16).field(1, this.strings.index(key)).field(2, this.strings.index(str));
    }

    private Proto mapping(int id, long start, long limit, String fileName) {
        return new Proto(16).field(1, id).field(2, start).field(3, limit).field(5, this.strings.index(fileName));
    }

    private Proto location(int id, long location) {
        return new Proto(16).field(1, id).field(4, this.line((int)(location >>> 16), (int)location & 0xFFFF));
    }

    private Proto line(int functionId, int line) {
        return new Proto(16).field(1, functionId).field(2, line);
    }

    private Proto function(int id, String name) {
        return new Proto(16).field(1, id).field(2, this.strings.index(name));
    }

    public static void convert(String input, String output, Arguments args) throws IOException {
        JfrToPprof converter;
        try (JfrReader jfr = new JfrReader(input);){
            converter = new JfrToPprof(jfr, args);
            converter.convert();
        }
        try (FileOutputStream fos = new FileOutputStream(output);
             OutputStream out = args.output.endsWith("gz") ? new GZIPOutputStream((OutputStream)fos, 4096) : fos;){
            converter.dump(out);
        }
    }
}

