/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;
import one.convert.Index;
import one.convert.JfrConverter;
import one.heatmap.Method;
import one.jfr.Dictionary;

public class MethodCache {
    private final JfrConverter converter;
    private final Index<String> symbolTable = new Index<String>(String.class, "", 32768);
    private final Index<Method> methodIndex = new Index<Method>(Method.class, new Method(this.symbolTable.index("all"), 0), 32768);
    private final Method[] nearCache = new Method[65536];
    private final Dictionary<Method> farMethods = new Dictionary(1024);

    public MethodCache(JfrConverter converter) {
        this.converter = converter;
    }

    public void clear() {
        Arrays.fill(this.nearCache, null);
        this.farMethods.clear();
    }

    public int index(long methodId, int location, byte type, boolean firstInStack) {
        Method method;
        if (methodId < (long)this.nearCache.length) {
            int mid = (int)methodId;
            method = this.nearCache[mid];
            if (method == null) {
                this.nearCache[mid] = method = this.createMethod(methodId, location, type, firstInStack);
                method.index = this.methodIndex.index(method);
                return method.index;
            }
        } else {
            method = this.farMethods.get(methodId);
            if (method == null) {
                method = this.createMethod(methodId, location, type, firstInStack);
                this.farMethods.put(methodId, method);
                method.index = this.methodIndex.index(method);
                return method.index;
            }
        }
        Method last = null;
        Method prototype = null;
        while (method != null) {
            if (method.originalMethodId == methodId) {
                if (method.location == location && method.type == type && method.start == firstInStack) {
                    return method.index;
                }
                prototype = method;
            }
            last = method;
            method = method.next;
        }
        if (prototype != null) {
            last.next = method = new Method(methodId, prototype.className, prototype.methodName, location, type, firstInStack);
            method.index = this.methodIndex.index(method);
            return method.index;
        }
        last.next = method = this.createMethod(methodId, location, type, firstInStack);
        method.index = this.methodIndex.index(method);
        return method.index;
    }

    public int indexForClass(int extra, byte type) {
        long methodId = (long)extra << 32 | Long.MIN_VALUE;
        Method method = this.farMethods.get(methodId);
        Method last = null;
        while (method != null) {
            if (method.originalMethodId == methodId && method.location == -1 && method.type == type && !method.start) {
                return method.index;
            }
            last = method;
            method = method.next;
        }
        String javaClassName = this.converter.getClassName(extra);
        method = new Method(methodId, this.symbolTable.index(javaClassName), 0, -1, type, false);
        if (last == null) {
            this.farMethods.put(methodId, method);
        } else {
            last.next = method;
        }
        method.index = this.methodIndex.index(method);
        return method.index;
    }

    private Method createMethod(long methodId, int location, byte type, boolean firstInStack) {
        StackTraceElement ste = this.converter.getStackTraceElement(methodId, type, location);
        int className = this.symbolTable.index(ste.getClassName());
        int methodName = this.symbolTable.index(ste.getMethodName());
        return new Method(methodId, className, methodName, location, type, firstInStack);
    }

    public String[] orderedSymbolTable() {
        return this.symbolTable.keys();
    }

    public Index<Method> methodsIndex() {
        return this.methodIndex;
    }
}

