/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;

public class SampleList {
    private static final int DEFAULT_SAMPLES_COUNT = 10000000;
    private final long blockDurationMs;
    private long[] data = new long[10000000];
    private long initialTime = 0L;
    private int recordsCount = 0;

    public SampleList(long blockDurationMs) {
        this.blockDurationMs = blockDurationMs;
    }

    public void add(int stackId, long timeMs) {
        if (this.initialTime == 0L) {
            this.initialTime = timeMs;
            this.data[this.recordsCount++] = stackId;
            return;
        }
        if (this.recordsCount >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 3 / 2);
        }
        int currentTimeBlock = (int)((timeMs - this.initialTime) / this.blockDurationMs);
        this.data[this.recordsCount++] = (long)currentTimeBlock << 32 | (long)stackId;
    }

    public Result samples() {
        Arrays.sort(this.data, 0, this.recordsCount);
        int firstBlockId = (int)(this.data[0] >> 32);
        int lastBlockId = (int)(this.data[this.recordsCount - 1] >> 32);
        int blocksCount = lastBlockId - firstBlockId + 1;
        int[] blockSizes = new int[blocksCount];
        int[] stackIds = new int[this.recordsCount];
        int stackIdsPos = 0;
        int currentBlockIndex = 0;
        int currentBlockSize = 0;
        int currentBlockId = firstBlockId;
        block0: while (stackIdsPos < stackIds.length) {
            long currentData = this.data[stackIdsPos];
            int blockId = (int)(currentData >> 32);
            while (currentBlockId != blockId) {
                blockSizes[currentBlockIndex++] = currentBlockSize;
                currentBlockSize = 0;
                if (++currentBlockId <= lastBlockId) continue;
                break block0;
            }
            ++currentBlockSize;
            stackIds[stackIdsPos++] = (int)(currentData & 0xFFFFFFFFL) - 1;
        }
        if (currentBlockId <= lastBlockId) {
            blockSizes[currentBlockIndex] = currentBlockSize;
        }
        return new Result(blockSizes, stackIds);
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public static class Result {
        public final int[] blockSizes;
        public final int[] stackIds;

        public Result(int[] blockSizes, int[] stackIds) {
            this.blockSizes = blockSizes;
            this.stackIds = stackIds;
        }
    }
}

