/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;

public class StackStorage {
    protected static final int INITIAL_CAPACITY = 16384;
    private int size;
    private long[] meta;
    private int[][] values;

    public StackStorage() {
        this(16384);
    }

    public StackStorage(int initialCapacity) {
        this.meta = new long[initialCapacity * 2];
        this.values = new int[initialCapacity][];
    }

    public int[] get(int id) {
        return this.values[id - 1];
    }

    public int index(int[] stack, int stackSize) {
        long currentMeta;
        int mask = this.meta.length - 1;
        int hashCode = StackStorage.murmur(stack, stackSize);
        int i = hashCode & mask;
        while ((currentMeta = this.meta[i]) != 0L) {
            int index;
            int[] value;
            int hash = (int)currentMeta;
            if (hash == hashCode && this.equals(value = this.values[index = (int)(currentMeta >>> 32)], stack, stackSize)) {
                return index + 1;
            }
            i = i + 1 & mask;
        }
        this.values[this.size] = Arrays.copyOf(stack, stackSize);
        this.meta[i] = (long)this.size << 32 | (long)hashCode & 0xFFFFFFFFL;
        ++this.size;
        if (this.size * 2 > this.values.length) {
            this.resize(this.values.length * 2);
        }
        return this.size;
    }

    public int indexWithPrototype(int[] prototype, int append) {
        long currentMeta;
        int mask = this.meta.length - 1;
        int hashCode = StackStorage.murmurWithExtra(prototype, append);
        int i = hashCode & mask;
        while ((currentMeta = this.meta[i]) != 0L) {
            int index;
            int[] value;
            int hash = (int)currentMeta;
            if (hash == hashCode && this.equalsWithExtra(value = this.values[(index = (int)(currentMeta >>> 32)) - 1], prototype, append)) {
                return index;
            }
            i = i + 1 & mask;
        }
        int[] stack = Arrays.copyOf(prototype, prototype.length + 1);
        stack[prototype.length] = append;
        this.values[this.size] = stack;
        this.meta[i] = (long)this.size << 32 | (long)hashCode & 0xFFFFFFFFL;
        ++this.size;
        if (this.size * 2 > this.values.length) {
            this.resize(this.values.length * 2);
        }
        return this.size;
    }

    public int[][] orderedTraces() {
        return (int[][])Arrays.copyOf(this.values, this.size);
    }

    protected void resize(int newCapacity) {
        long[] newMeta = new long[newCapacity * 2];
        int mask = newMeta.length - 1;
        block0: for (long m : this.meta) {
            if (m == 0L) continue;
            int hashCode = (int)m;
            int j = hashCode & mask;
            while (true) {
                if (newMeta[j] == 0L) {
                    newMeta[j] = m;
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.meta = newMeta;
        this.values = (int[][])Arrays.copyOf(this.values, newCapacity);
    }

    private boolean equals(int[] a, int[] b, int bSize) {
        if (a.length != bSize) {
            return false;
        }
        for (int i = 0; i < bSize; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equalsWithExtra(int[] a, int[] b, int extra) {
        if (a.length != b.length + 1) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return a[b.length] == extra;
    }

    private static int murmur(int[] data, int size) {
        int m = 1540483477;
        int h = 0x9747B28C ^ data.length;
        for (int i = 0; i < size; ++i) {
            int k = data[i];
            k *= m;
            k ^= k >>> 24;
            h *= m;
            h ^= (k *= m);
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    private static int murmurWithExtra(int[] data, int extra) {
        int m = 1540483477;
        int h = 0x9747B28C ^ data.length + 1;
        for (int k : data) {
            k *= m;
            k ^= k >>> 24;
            h *= m;
            h ^= (k *= m);
        }
        int k = extra * m;
        k ^= k >>> 24;
        h *= m;
        h ^= (k *= m);
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }
}

