/*
 * Decompiled with CFR 0.152.
 */
package one.heatmap;

import java.util.Arrays;

public class SynonymTable {
    private final long[] synonyms;
    private final int[] childrenCountOrNodeSynonym;
    private final int nodesCount;
    private int synonymsCount;

    public SynonymTable(long[] synonyms, int[] childrenCount, int nodesCount) {
        this.synonyms = synonyms;
        this.childrenCountOrNodeSynonym = childrenCount;
        this.nodesCount = nodesCount;
    }

    public void calculateSynonyms() {
        int i;
        int[] childrenCount = this.childrenCountOrNodeSynonym;
        for (int i2 = 0; i2 < this.nodesCount; ++i2) {
            this.synonyms[i2] = (long)childrenCount[i2] << 32 | (long)i2;
        }
        Arrays.sort(this.synonyms, 0, this.nodesCount);
        this.synonymsCount = Math.min(3721, this.nodesCount);
        int[] nodeSynonyms = this.childrenCountOrNodeSynonym;
        for (i = 0; i < this.nodesCount; ++i) {
            nodeSynonyms[i] = this.synonymsCount + i;
        }
        for (i = 0; i < this.synonymsCount; ++i) {
            nodeSynonyms[(int)(this.synonyms[i] & 0xFFFFFFFFL)] = i;
        }
    }

    public int synonymsCount() {
        return this.synonymsCount;
    }

    public int synonymAt(int synonymIndex) {
        return (int)(this.synonyms[synonymIndex] & 0xFFFFFFFFL) + this.synonymsCount;
    }

    public int nodeIdOrSynonym(int node) {
        return this.childrenCountOrNodeSynonym[node];
    }

    public int[] reset() {
        int[] childrenCount = this.childrenCountOrNodeSynonym;
        Arrays.fill(childrenCount, 0, this.nodesCount, 0);
        return childrenCount;
    }
}

