/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

import java.util.Arrays;

public class DictionaryInt {
    private static final int INITIAL_CAPACITY = 16;
    private long[] keys;
    private int[] values;
    private int size;

    public DictionaryInt() {
        this(16);
    }

    public DictionaryInt(int initialCapacity) {
        this.keys = new long[initialCapacity];
        this.values = new int[initialCapacity];
    }

    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, 0);
        this.size = 0;
    }

    public void put(long key, int value) {
        if (key == 0L) {
            throw new IllegalArgumentException("Zero key not allowed");
        }
        int mask = this.keys.length - 1;
        int i = DictionaryInt.hashCode(key) & mask;
        while (this.keys[i] != 0L) {
            if (this.keys[i] == key) {
                this.values[i] = value;
                return;
            }
            i = i + 1 & mask;
        }
        this.keys[i] = key;
        this.values[i] = value;
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
    }

    public int get(long key) {
        int mask = this.keys.length - 1;
        int i = DictionaryInt.hashCode(key) & mask;
        while (this.keys[i] != key) {
            if (this.keys[i] == 0L) {
                throw new IllegalArgumentException("No such key: " + key);
            }
            i = i + 1 & mask;
        }
        return this.values[i];
    }

    public int get(long key, int notFound) {
        int mask = this.keys.length - 1;
        int i = DictionaryInt.hashCode(key) & mask;
        while (this.keys[i] != key) {
            if (this.keys[i] == 0L) {
                return notFound;
            }
            i = i + 1 & mask;
        }
        return this.values[i];
    }

    public void forEach(Visitor visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            visitor.visit(this.keys[i], this.values[i]);
        }
    }

    public int preallocate(int count) {
        if (count * 2 > this.keys.length) {
            this.resize(Integer.highestOneBit(count * 4 - 1));
        }
        return count;
    }

    private void resize(int newCapacity) {
        long[] newKeys = new long[newCapacity];
        int[] newValues = new int[newCapacity];
        int mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            int j = DictionaryInt.hashCode(this.keys[i]) & mask;
            while (true) {
                if (newKeys[j] == 0L) {
                    newKeys[j] = this.keys[i];
                    newValues[j] = this.values[i];
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private static int hashCode(long key) {
        return (int)((key *= -4132994306676758123L) ^ key >>> 32);
    }

    public static interface Visitor {
        public void visit(long var1, int var3);
    }
}

