/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import one.jfr.event.Event;
import one.jfr.event.EventCollector;

public class EventAggregator
implements EventCollector {
    private static final int INITIAL_CAPACITY = 1024;
    private final boolean threads;
    private final double grain;
    private Event[] keys;
    private long[] samples;
    private long[] values;
    private int size;
    private double fraction;

    public EventAggregator(boolean threads, double grain) {
        this.threads = threads;
        this.grain = grain;
        this.beforeChunk();
    }

    public int size() {
        return this.size;
    }

    @Override
    public void collect(Event e) {
        this.collect(e, e.samples(), e.value());
    }

    public void collect(Event e, long samples, long value) {
        int mask = this.keys.length - 1;
        int i = this.hashCode(e) & mask;
        while (this.keys[i] != null) {
            if (this.sameGroup(this.keys[i], e)) {
                int n = i;
                this.samples[n] = this.samples[n] + samples;
                int n2 = i;
                this.values[n2] = this.values[n2] + value;
                return;
            }
            i = i + 1 & mask;
        }
        this.keys[i] = e;
        this.samples[i] = samples;
        this.values[i] = value;
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
    }

    @Override
    public void beforeChunk() {
        if (this.keys == null || this.size > 0) {
            this.keys = new Event[1024];
            this.samples = new long[1024];
            this.values = new long[1024];
            this.size = 0;
        }
    }

    @Override
    public void afterChunk() {
        if (this.grain > 0.0) {
            this.coarsen(this.grain);
        }
    }

    @Override
    public boolean finish() {
        this.keys = null;
        this.samples = null;
        this.values = null;
        return false;
    }

    @Override
    public void forEach(EventCollector.Visitor visitor) {
        if (this.size > 0) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null) continue;
                visitor.visit(this.keys[i], this.samples[i], this.values[i]);
            }
        }
    }

    public void coarsen(double grain) {
        this.fraction = 0.0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            long s0 = this.samples[i];
            long s1 = this.round((double)s0 / grain);
            if (s1 == 0L) {
                this.keys[i] = null;
                --this.size;
            }
            this.samples[i] = s1;
            this.values[i] = (long)((double)this.values[i] * ((double)s1 / (double)s0));
        }
    }

    private long round(double d) {
        double d2;
        long r = (long)d;
        this.fraction += d - (double)r;
        if (d2 >= 1.0) {
            this.fraction -= 1.0;
            ++r;
        }
        return r;
    }

    private int hashCode(Event e) {
        return e.hashCode() + (this.threads ? e.tid * 31 : 0);
    }

    private boolean sameGroup(Event e1, Event e2) {
        return e1.stackTraceId == e2.stackTraceId && (!this.threads || e1.tid == e2.tid) && e1.sameGroup(e2);
    }

    private void resize(int newCapacity) {
        Event[] newKeys = new Event[newCapacity];
        long[] newSamples = new long[newCapacity];
        long[] newValues = new long[newCapacity];
        int mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            int j = this.hashCode(this.keys[i]) & mask;
            while (true) {
                if (newKeys[j] == null) {
                    newKeys[j] = this.keys[i];
                    newSamples[j] = this.samples[i];
                    newValues[j] = this.values[i];
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.keys = newKeys;
        this.samples = newSamples;
        this.values = newValues;
    }
}

