/*
 * Decompiled with CFR 0.152.
 */
package one.jfr.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.jfr.event.Event;
import one.jfr.event.EventCollector;
import one.jfr.event.MallocEvent;

public class MallocLeakAggregator
implements EventCollector {
    private final EventCollector wrapped;
    private final double tail;
    private final Map<Long, MallocEvent> addresses;
    private List<MallocEvent> events;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = Long.MIN_VALUE;

    public MallocLeakAggregator(EventCollector wrapped, double tail) {
        if (tail < 0.0 || tail > 1.0) {
            throw new IllegalArgumentException("tail must be between 0 and 1");
        }
        this.wrapped = wrapped;
        this.tail = tail;
        this.addresses = new HashMap<Long, MallocEvent>();
    }

    @Override
    public void collect(Event e) {
        this.events.add((MallocEvent)e);
        this.minTime = Math.min(this.minTime, e.time);
        this.maxTime = Math.max(this.maxTime, e.time);
    }

    @Override
    public void beforeChunk() {
        this.events = new ArrayList<MallocEvent>();
    }

    @Override
    public void afterChunk() {
        this.events.sort(null);
        for (MallocEvent e : this.events) {
            if (e.size > 0L) {
                this.addresses.put(e.address, e);
                continue;
            }
            this.addresses.remove(e.address);
        }
        this.events = null;
    }

    @Override
    public boolean finish() {
        long timeCutoff = (long)((double)this.minTime * this.tail + (double)this.maxTime * (1.0 - this.tail));
        this.wrapped.beforeChunk();
        for (Event event : this.addresses.values()) {
            if (event.time > timeCutoff) continue;
            this.wrapped.collect(event);
        }
        this.wrapped.afterChunk();
        this.addresses.clear();
        return true;
    }

    @Override
    public void forEach(EventCollector.Visitor visitor) {
        this.wrapped.forEach(visitor);
    }
}

