/*
 * Decompiled with CFR 0.152.
 */
package one.proto;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Proto {
    private byte[] buf;
    private int pos;

    public Proto(int capacity) {
        this.buf = new byte[capacity];
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int size() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public Proto field(int index, int n) {
        this.tag(index, 0);
        this.writeInt(n);
        return this;
    }

    public Proto field(int index, long n) {
        this.tag(index, 0);
        this.writeLong(n);
        return this;
    }

    public Proto field(int index, double d) {
        this.tag(index, 1);
        this.writeDouble(d);
        return this;
    }

    public Proto field(int index, String s) {
        this.tag(index, 2);
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.writeBytes(bytes, 0, bytes.length);
        return this;
    }

    public Proto field(int index, byte[] bytes) {
        this.tag(index, 2);
        this.writeBytes(bytes, 0, bytes.length);
        return this;
    }

    public Proto field(int index, Proto proto) {
        this.tag(index, 2);
        this.writeBytes(proto.buf, 0, proto.pos);
        return this;
    }

    public long startField(int index, int maxLenByteCount) {
        this.tag(index, 2);
        this.ensureCapacity(maxLenByteCount);
        this.pos += maxLenByteCount;
        return (long)this.pos << 32 | (long)maxLenByteCount;
    }

    public void commitField(long mark) {
        int messageStart = (int)(mark >> 32);
        int actualLength = this.pos - messageStart;
        int maxLenByteCount = (int)mark;
        if ((long)actualLength >= 1L << 7 * maxLenByteCount) {
            throw new IllegalArgumentException("Field too large");
        }
        int lenBytesStart = messageStart - maxLenByteCount;
        for (int i = 0; i < maxLenByteCount - 1; ++i) {
            this.buf[lenBytesStart + i] = (byte)(0x80 | actualLength);
            actualLength >>>= 7;
        }
        this.buf[lenBytesStart + maxLenByteCount - 1] = (byte)actualLength;
    }

    public void writeInt(int n) {
        int length = n == 0 ? 1 : (38 - Integer.numberOfLeadingZeros(n)) / 7;
        this.ensureCapacity(length);
        while (n >>> 7 != 0) {
            this.buf[this.pos++] = (byte)(0x80 | n & 0x7F);
            n >>>= 7;
        }
        this.buf[this.pos++] = (byte)n;
    }

    public void writeLong(long n) {
        int length = n == 0L ? 1 : (70 - Long.numberOfLeadingZeros(n)) / 7;
        this.ensureCapacity(length);
        while (n >>> 7 != 0L) {
            this.buf[this.pos++] = (byte)(0x80L | n & 0x7FL);
            n >>>= 7;
        }
        this.buf[this.pos++] = (byte)n;
    }

    public void writeDouble(double d) {
        this.ensureCapacity(8);
        long n = Double.doubleToRawLongBits(d);
        this.buf[this.pos] = (byte)n;
        this.buf[this.pos + 1] = (byte)(n >>> 8);
        this.buf[this.pos + 2] = (byte)(n >>> 16);
        this.buf[this.pos + 3] = (byte)(n >>> 24);
        this.buf[this.pos + 4] = (byte)(n >>> 32);
        this.buf[this.pos + 5] = (byte)(n >>> 40);
        this.buf[this.pos + 6] = (byte)(n >>> 48);
        this.buf[this.pos + 7] = (byte)(n >>> 56);
        this.pos += 8;
    }

    public void writeBytes(byte[] bytes, int offset, int length) {
        this.writeInt(length);
        this.ensureCapacity(length);
        System.arraycopy(bytes, offset, this.buf, this.pos, length);
        this.pos += length;
    }

    private void tag(int index, int type) {
        this.ensureCapacity(1);
        this.buf[this.pos++] = (byte)(index << 3 | type);
    }

    private void ensureCapacity(int length) {
        if (this.pos + length > this.buf.length) {
            int newLength = this.buf.length * 2;
            this.buf = Arrays.copyOf(this.buf, newLength < 0 ? 0x7FFFFFF0 : Math.max(newLength, this.pos + length));
        }
    }
}

