/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.vitruv.change.atomic.eobject.CreateEObject;
import tools.vitruv.change.atomic.eobject.DeleteEObject;
import tools.vitruv.change.atomic.eobject.EObjectAddedEChange;
import tools.vitruv.change.atomic.eobject.EObjectExistenceEChange;
import tools.vitruv.change.atomic.eobject.EObjectSubtractedEChange;
import tools.vitruv.change.atomic.eobject.EobjectFactory;
import tools.vitruv.change.atomic.feature.FeatureEChange;
import tools.vitruv.change.atomic.feature.FeatureFactory;
import tools.vitruv.change.atomic.feature.UnsetFeature;
import tools.vitruv.change.atomic.feature.attribute.AttributeFactory;
import tools.vitruv.change.atomic.feature.attribute.InsertEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.RemoveEAttributeValue;
import tools.vitruv.change.atomic.feature.attribute.ReplaceSingleValuedEAttribute;
import tools.vitruv.change.atomic.feature.reference.InsertEReference;
import tools.vitruv.change.atomic.feature.reference.ReferenceFactory;
import tools.vitruv.change.atomic.feature.reference.RemoveEReference;
import tools.vitruv.change.atomic.feature.reference.ReplaceSingleValuedEReference;
import tools.vitruv.change.atomic.root.InsertRootEObject;
import tools.vitruv.change.atomic.root.RemoveRootEObject;
import tools.vitruv.change.atomic.root.RootEChange;
import tools.vitruv.change.atomic.root.RootFactory;

public class TypeInferringAtomicEChangeFactory {
    private static TypeInferringAtomicEChangeFactory instance;

    protected TypeInferringAtomicEChangeFactory() {
    }

    public static TypeInferringAtomicEChangeFactory getInstance() {
        if (instance == null) {
            TypeInferringAtomicEChangeFactory _typeInferringAtomicEChangeFactory;
            instance = _typeInferringAtomicEChangeFactory = new TypeInferringAtomicEChangeFactory();
        }
        return instance;
    }

    protected void setRootChangeFeatures(RootEChange<?> change, Resource resource, URI uri, int index) {
        String _string = null;
        if (uri != null) {
            _string = uri.toString();
        }
        change.setUri(_string);
        change.setResource(resource);
        change.setIndex(index);
    }

    protected <A, F extends EStructuralFeature> void setFeatureChangeFeatures(FeatureEChange<A, F> change, A affectedEObject, F affectedFeature) {
        change.setAffectedElement(affectedEObject);
        change.setAffectedFeature(affectedFeature);
    }

    protected <T> void setNewValue(EObjectAddedEChange<T> change, T newValue) {
        change.setNewValue(newValue);
    }

    protected <T> void setOldValue(EObjectSubtractedEChange<T> change, T oldValue) {
        change.setOldValue(oldValue);
    }

    protected <A extends EObject> void setEObjectExistenceChange(EObjectExistenceEChange<A> change, A affectedEObject) {
        change.setAffectedElement(affectedEObject);
        change.setAffectedEObjectType(((EObject)change.getAffectedElement()).eClass());
        change.setIdAttributeValue(TypeInferringAtomicEChangeFactory.getID((EObject)change.getAffectedElement()));
    }

    public <T> InsertRootEObject<T> createInsertRootChange(T newValue, Resource resource, int index) {
        InsertRootEObject c = RootFactory.eINSTANCE.createInsertRootEObject();
        this.setNewValue(c, newValue);
        this.setRootChangeFeatures(c, resource, resource.getURI(), index);
        return c;
    }

    public <T> RemoveRootEObject<T> createRemoveRootChange(T oldValue, Resource resource, URI oldUri, int index) {
        RemoveRootEObject c = RootFactory.eINSTANCE.createRemoveRootEObject();
        this.setOldValue(c, oldValue);
        this.setRootChangeFeatures(c, resource, oldUri, index);
        return c;
    }

    public <T extends EObject> RemoveRootEObject<T> createRemoveRootChange(T oldValue, Resource resource, int index) {
        return this.createRemoveRootChange(oldValue, resource, resource.getURI(), index);
    }

    public <S, T> InsertEAttributeValue<S, T> createInsertAttributeChange(S affectedEObject, EAttribute affectedAttribute, int index, T newValue) {
        InsertEAttributeValue c = AttributeFactory.eINSTANCE.createInsertEAttributeValue();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedAttribute);
        c.setNewValue(newValue);
        c.setIndex(index);
        return c;
    }

    public <S, T> ReplaceSingleValuedEAttribute<S, T> createReplaceSingleAttributeChange(S affectedEObject, EAttribute affectedAttribute, T oldValue, T newValue) {
        ReplaceSingleValuedEAttribute c = AttributeFactory.eINSTANCE.createReplaceSingleValuedEAttribute();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedAttribute);
        c.setOldValue(oldValue);
        c.setNewValue(newValue);
        return c;
    }

    public <S, T> RemoveEAttributeValue<S, T> createRemoveAttributeChange(S affectedEObject, EAttribute affectedAttribute, int index, T oldValue) {
        RemoveEAttributeValue c = AttributeFactory.eINSTANCE.createRemoveEAttributeValue();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedAttribute);
        c.setOldValue(oldValue);
        c.setIndex(index);
        return c;
    }

    public <T> InsertEReference<T> createInsertReferenceChange(T affectedEObject, EReference affectedReference, T newValue, int index) {
        InsertEReference c = ReferenceFactory.eINSTANCE.createInsertEReference();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedReference);
        this.setNewValue(c, newValue);
        c.setIndex(index);
        return c;
    }

    public <T> ReplaceSingleValuedEReference<T> createReplaceSingleReferenceChange(T affectedEObject, EReference affectedReference, T oldValue, T newValue) {
        ReplaceSingleValuedEReference c = ReferenceFactory.eINSTANCE.createReplaceSingleValuedEReference();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedReference);
        this.setOldValue(c, oldValue);
        this.setNewValue(c, newValue);
        return c;
    }

    public <T> RemoveEReference<T> createRemoveReferenceChange(T affectedEObject, EReference affectedReference, T oldValue, int index) {
        RemoveEReference c = ReferenceFactory.eINSTANCE.createRemoveEReference();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedReference);
        this.setOldValue(c, oldValue);
        c.setIndex(index);
        return c;
    }

    public <A extends EObject> CreateEObject<A> createCreateEObjectChange(A affectedEObject) {
        Preconditions.checkArgument((affectedEObject != null ? 1 : 0) != 0, (Object)"affected object must not be null");
        CreateEObject c = EobjectFactory.eINSTANCE.createCreateEObject();
        this.setEObjectExistenceChange(c, affectedEObject);
        return c;
    }

    public <A extends EObject> DeleteEObject<A> createDeleteEObjectChange(A affectedEObject) {
        Preconditions.checkArgument((affectedEObject != null ? 1 : 0) != 0, (Object)"affected object must not be null");
        DeleteEObject c = EobjectFactory.eINSTANCE.createDeleteEObject();
        this.setEObjectExistenceChange(c, affectedEObject);
        return c;
    }

    public <A, F extends EStructuralFeature> UnsetFeature<A, F> createUnsetFeatureChange(A affectedEObject, F affectedFeature) {
        Preconditions.checkArgument((affectedEObject != null ? 1 : 0) != 0, (Object)"affected object must not be null");
        UnsetFeature c = FeatureFactory.eINSTANCE.createUnsetFeature();
        this.setFeatureChangeFeatures(c, affectedEObject, affectedFeature);
        return c;
    }

    private static String getID(EObject eObject) {
        EAttribute idAttribute = eObject.eClass().getEIDAttribute();
        if (idAttribute != null && !idAttribute.isDerived()) {
            return EcoreUtil.getID((EObject)eObject);
        }
        return null;
    }
}

