/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.hid;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.command.internal.ApplyEChangeSwitch;
import tools.vitruv.change.atomic.eobject.CreateEObject;
import tools.vitruv.change.atomic.eobject.EObjectExistenceEChange;
import tools.vitruv.change.atomic.feature.FeatureEChange;
import tools.vitruv.change.atomic.feature.reference.SubtractiveReferenceEChange;
import tools.vitruv.change.atomic.feature.reference.UpdateReferenceEChange;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.atomic.hid.internal.HierarchicalIdResolver;
import tools.vitruv.change.atomic.resolve.AtomicEChangeResolverHelper;
import tools.vitruv.change.atomic.root.InsertRootEObject;
import tools.vitruv.change.atomic.root.RemoveRootEObject;

public class AtomicEChangeHierarchicalIdResolver {
    private HierarchicalIdResolver idResolver;

    public AtomicEChangeHierarchicalIdResolver(ResourceSet resourceSet) {
        this.idResolver = HierarchicalIdResolver.create(resourceSet);
    }

    public EChange<EObject> resolveAndApplyForward(EChange<HierarchicalId> unresolvedEChange) {
        EChange<EObject> resolvedChange = this.resolve(unresolvedEChange);
        this.applyForward(resolvedChange);
        return resolvedChange;
    }

    public void applyBackward(EChange<EObject> resolvedEChange) {
        ApplyEChangeSwitch.applyEChange(resolvedEChange, false);
    }

    public EChange<HierarchicalId> applyForwardAndAssignIds(EChange<EObject> resolvedEChange) {
        EChange<HierarchicalId> unresolvedChange = this.unresolve(resolvedEChange);
        this.applyForward(resolvedEChange);
        return unresolvedChange;
    }

    public void endTransaction() {
        this.idResolver.endTransaction();
    }

    private EChange<EObject> resolve(EChange<HierarchicalId> unresolvedChange) {
        return AtomicEChangeResolverHelper.resolveChange(unresolvedChange, id -> {
            if (unresolvedChange instanceof CreateEObject) {
                CreateEObject createChange = (CreateEObject)unresolvedChange;
                EObject createdElement = EcoreUtil.create((EClass)createChange.getAffectedEObjectType());
                HierarchicalId createdId = this.idResolver.getAndUpdateId(createdElement);
                Preconditions.checkState((boolean)createdId.equals(id), (String)"generated ID %s does not match the original ID %s on element creation", (Object)createdId, (Object)id);
                return createdElement;
            }
            return this.idResolver.getEObject((HierarchicalId)id);
        }, resource -> this.idResolver.getResource(resource.getURI()));
    }

    private EChange<HierarchicalId> unresolve(EChange<EObject> resolvedChange) {
        return AtomicEChangeResolverHelper.resolveChange(resolvedChange, eObject -> this.idResolver.getAndUpdateId((EObject)eObject), resource -> this.idResolver.getResource(resource.getURI()));
    }

    private void applyForward(EChange<EObject> resolvedChange) {
        EObject affectedEObject = AtomicEChangeHierarchicalIdResolver.getAffectedEObject(resolvedChange);
        HierarchicalId affectedId = this.idResolver.getAndUpdateId(affectedEObject);
        EObject oldObject = AtomicEChangeHierarchicalIdResolver.getOldContainedEObject(resolvedChange);
        ApplyEChangeSwitch.applyEChange(resolvedChange, true);
        if (AtomicEChangeHierarchicalIdResolver.isContainmentChange(resolvedChange) || affectedId != this.idResolver.getAndUpdateId(affectedEObject)) {
            this.refreshIds(affectedEObject);
        }
        if (oldObject != null) {
            this.refreshIds(oldObject);
        }
    }

    private static EObject getAffectedEObject(EChange<EObject> eChange) {
        if (eChange instanceof FeatureEChange) {
            FeatureEChange featureChange = (FeatureEChange)eChange;
            return (EObject)featureChange.getAffectedElement();
        }
        if (eChange instanceof EObjectExistenceEChange) {
            EObjectExistenceEChange existenceChange = (EObjectExistenceEChange)eChange;
            return (EObject)existenceChange.getAffectedElement();
        }
        if (eChange instanceof InsertRootEObject) {
            InsertRootEObject insertChange = (InsertRootEObject)eChange;
            return (EObject)insertChange.getNewValue();
        }
        if (eChange instanceof RemoveRootEObject) {
            RemoveRootEObject removeChange = (RemoveRootEObject)eChange;
            return (EObject)removeChange.getOldValue();
        }
        throw new IllegalArgumentException("cannot identify affected EObject of change %s".formatted(eChange));
    }

    private static EObject getOldContainedEObject(EChange<EObject> eChange) {
        SubtractiveReferenceEChange subtractiveChange;
        if (eChange instanceof SubtractiveReferenceEChange && (subtractiveChange = (SubtractiveReferenceEChange)eChange).isContainment()) {
            return (EObject)subtractiveChange.getOldValue();
        }
        return null;
    }

    private static boolean isContainmentChange(EChange<EObject> eChange) {
        if (eChange instanceof UpdateReferenceEChange) {
            UpdateReferenceEChange referenceChange = (UpdateReferenceEChange)eChange;
            return referenceChange.isContainment();
        }
        return false;
    }

    private void refreshIds(EObject eObject) {
        this.idResolver.getAndUpdateId(eObject);
        eObject.eContents().forEach(this::refreshIds);
    }
}

