/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.hid.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.util.Iterator;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.atomic.hid.ObjectResolutionUtil;
import tools.vitruv.change.atomic.hid.internal.HierarchicalIdResolver;

public class HierarchicalIdResolverImpl
implements HierarchicalIdResolver {
    private static final Logger logger = LogManager.getLogger(HierarchicalIdResolverImpl.class);
    private static final String CACHE_PREFIX = "cache:/";
    private final ResourceSet resourceSet;
    private final BiMap<EObject, HierarchicalId> eObjectToId = HashBiMap.create();
    private final CacheIdsRepository cacheIds = new CacheIdsRepository();

    public HierarchicalIdResolverImpl(ResourceSet resourceSet) {
        Preconditions.checkArgument((resourceSet != null ? 1 : 0) != 0, (Object)"Resource set may not be null");
        this.resourceSet = resourceSet;
    }

    @Override
    public void endTransaction() {
        this.cleanupRemovedElements();
        Preconditions.checkState((boolean)this.cacheIds.isNoneMissing(), (Object)"there are still elements in cache although a transaction has been closed");
    }

    private void cleanupRemovedElements() {
        Iterator iterator = this.eObjectToId.keySet().iterator();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object.eResource() != null && object.eResource().getResourceSet() != null) continue;
            HierarchicalId id = (HierarchicalId)this.eObjectToId.get((Object)object);
            boolean _isCache = HierarchicalIdResolverImpl.isCache(id);
            if (_isCache) {
                this.cacheIds.push(id);
            }
            iterator.remove();
        }
    }

    @Override
    public Resource getResource(URI uri) {
        return ResourceSetUtil.getOrCreateResource((ResourceSet)this.resourceSet, (URI)uri);
    }

    @Override
    public HierarchicalId getAndUpdateId(EObject eObject) {
        HierarchicalId _xifexpression = null;
        Resource _eResource = eObject.eResource();
        boolean _tripleNotEquals = _eResource != null;
        _xifexpression = _tripleNotEquals ? this.registerObjectInResource(eObject) : this.getOrRegisterCachedObject(eObject);
        return _xifexpression;
    }

    private HierarchicalId registerObjectInResource(EObject eObject) {
        String _string = eObject.eResource().getURI().appendFragment(ObjectResolutionUtil.getHierarchicUriFragment(eObject)).toString();
        HierarchicalId id = new HierarchicalId(_string);
        this.register(id, eObject);
        return id;
    }

    private HierarchicalId getOrRegisterCachedObject(EObject eObject) {
        HierarchicalId storedId = (HierarchicalId)this.eObjectToId.get((Object)eObject);
        boolean _isCache = HierarchicalIdResolverImpl.isCache(storedId);
        if (_isCache) {
            return storedId;
        }
        HierarchicalId id = this.cacheIds.peek();
        this.register(id, eObject);
        return id;
    }

    @Override
    public EObject getEObject(HierarchicalId id) {
        EObject eObject = this.getEObjectOrNull(id);
        Preconditions.checkState((eObject != null ? 1 : 0) != 0, (String)"no EObject could be found for ID: %s", (Object)id);
        return eObject;
    }

    private EObject getEObjectOrNull(HierarchicalId id) {
        EObject _andRegisterNonStoredEObject;
        EObject _storedEObject;
        URI uri = URI.createURI((String)id.getId());
        Object _elvis = null;
        EObject _elvis_1 = null;
        EObject _elvis_2 = null;
        EObject _eObjectIfReadonlyUri = this.getEObjectIfReadonlyUri(uri);
        _elvis_2 = _eObjectIfReadonlyUri != null ? _eObjectIfReadonlyUri : (_storedEObject = this.getStoredEObject(uri));
        _elvis_1 = _elvis_2 != null ? _elvis_2 : (_andRegisterNonStoredEObject = this.getAndRegisterNonStoredEObject(uri));
        _elvis = _elvis_1 != null ? _elvis_1 : null;
        return _elvis;
    }

    private EObject getEObjectIfReadonlyUri(URI uri) {
        boolean _hasFragment;
        boolean _isReadOnly = HierarchicalIdResolverImpl.isReadOnly(uri);
        if (_isReadOnly && (_hasFragment = uri.hasFragment())) {
            return this.resourceSet.getEObject(uri, true);
        }
        return null;
    }

    private EObject getStoredEObject(URI uri) {
        BiMap _inverse = this.eObjectToId.inverse();
        String _string = uri.toString();
        HierarchicalId _hierarchicalId = new HierarchicalId(_string);
        return (EObject)_inverse.get((Object)_hierarchicalId);
    }

    private EObject getAndRegisterNonStoredEObject(URI uri) {
        EObject candidate = this.resourceSet.getEObject(uri, false);
        if (candidate != null) {
            this.getAndUpdateId(candidate);
        }
        return candidate;
    }

    private void register(HierarchicalId id, EObject eObject) {
        boolean _isCache_1;
        Preconditions.checkState((eObject != null ? 1 : 0) != 0, (Object)"object must not be null");
        boolean _isTraceEnabled = logger.isTraceEnabled();
        if (_isTraceEnabled) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Adding ID ");
            _builder.append((Object)id);
            _builder.append(" for EObject: ");
            _builder.append((Object)eObject);
            logger.trace((CharSequence)_builder);
        }
        EObject oldObject = (EObject)this.eObjectToId.inverse().get((Object)id);
        HierarchicalId oldId = (HierarchicalId)this.eObjectToId.get((Object)eObject);
        if (oldObject != null && oldObject != eObject) {
            this.eObjectToId.remove((Object)oldObject);
        }
        if (oldId != null && oldId != id) {
            this.eObjectToId.inverse().remove((Object)oldId);
        }
        this.eObjectToId.put((Object)eObject, (Object)id);
        boolean _isCache = HierarchicalIdResolverImpl.isCache(oldId);
        if (_isCache) {
            this.cacheIds.push(oldId);
        }
        if (_isCache_1 = HierarchicalIdResolverImpl.isCache(id)) {
            HierarchicalId entry = this.cacheIds.pop();
            boolean _equals = Objects.equals(id, entry);
            Preconditions.checkState((boolean)_equals, (String)"expected cache ID was %s but actually gave %s", (Object)id, (Object)entry);
        }
    }

    @Override
    public boolean hasEObject(HierarchicalId id) {
        EObject _eObjectOrNull = this.getEObjectOrNull(id);
        return _eObjectOrNull != null;
    }

    private static boolean isReadOnly(URI uri) {
        return uri != null && (URIUtil.isPathmap((URI)uri) || uri.isArchive());
    }

    private static boolean isCache(HierarchicalId id) {
        return id != null && id.getId().startsWith(CACHE_PREFIX);
    }

    public static class CacheIdsRepository {
        private final PriorityQueue<HierarchicalId> entries = new PriorityQueue();
        private int maxValue;

        public HierarchicalId pop() {
            HierarchicalId _xblockexpression = null;
            boolean _isEmpty = this.entries.isEmpty();
            if (_isEmpty) {
                int _plusPlus = this.maxValue++;
                String _plus = HierarchicalIdResolverImpl.CACHE_PREFIX + Integer.valueOf(_plusPlus);
                HierarchicalId _hierarchicalId = new HierarchicalId(_plus);
                this.push(_hierarchicalId);
            }
            _xblockexpression = this.entries.poll();
            return _xblockexpression;
        }

        public HierarchicalId peek() {
            HierarchicalId _xifexpression = null;
            boolean _isEmpty = this.entries.isEmpty();
            if (_isEmpty) {
                return new HierarchicalId(HierarchicalIdResolverImpl.CACHE_PREFIX + Integer.valueOf(this.maxValue));
            }
            _xifexpression = this.entries.peek();
            return _xifexpression;
        }

        public boolean push(HierarchicalId value) {
            boolean _xblockexpression = false;
            Preconditions.checkState((boolean)HierarchicalIdResolverImpl.isCache(value), (String)"%s is a not a cache ID", (Object)value);
            _xblockexpression = this.entries.add(value);
            return _xblockexpression;
        }

        public boolean isNoneMissing() {
            int _length = ((Object[])Conversions.unwrapArray(this.entries, Object.class)).length;
            return _length == this.maxValue;
        }
    }
}

