/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.change.atomic.resolve;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.atomic.eobject.EObjectAddedEChange;
import tools.vitruv.change.atomic.eobject.EObjectExistenceEChange;
import tools.vitruv.change.atomic.eobject.EObjectSubtractedEChange;
import tools.vitruv.change.atomic.feature.FeatureEChange;
import tools.vitruv.change.atomic.resolve.AtomicEChangeCopier;
import tools.vitruv.change.atomic.root.RootEChange;

public class AtomicEChangeResolverHelper<Source, Target> {
    private Function<Source, Target> elementResolver;
    private Function<Resource, Resource> resourceResolver;

    private AtomicEChangeResolverHelper(Function<Source, Target> elementResolver, Function<Resource, Resource> resourceResolver) {
        Preconditions.checkArgument((elementResolver != null ? 1 : 0) != 0, (Object)"resolver must not be null");
        Preconditions.checkArgument((resourceResolver != null ? 1 : 0) != 0, (Object)"resolver must not be null");
        this.elementResolver = elementResolver;
        this.resourceResolver = resourceResolver;
    }

    public static <Source, Target> EChange<Target> resolveChange(EChange<Source> eChange, Function<Source, Target> elementResolver, Function<Resource, Resource> resourceResolver) {
        return new AtomicEChangeResolverHelper<Source, Target>(elementResolver, resourceResolver).resolve(eChange);
    }

    private <F extends EStructuralFeature> void resolveFeatureEChange(FeatureEChange<Source, ?> sourceChange, FeatureEChange<Target, ?> targetChange) {
        Preconditions.checkArgument((sourceChange.getAffectedElement() != null ? 1 : 0) != 0, (String)"change %s must have an affected element", sourceChange);
        Preconditions.checkArgument((sourceChange.getAffectedFeature() != null ? 1 : 0) != 0, (String)"change %s must have an affected feature", sourceChange);
        targetChange.setAffectedElement(this.elementResolver.apply(sourceChange.getAffectedElement()));
        AtomicEChangeResolverHelper.checkNotNullAndNotProxy(targetChange.getAffectedElement(), sourceChange, "affected element");
    }

    private EChange<Target> resolve(EChange<Source> sourceChange) {
        EChange targetChange = AtomicEChangeCopier.copy(sourceChange);
        if (sourceChange instanceof FeatureEChange) {
            FeatureEChange sourceFeatureChange = (FeatureEChange)sourceChange;
            if (targetChange instanceof FeatureEChange) {
                FeatureEChange targetFeatureChange = (FeatureEChange)targetChange;
                this.resolveFeatureEChange(sourceFeatureChange, targetFeatureChange);
            }
        }
        if (sourceChange instanceof EObjectExistenceEChange) {
            EObjectExistenceEChange sourceExistenceChange = (EObjectExistenceEChange)sourceChange;
            if (targetChange instanceof EObjectExistenceEChange) {
                EObjectExistenceEChange targetExistenceChange = (EObjectExistenceEChange)targetChange;
                this.resolve(sourceExistenceChange, targetExistenceChange);
            }
        }
        if (sourceChange instanceof EObjectAddedEChange) {
            EObjectAddedEChange sourceAddedChange = (EObjectAddedEChange)sourceChange;
            if (targetChange instanceof EObjectAddedEChange) {
                EObjectAddedEChange targetAddedChange = (EObjectAddedEChange)targetChange;
                this.resolve(sourceAddedChange, targetAddedChange);
            }
        }
        if (sourceChange instanceof EObjectSubtractedEChange) {
            EObjectSubtractedEChange sourceRemoveChange = (EObjectSubtractedEChange)sourceChange;
            if (targetChange instanceof EObjectSubtractedEChange) {
                EObjectSubtractedEChange targetRemoveChange = (EObjectSubtractedEChange)targetChange;
                this.resolve(sourceRemoveChange, targetRemoveChange);
            }
        }
        if (sourceChange instanceof RootEChange) {
            RootEChange sourceRootChange = (RootEChange)sourceChange;
            if (targetChange instanceof RootEChange) {
                RootEChange targetRootChange = (RootEChange)targetChange;
                this.resolve(sourceRootChange, targetRootChange);
            }
        }
        return targetChange;
    }

    private void resolve(EObjectAddedEChange<Source> sourceChange, EObjectAddedEChange<Target> targetChange) {
        if (sourceChange.getNewValue() != null) {
            targetChange.setNewValue(this.elementResolver.apply(sourceChange.getNewValue()));
            AtomicEChangeResolverHelper.checkNotNullAndNotProxy(targetChange.getNewValue(), sourceChange, "new element");
        }
    }

    private void resolve(EObjectSubtractedEChange<Source> sourceChange, EObjectSubtractedEChange<Target> targetChange) {
        if (sourceChange.getOldValue() != null) {
            targetChange.setOldValue(this.elementResolver.apply(sourceChange.getOldValue()));
            AtomicEChangeResolverHelper.checkNotNullAndNotProxy(targetChange.getOldValue(), sourceChange, "old element");
        }
    }

    private void resolve(RootEChange<Source> sourceChange, RootEChange<Target> targetChange) {
        if (sourceChange.getResource() != null) {
            targetChange.setResource(this.resourceResolver.apply(sourceChange.getResource()));
        }
    }

    private void resolve(EObjectExistenceEChange<Source> sourceChange, EObjectExistenceEChange<Target> targetChange) {
        targetChange.setAffectedElement(this.elementResolver.apply(sourceChange.getAffectedElement()));
        AtomicEChangeResolverHelper.checkNotNullAndNotProxy(targetChange.getAffectedElement(), sourceChange, "affected element");
    }

    private static <Source, Target> void checkNotNullAndNotProxy(Target object, EChange<Source> change, String nameOfElementInChange) {
        Preconditions.checkState((object != null ? 1 : 0) != 0, (String)"%s of change %s was resolved to null", (Object)nameOfElementInChange, change);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            Preconditions.checkState((!eObject.eIsProxy() ? 1 : 0) != 0, (String)"%s of change %s was resolved to a proxy", (Object)nameOfElementInChange, object);
        }
    }
}

